/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.menu;

import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.SettingsModel;
import elgato.infrastructure.menu.ItemSelectionListener;
import elgato.infrastructure.menu.ListScreen;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.menu.MenuSymbol;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.widgets.DefaultEListCellRenderer;
import elgato.infrastructure.widgets.EListCellRenderer;
import elgato.infrastructure.widgets.EListModel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class ListButton
extends PushButton
implements ActionListener {
    private static final Resources res = Resources.getResources((class$elgato$infrastructure$menu$ListButton == null ? (class$elgato$infrastructure$menu$ListButton = ListButton.class$("elgato.infrastructure.menu.ListButton")) : class$elgato$infrastructure$menu$ListButton).getName());
    private static final Color VALUE_COLOR = res.getColor("valueColor");
    private static final Color VALUE_COLOR_DISABLED = res.getColor("valueColorDisabled");
    public static final Font VALUE_FONT = res.getFont("valueFont");
    private SettingsModel settingsModel;
    private String settingsModelProperty;
    private ModelGetter modelGetter;
    protected EListCellRenderer cellRenderer = new DefaultEListCellRenderer();
    protected ItemSelectionListener selectionListener;
    private Updater updater;
    private boolean drawSelectedItem = true;
    static /* synthetic */ Class class$elgato$infrastructure$menu$ListButton;

    public ListButton(String string, String string2, EListModel eListModel, SettingsModel settingsModel, String string3, ItemSelectionListener itemSelectionListener) {
        this(string, string2, new DirectAccessModelGetter(eListModel), settingsModel, string3, itemSelectionListener);
    }

    public ListButton(String string, String string2, ModelGetter modelGetter, SettingsModel settingsModel, String string3, ItemSelectionListener itemSelectionListener) {
        this(string, string2, settingsModel, string3);
        this.setModelGetter(modelGetter);
        this.setSelectionListener(itemSelectionListener);
    }

    public ListButton(String string, String string2, SettingsModel settingsModel, String string3) {
        super(string, string2);
        this.settingsModel = settingsModel;
        this.settingsModelProperty = string3;
        this.updater = new Updater();
        this.addActionListener(this);
    }

    public void addNotify(MenuPanel menuPanel) {
        super.addNotify(menuPanel);
        this.settingsModel.addPropertyChangeListener(this.updater);
    }

    public void removeNotify() {
        super.removeNotify();
        this.settingsModel.removePropertyChangeListener(this.updater);
    }

    public void setModelGetter(ModelGetter modelGetter) {
        this.modelGetter = modelGetter;
    }

    public void setSelectionListener(ItemSelectionListener itemSelectionListener) {
        this.selectionListener = itemSelectionListener;
    }

    public SettingsModel getSettingsModel() {
        return this.settingsModel;
    }

    public String getSettingsModelProperty() {
        return this.settingsModelProperty;
    }

    protected int getSelectedIndexFromModel() {
        return this.settingsModel.getInt(this.settingsModelProperty);
    }

    public EListModel getModel() {
        return this.modelGetter.getModel();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.getMenuPanel() != null) {
            this.getMenuPanel().getScreenManager().pushScreen(this.createPopupScreen());
        } else {
            MeasurementFactory.instance().getScreenManager().pushScreen(this.createPopupScreen());
        }
    }

    Screen createPopupScreen() {
        return new ListScreen(this.getModel(), this.getSelectedIndexFromModel(), this.selectionListener, this.getText(), this.cellRenderer);
    }

    Screen createPopupScreenWithCustomSelectButton(String string) {
        ListScreen listScreen = new ListScreen(this.getModel(), this.getSelectedIndexFromModel(), this.selectionListener, this.getText(), this.cellRenderer);
        listScreen.setSelectButtonText(string);
        return listScreen;
    }

    protected void drawExtras(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.drawSelectedItem) {
            String string = this.getSelectedItemText();
            this.drawItemText(graphics, string, n, n2, n3, n4);
        }
        this.drawMenuSymbol(graphics, n, n2, n3, n4);
    }

    public boolean isDrawSelectedItem() {
        return this.drawSelectedItem;
    }

    public void setDrawSelectedItem(boolean bl) {
        this.drawSelectedItem = bl;
    }

    protected String getSelectedItemText() {
        Object object = this.getSelectedItem();
        return object != null ? object.toString() : "???";
    }

    protected void drawItemText(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        graphics.setColor(this.isEnabled() ? VALUE_COLOR : VALUE_COLOR_DISABLED);
        graphics.setFont(VALUE_FONT);
        graphics.drawString(MenuItem.truncateToWidth(graphics.getFontMetrics(), n3, string), n, n2 + this.getNameHeight(graphics) + graphics.getFontMetrics().getHeight() * 2);
    }

    protected void drawMenuSymbol(Graphics graphics, int n, int n2, int n3, int n4) {
        MenuSymbol.draw(graphics, n, n2, n3, n4);
    }

    public Object getSelectedItem() {
        EListModel eListModel = this.getModel();
        int n = this.getSelectedIndexFromModel();
        if (n < 0 || n >= eListModel.size()) {
            return null;
        }
        return eListModel.getItem(n);
    }

    public ItemSelectionListener getSelectionListener() {
        return this.selectionListener;
    }

    public void setCellRenderer(EListCellRenderer eListCellRenderer) {
        this.cellRenderer = eListCellRenderer;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class DirectAccessModelGetter
    implements ModelGetter {
        private final EListModel model;

        public DirectAccessModelGetter(EListModel eListModel) {
            this.model = eListModel;
        }

        public EListModel getModel() {
            return this.model;
        }
    }

    public static interface ModelGetter {
        public EListModel getModel();
    }

    private class Updater
    implements PropertyChangeListener {
        private Updater() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ListButton.this.settingsModelProperty.equals(propertyChangeEvent.getPropertyName())) {
                ListButton.this.repaint();
            }
        }
    }
}

