/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.menu;

import elgato.infrastructure.html.HTMLHelpScreen;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.menu.ItemSelectionEvent;
import elgato.infrastructure.menu.ItemSelectionListener;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.util.GrayScaleColorFlipFilter;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;
import elgato.infrastructure.wheel.ScrollWheelEvent;
import elgato.infrastructure.wheel.ScrollWheelListener;
import elgato.infrastructure.wheel.ScrollWheelManager;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.ELabel;
import elgato.infrastructure.widgets.EList;
import elgato.infrastructure.widgets.EListCellRenderer;
import elgato.infrastructure.widgets.EListModel;
import elgato.infrastructure.widgets.HydroBorderPainterConfig;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.image.FilteredImageSource;
import javax.swing.JPanel;

public class ListScreen
extends Screen
implements ScrollWheelListener {
    private static final Resources res = Resources.getResources((class$elgato$infrastructure$menu$ListScreen == null ? (class$elgato$infrastructure$menu$ListScreen = ListScreen.class$("elgato.infrastructure.menu.ListScreen")) : class$elgato$infrastructure$menu$ListScreen).getName());
    protected static final Color TITLE_COLOR = res.getColor("titleColor");
    protected static final Font TITLE_FONT = res.getFont("titleFont");
    protected static final HydroBorderPainterConfig BORDER = res.getBorderConfig("border");
    protected EListModel listModel;
    protected final EListCellRenderer cellRenderer;
    protected final ItemSelectionListener selectionListener;
    protected final String title;
    protected final int initialSelectedIndex;
    public EList list;
    protected MenuItem selectButton;
    private PushButton cancelButton;
    private boolean popScreenOnSelect;
    static /* synthetic */ Class class$elgato$infrastructure$menu$ListScreen;

    public ScreenManager getScreenManager() {
        return super.getScreenManager();
    }

    public ListScreen(EListModel eListModel, int n, ItemSelectionListener itemSelectionListener, String string, EListCellRenderer eListCellRenderer, boolean bl) {
        this.listModel = eListModel;
        this.initialSelectedIndex = n;
        this.selectionListener = itemSelectionListener;
        this.title = UIHelper.stripNewlines(string);
        this.cellRenderer = eListCellRenderer;
        this.popScreenOnSelect = bl;
    }

    public ListScreen(EListModel eListModel, int n, ItemSelectionListener itemSelectionListener, String string, EListCellRenderer eListCellRenderer) {
        this(eListModel, n, itemSelectionListener, string, eListCellRenderer, true);
    }

    public void setModel(EListModel eListModel) {
        this.listModel = eListModel;
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        screenManager.getRightMenuPanel().installMenu(this.makeRightMenu());
        HTMLHelpScreen.setHelpEnabled(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new ELabel(this.title, TITLE_COLOR, TITLE_FONT), "North");
        this.list = new EList(this.listModel);
        this.list.setCellRenderer(this.cellRenderer);
        this.list.select(this.initialSelectedIndex);
        jPanel.add((Component)this.list, "Center");
        screenManager.installDisplay(new BorderWrapper(jPanel, BORDER, true));
        ScrollWheelManager.instance().addScrollWheelListener(this);
        this.selectedItemChanged();
    }

    protected Menu makeRightMenu() {
        return new Menu("", new MenuItem[]{this.makeSelectButton(Text.Select), null, null, null, null, null, this.makeCancelButton()});
    }

    public void uninstallScreen(ScreenManager screenManager) {
        ScrollWheelManager.instance().removeScrollWheelListener(this);
        HTMLHelpScreen.setHelpEnabled(true);
        super.uninstallScreen(screenManager);
    }

    protected MenuItem makeSelectButton(String string) {
        this.selectButton = new PushButton(string, this.getContextString(""), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ListScreen.this.list.getSelectedIndex();
                Object object = n != -1 ? ListScreen.this.listModel.getItem(n) : null;
                if (ListScreen.this.popScreenOnSelect) {
                    ListScreen.this.getScreenManager().popScreen();
                }
                ListScreen.this.selectionListener.itemSelected(new ItemSelectionEvent(n, object, ListScreen.this.listModel, ListScreen.this.initialSelectedIndex));
            }
        });
        return this.selectButton;
    }

    protected void selectedItemChanged() {
        this.selectButton.setEnabled(this.list.getSelectedIndex() != -1);
    }

    protected MenuItem makeCancelButton() {
        this.cancelButton = PushButton.createPopScreenCancelButton(this.getScreenManager());
        return this.cancelButton;
    }

    protected MenuItem makeBackButton() {
        return new PushButton(Text.Back, this.getContextString(""), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListScreen.this.getScreenManager().popScreen();
            }
        });
    }

    public void scrollWheelMoved(ScrollWheelEvent scrollWheelEvent) {
        if (this == this.getScreenManager().getCurrentScreen()) {
            int n = scrollWheelEvent.getUnitsMoved();
            this.scrollList(n);
            scrollWheelEvent.consume();
        }
    }

    public void scrollWheelMoveComplete() {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 38) {
            this.scrollList(-1);
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 40) {
            this.scrollList(1);
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 27) {
            this.cancelButton.press();
            keyEvent.consume();
        }
    }

    protected void scrollList(int n) {
        int n2 = this.list.getSelectedIndex() + n;
        int n3 = this.list.getItemCount() - 1;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        this.list.select(n2);
        this.selectedItemChanged();
    }

    public String getTitle() {
        return this.title;
    }

    public String getSelectButtonText() {
        return this.selectButton.getText();
    }

    public void setSelectButtonText(String string) {
        this.selectButton.setText(string);
    }

    public EListModel getListModel() {
        return this.listModel;
    }

    public void setSelectedIndex(int n) {
        this.list.select(n);
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public Image filterPrintImage(Image image, Rectangle rectangle) {
        GrayScaleColorFlipFilter grayScaleColorFlipFilter = new GrayScaleColorFlipFilter(rectangle, true, true);
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), grayScaleColorFlipFilter));
    }

    public void makeSelection() {
        this.selectButton.press();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

