/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.menu;

import elgato.gui.ModelTypeMgr;
import elgato.infrastructure.actuators.Actuator;
import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.ActuatorSubMenuButton;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.ListActuatorButton;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.actuators.TrimodeActuatorButton;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.ActionListener;
import elgato.infrastructure.menu.FrequencyChannelButtonFactory;
import elgato.infrastructure.menu.MeasurementMenuMgr;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuButton;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.MenuMgr;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.menu.SigGenButtonFactory;
import elgato.infrastructure.menu.SimpleMenuButton;
import elgato.infrastructure.menu.StateButton;
import elgato.infrastructure.menu.StateButtonGroup;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.measurement.sigGen.SigGenMeasurementSettings;
import java.awt.event.ActionEvent;

public abstract class MeasurementMenuMgr
extends MenuMgr {
    protected static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$menu$MeasurementMenuMgr == null ? (class$elgato$infrastructure$menu$MeasurementMenuMgr = MeasurementMenuMgr.class$("elgato.infrastructure.menu.MeasurementMenuMgr")) : class$elgato$infrastructure$menu$MeasurementMenuMgr);
    private Actuator averagingState;
    private FreqChanUnitsHelper freqChanUnitsHelper = null;
    private SubMenuButton sigGenSettingsMenu;
    private MenuItem channel;
    private MenuItem rf;
    private MenuItem amplitude;
    private MenuItem loss;
    private MenuItem persistant;
    private MenuItem modFormat;
    protected final ActionListener sigGenMenuChanged = new ActionListener(){
        private final String listenerName = "MenuManager.sigGenMenuChanged";

        public String getListenerName() {
            return "MenuManager.sigGenMenuChanged";
        }

        public void actionPerformed() {
            MeasurementMenuMgr.this.refreshSourceKeys();
        }
    };
    public final ValueListener sigGenSettingChanged = new ValueListener(){
        private final String listenerName = "MenuManager.sigGenSettingChanged";

        public String getListenerName() {
            return "MenuManager.sigGenSettingChanged";
        }

        public void valueChanged(ValueInterface valueInterface) {
            MeasurementMenuMgr.this.refreshSourceKeys();
        }
    };
    static /* synthetic */ Class class$elgato$infrastructure$menu$MeasurementMenuMgr;

    protected abstract String getMeasurementName();

    public MeasurementMenuMgr(MeasurementScreen measurementScreen) {
        super(measurementScreen);
    }

    public void setupFreqChanUnitsListener(Menu menu, int n) {
        this.freqChanUnitsHelper = new FreqChanUnitsHelper(menu, n);
        this.freqChanUnitsHelper.add();
        this.freqChanUnitsHelper.installProperStepButton();
    }

    protected MenuItem createFrequencyStepButton() {
        return new ActuatorEditor(DisplayGlobalMeasurementSettings.instance().getFrequencyStep(), this.getContextString("frequencyChannel.cfStep"), this.getListenerBaseName() + ".freqStepButton");
    }

    public MenuButton createAverageSweepButton(LongActuator longActuator, ListActuator listActuator) {
        return this.buildAverageSweepButton(longActuator, listActuator);
    }

    private MenuButton buildAverageSweepButton(LongActuator longActuator, ListActuator listActuator) {
        if (this.averagingState != null) {
            logger.error("should not build another button or listener will be added too many times, more that one", new Exception("Stack trace"));
        }
        this.averagingState = listActuator;
        StateButtonGroup stateButtonGroup = new StateButtonGroup();
        StateButton stateButton = new StateButton(Text.Continuous, this.getContextString("averageSweepWithCR.averageSweepContinuous"), stateButtonGroup, new Command("resume"));
        StateButton stateButton2 = new StateButton(Text.Single, this.getContextString("averageSweepWithCR.averageSweepSingle"), stateButtonGroup, new Command("single"));
        RestartButton restartButton = new RestartButton(Text.Restart, this.getContextString("averageSweepWithCR.averageSweepRestart"));
        stateButtonGroup.selectButton(stateButton);
        ActuatorEditor actuatorEditor = this.createNumAveragesButton(longActuator);
        if (ModelTypeMgr.instance().getModelType() == 0) {
            return new SimpleMenuButton(Text.Average_slash_n_Sweep, this.getContextString("averageSweepWithCR"), new Menu(Text.Average_slash_Sweep, new MenuItem[]{stateButton, stateButton2, restartButton, new ActuatorSubMenuButton(listActuator, this.getContextString("averageSweepWithCR.averageSweepAveraging"), true, this.getListenerBaseName()), actuatorEditor}, 3));
        }
        return new SubMenuButton(Text.Average_slash_n_Sweep, this.getContextString("averageSweepWithCR"), new Menu(Text.Average_slash_Sweep, new MenuItem[]{stateButton, stateButton2, restartButton, new ActuatorSubMenuButton(listActuator, this.getContextString("averageSweepWithCR.averageSweepAveraging"), true, this.getListenerBaseName()), actuatorEditor}, 3));
    }

    private ActuatorEditor createNumAveragesButton(LongActuator longActuator) {
        return new ActuatorEditor(longActuator, this.getContextString("averageSweepWithCR.averageSweepAverage"), this.getListenerBaseName() + ".numAveragesButton");
    }

    public MultiStateActuatorButton createInterferenceRejectionButton(ListActuator listActuator) {
        MultiStateActuatorButton multiStateActuatorButton = new MultiStateActuatorButton(listActuator, this.getContextString("interference.rejection"), this.getListenerBaseName());
        return multiStateActuatorButton;
    }

    public static MenuItem createFreqChanUnitsButton(String string) {
        return new MultiStateActuatorButton(DisplayGlobalMeasurementSettings.instance().getChanFreqUnits(), "units", string);
    }

    public static MenuItem createLossButton(LongActuator longActuator, LongActuator longActuator2, ListActuator listActuator, String string, String string2) {
        TrimodeActuatorButton trimodeActuatorButton = new TrimodeActuatorButton((ValueListInterface)listActuator, string, new ValueInterface[]{longActuator, longActuator2}, string2);
        trimodeActuatorButton.setReadOnlyValueIndex(1);
        return trimodeActuatorButton;
    }

    private SubMenuButton createGlobalSigGenButton() {
        MenuItem[] menuItemArray;
        boolean bl = MeasurementFactory.instance().measurementAvailable("source");
        if (bl) {
            this.channel = SigGenButtonFactory.createFrequencyButton(this.scn);
            this.rf = SigGenButtonFactory.createRfButton(this.scn);
            this.amplitude = SigGenButtonFactory.createAmplitudeButton(this.scn);
            this.loss = SigGenButtonFactory.createLossButton(this.scn);
            this.persistant = SigGenButtonFactory.createPersistButton(this.scn, Text.Enable_n_Sig_Gen);
            this.modFormat = this.createModulationFormatButton();
            menuItemArray = new MenuItem[]{this.channel, this.rf, this.amplitude, this.loss, this.persistant, this.modFormat};
        } else {
            this.channel = null;
            this.rf = null;
            this.amplitude = null;
            this.loss = null;
            this.persistant = null;
            this.modFormat = null;
            menuItemArray = new MenuItem[]{};
        }
        SubMenuButton subMenuButton = new SubMenuButton(Text.Sig_Gen, this.getContextString("sigGen"), new Menu(Text.Sig_Gen, menuItemArray), true);
        subMenuButton.getMenu().getItems()[6].setText(Text.Back);
        subMenuButton.setEnabled(bl);
        subMenuButton.addActionListener(this.sigGenMenuChanged);
        return subMenuButton;
    }

    private void refreshSourceKeys() {
        if (SigGenMeasurementSettings.instance().getBackgroundMode().intValue() == 0) {
            this.disableSourceSettings();
        } else {
            this.enableSourceSettings();
        }
    }

    public void disableSourceSettings() {
        if (this.channel != null) {
            this.channel.setEnabled(false);
            this.rf.setEnabled(false);
            this.amplitude.setEnabled(false);
            this.loss.setEnabled(false);
            this.modFormat.setEnabled(false);
        }
    }

    public void enableSourceSettings() {
        if (this.channel != null) {
            this.channel.setEnabled(true);
            this.rf.setEnabled(true);
            this.amplitude.setEnabled(true);
            this.loss.setEnabled(true);
            this.modFormat.setEnabled(true);
        }
    }

    public MenuItem createSigGenButton() {
        if (this.sigGenSettingsMenu == null) {
            this.sigGenSettingsMenu = this.createGlobalSigGenButton();
            if (MeasurementFactory.instance().measurementAvailable("source")) {
                SigGenMeasurementSettings.instance().getBackgroundMode().addValueListener(this.sigGenSettingChanged);
            }
        }
        return this.sigGenSettingsMenu;
    }

    private MenuItem createModulationFormatButton() {
        ListActuatorButton listActuatorButton = SigGenButtonFactory.createModulationFormatButton(this.scn, Text.Mod_Format);
        if (!this.modulationAvailable()) {
            listActuatorButton.setEnabled(false);
        }
        return listActuatorButton;
    }

    boolean modulationAvailable() {
        return MeasurementFactory.instance().optionAvailable("cdmaSource");
    }

    public MultiStateActuatorButton createPowerDetectorButton(ListActuator listActuator) {
        MultiStateActuatorButton multiStateActuatorButton = new MultiStateActuatorButton(listActuator, this.getContextString("powerDetector"), this.getListenerBaseName());
        String string = MeasurementFactory.instance().getComponentRevision("RcvrFPGARev");
        boolean bl = string != null && UIHelper.compareVersionNumbers(string, "0.3") >= 0;
        multiStateActuatorButton.setEnabled(bl);
        return multiStateActuatorButton;
    }

    protected MenuItem createChanStdButton() {
        return FrequencyChannelButtonFactory.createChanStdSelectButton(this.getContextString("chan.std"), this.getListenerBaseName());
    }

    protected MenuItem createFreqChanUnitsButton() {
        return MeasurementMenuMgr.createFreqChanUnitsButton(this.getListenerBaseName() + ".freqChanUnitsButton");
    }

    public void cleanup() {
        if (this.freqChanUnitsHelper != null) {
            this.freqChanUnitsHelper.remove();
            this.freqChanUnitsHelper = null;
        }
        if (this.sigGenSettingsMenu != null) {
            if (MeasurementFactory.instance().measurementAvailable("source")) {
                SigGenMeasurementSettings.instance().getBackgroundMode().removeValueListener(this.sigGenSettingChanged);
            }
            this.sigGenSettingsMenu = null;
        }
        if (this.averagingState != null) {
            this.averagingState = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class RestartButton
    extends PushButton
    implements java.awt.event.ActionListener {
        public RestartButton(String string, String string2) {
            super(string, string2);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MeasurementFactory.instance().getCommandProcessor().set(MeasurementMenuMgr.this.getMeasurementName(), "avgType", 99L);
        }
    }

    private class FreqChanUnitsHelper {
        private final Menu freqChanMenu;
        private final MenuItem freqStepButton;
        private final MenuItem chanStepButton;
        private final int stepButtonIndex;
        private final ValueListener freqChanUnitsListener = new ValueListener(this){
            private final String listenerName;
            private final /* synthetic */ FreqChanUnitsHelper this$1;
            {
                this.this$1 = freqChanUnitsHelper;
                this.listenerName = FreqChanUnitsHelper.access$000(this.this$1).getListenerBaseName() + ".freqChanUnitsListener";
            }

            public String getListenerName() {
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                EventDispatchThread.runOnEventThread("freqChanUnitsListener", new Runnable(this){
                    private final /* synthetic */ 1 this$2;
                    {
                        this.this$2 = var1_1;
                    }

                    public void run() {
                        1.access$100(this.this$2).installProperStepButton();
                    }
                });
                FreqChanUnitsHelper.access$000((FreqChanUnitsHelper)this.this$1).scn.getScreenManager().getRightMenuPanel().repaint();
            }

            static /* synthetic */ FreqChanUnitsHelper access$100(1 var0) {
                return var0.this$1;
            }
        };

        public FreqChanUnitsHelper(Menu menu, int n) {
            DisplayGlobalMeasurementSettings displayGlobalMeasurementSettings = DisplayGlobalMeasurementSettings.instance();
            this.freqChanMenu = menu;
            this.stepButtonIndex = n;
            this.chanStepButton = new ActuatorEditor(displayGlobalMeasurementSettings.getChannelStep(), MeasurementMenuMgr.this.getContextString("frequencyChannel.cfStep"), MeasurementMenuMgr.this.getListenerBaseName() + ".chanStepButton");
            this.freqStepButton = MeasurementMenuMgr.this.createFrequencyStepButton();
        }

        public void add() {
            DisplayGlobalMeasurementSettings.instance().getChanFreqUnits().addValueListener(this.freqChanUnitsListener);
        }

        public void remove() {
            DisplayGlobalMeasurementSettings.instance().getChanFreqUnits().removeValueListener(this.freqChanUnitsListener);
        }

        public void installProperStepButton() {
            DisplayGlobalMeasurementSettings displayGlobalMeasurementSettings = DisplayGlobalMeasurementSettings.instance();
            if (displayGlobalMeasurementSettings.isChannelSelected()) {
                this.freqChanMenu.setMenuItem(this.chanStepButton, this.stepButtonIndex);
            } else {
                this.freqChanMenu.setMenuItem(this.freqStepButton, this.stepButtonIndex);
            }
        }

        static /* synthetic */ MeasurementMenuMgr access$000(FreqChanUnitsHelper freqChanUnitsHelper) {
            return freqChanUnitsHelper.MeasurementMenuMgr.this;
        }
    }
}

