/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.menu;

import elgato.infrastructure.menu.MenuItem;

public class Menu {
    public static final int MAXIMUM_MENU_SIZE = 7;
    private String title;
    private MenuItem[] items;
    private int defaultItem;

    public Menu(String string, MenuItem[] menuItemArray) {
        this(string, menuItemArray, -1);
    }

    public Menu(String string, MenuItem[] menuItemArray, int n) {
        if (string == null || menuItemArray == null) {
            throw new NullPointerException();
        }
        this.title = string;
        this.items = menuItemArray;
        this.defaultItem = n;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public MenuItem[] getItems() {
        return this.items;
    }

    public int getDefaultItem() {
        return this.defaultItem;
    }

    public void setDefaultItem(int n) {
        this.defaultItem = n;
    }

    public boolean contains(MenuItem menuItem) {
        return this.itemIndex(menuItem) >= 0;
    }

    public int itemIndex(MenuItem menuItem) {
        for (int i = 0; i < this.items.length; ++i) {
            MenuItem menuItem2 = this.items[i];
            if (menuItem2 == null || !menuItem2.equals(menuItem)) continue;
            return i;
        }
        return -1;
    }

    public MenuItem setMenuItem(MenuItem menuItem, int n) {
        if (n < 0 || n >= 7) {
            return null;
        }
        if (this.items != null & this.items.length > n && this.items[n] != null) {
            this.items[n].removeNotify();
        }
        if (this.items == null) {
            this.items = new MenuItem[n + 1];
        }
        if (this.items.length < n + 1) {
            MenuItem[] menuItemArray = new MenuItem[n + 1];
            for (int i = 0; i < this.items.length; ++i) {
                menuItemArray[i] = this.items[i];
            }
            this.items = menuItemArray;
        }
        this.items[n] = menuItem;
        if (menuItem != null) {
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i] == null || this.items[i].getMenuPanel() == null) continue;
                menuItem.addNotify(this.items[i].getMenuPanel());
                break;
            }
        }
        return menuItem;
    }

    public void setEnabled(boolean bl) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            if (menuItemArray[i] == null) continue;
            menuItemArray[i].setEnabled(bl);
        }
    }
}

