/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.menu;

import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.RuntimeConfiguration;
import elgato.infrastructure.widgets.HydroBorderPainter;
import elgato.infrastructure.widgets.HydroBorderPainterConfig;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.SwingUtilities;

public abstract class MenuItem {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$menu$MenuItem == null ? (class$elgato$infrastructure$menu$MenuItem = MenuItem.class$("elgato.infrastructure.menu.MenuItem")) : class$elgato$infrastructure$menu$MenuItem);
    private static final Resources res = Resources.getResources((class$elgato$infrastructure$menu$MenuItem == null ? (class$elgato$infrastructure$menu$MenuItem = MenuItem.class$("elgato.infrastructure.menu.MenuItem")) : class$elgato$infrastructure$menu$MenuItem).getName());
    public static final HydroBorderPainterConfig BORDER_CONFIG = res.getBorderConfig("border.enabled");
    public static final HydroBorderPainterConfig BORDER_CONFIG_PRESSED = res.getBorderConfig("border.enabled.pressed");
    public static final HydroBorderPainterConfig BORDER_CONFIG_DISABLED = res.getBorderConfig("border.disabled");
    private static final Color NAME_COLOR = res.getColor("name.color");
    protected static final Color NAME_COLOR_DISABLED = res.getColor("name.color.disabled");
    private static final Font NAME_FONT = res.getFont("name.font");
    private static final int MARGIN = res.getInt("margin");
    private static final int PRESS_DEPTH = res.getInt("pressDepth");
    private Font bodyFont = res.getFont("bodyTextFont");
    private MenuPanel menuPanel;
    private boolean focused;
    private boolean enabled = true;
    private String text;
    private String[] lines;
    private String bodyText;
    private String[] bodyLines;
    private String paintedBodyText;
    private String contextId;
    private HydroBorderPainterConfig borderConfig = BORDER_CONFIG;
    private HydroBorderPainterConfig borderConfigPressed = BORDER_CONFIG_PRESSED;
    private HydroBorderPainterConfig borderConfigDisabled = BORDER_CONFIG_DISABLED;
    private Color nameColor = NAME_COLOR;
    private Color nameColorDisabled = NAME_COLOR_DISABLED;
    static /* synthetic */ Class class$elgato$infrastructure$menu$MenuItem;

    protected MenuItem(String string, String string2) {
        this.text = string;
        this.lines = MenuItem.splitLines(string);
        this.contextId = string2;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void paint(Graphics graphics, int n, int n2) {
        this.drawBorder(graphics, n, n2);
        int n3 = MARGIN - 1;
        if (this.focused) {
            n3 += PRESS_DEPTH;
        }
        graphics.setColor(this.enabled ? this.nameColor : this.nameColorDisabled);
        this.drawText(graphics, n3, n3, n, NAME_FONT, this.lines);
        int n4 = n3;
        int n5 = n3;
        int n6 = n - MARGIN * 2;
        int n7 = n2 - MARGIN * 2;
        if (this.bodyText != null) {
            this.drawBodyString(graphics, n4, n5, n6);
        }
        this.drawExtras(graphics, n4, n5, n6, n7);
    }

    private void drawBorder(Graphics graphics, int n, int n2) {
        HydroBorderPainterConfig hydroBorderPainterConfig = this.enabled ? (this.focused ? this.borderConfigPressed : this.borderConfig) : this.borderConfigDisabled;
        HydroBorderPainter.paintBorder(graphics, 0, 0, n, n2, this.focused, hydroBorderPainterConfig);
    }

    private void drawText(Graphics graphics, int n, int n2, int n3, Font font, String[] stringArray) {
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n4 = 0;
        int n5 = n2 + fontMetrics.getAscent();
        while (n4 < stringArray.length) {
            graphics.drawString(MenuItem.truncateToWidth(fontMetrics, n3, stringArray[n4]), n, n5);
            ++n4;
            n5 += fontMetrics.getHeight();
        }
    }

    protected int getNameHeight(Graphics graphics) {
        return graphics.getFontMetrics(NAME_FONT).getHeight() * this.lines.length;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!bl) {
            this.focused = false;
        }
        this.repaint();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setFocused(boolean bl) {
        this.focused = this.enabled ? bl : false;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public MenuPanel getMenuPanel() {
        return this.menuPanel;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this.lines = MenuItem.splitLines(string);
        this.repaint();
    }

    public void repaint() {
        if (this.menuPanel != null) {
            this.menuPanel.repaintItem(this);
        }
    }

    public void repaintNow() {
        if (!SwingUtilities.isEventDispatchThread()) {
            if (!RuntimeConfiguration.isUnitTestMode()) {
                logger.error("repaintNow() not invoked from EventDispatchThread, invoking repaint() instead");
            }
            this.repaint();
            return;
        }
        if (this.menuPanel != null) {
            this.menuPanel.repaintItemNow(this);
            if (logger.isDebugEnabled()) {
                logger.debug("repaintNow() complete");
            }
        }
    }

    private static String[] splitLines(String string) {
        int n = 0;
        int n2 = -1;
        while ((n2 = string.indexOf(10, n2 + 1)) >= 0) {
            ++n;
        }
        String[] stringArray = new String[n + 1];
        int n3 = 0;
        for (int i = 0; i < stringArray.length - 1; ++i) {
            int n4 = string.indexOf(10, n3);
            stringArray[i] = string.substring(n3, n4);
            n3 = n4 + 1;
        }
        stringArray[stringArray.length - 1] = string.substring(n3);
        return stringArray;
    }

    void addToPanel(MenuPanel menuPanel) {
        if (menuPanel == null) {
            throw new NullPointerException("menuPanel is null");
        }
        this.addNotify(menuPanel);
    }

    void removeFromPanel() {
        this.removeNotify();
    }

    public void addNotify(MenuPanel menuPanel) {
        this.menuPanel = menuPanel;
    }

    public void removeNotify() {
        this.menuPanel = null;
    }

    protected void drawExtras(Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public abstract void press();

    private void drawBodyString(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(this.enabled ? this.getBodyColor() : this.nameColorDisabled);
        this.paintedBodyText = this.bodyText;
        this.drawText(graphics, n, n2 + this.getNameHeight(graphics), n3, this.bodyFont, this.bodyLines);
    }

    protected static String truncateToWidth(FontMetrics fontMetrics, int n, String string) {
        if (fontMetrics.stringWidth(string) > n) {
            int n2 = fontMetrics.stringWidth("...");
            while (fontMetrics.stringWidth(string) + n2 > n) {
                string = string.substring(0, string.length() - 1);
            }
            return string + "...";
        }
        return string;
    }

    public String getPaintedBodyText() {
        return this.paintedBodyText;
    }

    public String getBodyText() {
        return this.bodyText;
    }

    public void setBodyText(String string) {
        this.bodyText = string;
        this.bodyLines = MenuItem.splitLines(string);
    }

    protected void setBodyFont(Font font) {
        this.bodyFont = font;
    }

    protected Font getBodyFont() {
        return this.bodyFont;
    }

    protected Color getBodyColor() {
        return res.getColor("bodyTextColor");
    }

    public HydroBorderPainterConfig getBorderConfig() {
        return this.borderConfig;
    }

    public void setBorderConfig(HydroBorderPainterConfig hydroBorderPainterConfig) {
        this.borderConfig = hydroBorderPainterConfig;
    }

    public HydroBorderPainterConfig getBorderConfigPressed() {
        return this.borderConfigPressed;
    }

    public void setBorderConfigPressed(HydroBorderPainterConfig hydroBorderPainterConfig) {
        this.borderConfigPressed = hydroBorderPainterConfig;
    }

    public HydroBorderPainterConfig getBorderConfigDisabled() {
        return this.borderConfigDisabled;
    }

    public void setBorderConfigDisabled(HydroBorderPainterConfig hydroBorderPainterConfig) {
        this.borderConfigDisabled = hydroBorderPainterConfig;
    }

    public Color getNameColor() {
        return this.nameColor;
    }

    public void setNameColor(Color color) {
        this.nameColor = color;
    }

    public Color getNameColorDisabled() {
        return this.nameColorDisabled;
    }

    public void setNameColorDisabled(Color color) {
        this.nameColorDisabled = color;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

