/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.menu;

import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.RuntimeConfiguration;
import elgato.infrastructure.util.UIHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class MenuPanel
extends JComponent {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$menu$MenuPanel == null ? (class$elgato$infrastructure$menu$MenuPanel = MenuPanel.class$("elgato.infrastructure.menu.MenuPanel")) : class$elgato$infrastructure$menu$MenuPanel);
    private static final Resources res = Resources.getResources((class$elgato$infrastructure$menu$MenuPanel == null ? (class$elgato$infrastructure$menu$MenuPanel = MenuPanel.class$("elgato.infrastructure.menu.MenuPanel")) : class$elgato$infrastructure$menu$MenuPanel).getName());
    private static final int NUM_BUTTONS = 7;
    private static final int BUTTON_HEIGHT = 52;
    private static final int WIDTH = 75;
    public static final Color BG_COLOR = res.getColor("bgcolor");
    private static final int FOOTER_HEIGHT = res.getInt("footer.height");
    private static final int TITLE_HEIGHT = res.getInt("title.height");
    private static final Color TITLE_FG = res.getColor("title.color");
    private static final Font TITLE_FONT = res.getFont("title.font");
    private static FontMetrics TITLE_FONT_M;
    static final Cursor inMenuItemCursor;
    static final Cursor outMenuItemCursor;
    private String footer;
    private Color gpsDotColor;
    private ScreenManager screenManager;
    private MenuPanel otherMenu;
    private Menu menu;
    private int selectedIndex = -1;
    private boolean buttonsEnabled = true;
    private static final Icon ICON_X;
    private static final Icon ICON_O;
    private static final Icon ICON_TRIANGLE;
    static /* synthetic */ Class class$elgato$infrastructure$menu$MenuPanel;

    public MenuPanel(ScreenManager screenManager) {
        this.screenManager = screenManager;
        this.setBackground(null);
        this.addMouseListener(new menuPanelMouseHandler());
        this.addMouseMotionListener(new menuPanelMouseMotionHandler());
    }

    void repaintItem(MenuItem menuItem) {
        Rectangle rectangle = this.getButtonRect(menuItem);
        if (rectangle != null) {
            this.repaint(rectangle);
        }
    }

    void repaintItemNow(MenuItem menuItem) {
        Rectangle rectangle = this.getButtonRect(menuItem);
        if (rectangle != null) {
            this.paintImmediately(rectangle);
        }
    }

    private int indexOf(MenuItem menuItem) {
        if (this.menu != null) {
            MenuItem[] menuItemArray = this.menu.getItems();
            for (int i = 0; i < menuItemArray.length; ++i) {
                if (menuItemArray[i] != menuItem) continue;
                return i;
            }
        }
        logger.error("Item does not exist in menu: " + menuItem);
        return -1;
    }

    private Rectangle getButtonRect(MenuItem menuItem) {
        int n = this.indexOf(menuItem);
        if (n < 0) {
            return null;
        }
        int n2 = TITLE_HEIGHT + n * this.buttonOffset(this.getHeight());
        return new Rectangle(0, n2, 75, 52);
    }

    public void repaintNow() {
        if (!SwingUtilities.isEventDispatchThread()) {
            if (!RuntimeConfiguration.isUnitTestMode()) {
                logger.error("repaintNow() not invoked from EventDispatchThread, invoking repaint() instead");
            }
            this.repaint();
            return;
        }
        this.paintImmediately(new Rectangle(this.getSize()));
    }

    protected void paintComponent(Graphics graphics) {
        if (this.menu == null) {
            return;
        }
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        int n3 = this.buttonOffset(n2);
        int n4 = TITLE_HEIGHT;
        Rectangle rectangle = graphics.getClipBounds();
        this.drawTitle(graphics, rectangle, n);
        this.drawFooter(graphics, rectangle, n2);
        MenuItem[] menuItemArray = this.menu.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            if (rectangle.y < n4 + 52 && rectangle.y + rectangle.height > n4) {
                graphics.translate(0, n4);
                graphics.setClip(0, 0, 75, 52);
                if (menuItemArray[i] != null) {
                    menuItemArray[i].paint(graphics, 75, 52);
                }
                graphics.translate(0, -n4);
            }
            n4 += n3;
        }
    }

    private int buttonOffset(int n) {
        int n2 = (n - 364 - TITLE_HEIGHT - FOOTER_HEIGHT) / 6;
        return 52 + n2;
    }

    private void drawTitle(Graphics graphics, Rectangle rectangle, int n) {
        if (rectangle.y >= TITLE_HEIGHT) {
            return;
        }
        graphics.setFont(TITLE_FONT);
        if (TITLE_FONT_M == null) {
            TITLE_FONT_M = graphics.getFontMetrics();
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n, TITLE_HEIGHT);
        int n2 = TITLE_HEIGHT - (TITLE_FONT_M.getDescent() + TITLE_FONT_M.getHeight() / 3);
        String string = UIHelper.stripNewlines(this.menu.getTitle());
        if (this.getBackground() == BG_COLOR) {
            graphics.setColor(TITLE_FG);
        } else {
            graphics.setColor(Color.black);
        }
        graphics.drawString(string, (n - TITLE_FONT_M.stringWidth(string)) / 2, n2);
    }

    private void repaintFooter() {
        int n = this.getHeight();
        this.repaint(0, n - FOOTER_HEIGHT, 75, FOOTER_HEIGHT);
    }

    private void drawFooter(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = 2;
        int n3 = n - 7;
        if (rectangle.y + rectangle.height < n - FOOTER_HEIGHT) {
            return;
        }
        graphics.setFont(TITLE_FONT);
        if (TITLE_FONT_M == null) {
            TITLE_FONT_M = graphics.getFontMetrics();
        }
        if (this.getBackground() == BG_COLOR) {
            graphics.setColor(TITLE_FG);
        } else {
            graphics.setColor(Color.black);
        }
        graphics.drawString(this.getFooter(), n2, n3);
        int n4 = TITLE_FONT_M.stringWidth(this.getFooter()) + 5;
        int n5 = n2 + n4;
        int n6 = n3 - 7;
        this.drawFooterIcon(graphics, n5, n6);
    }

    private void drawFooterIcon(Graphics graphics, int n, int n2) {
        Color color = this.getGpsDotColor();
        graphics.setColor(color);
        if (color != null) {
            Icon icon = null;
            if (color == Color.green) {
                icon = ICON_O;
            } else if (color == Color.red) {
                icon = ICON_X;
            } else if (color == Color.yellow) {
                icon = ICON_TRIANGLE;
            }
            if (icon != null) {
                icon.paintIcon(this, graphics, n, n2);
            }
        }
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String string) {
        if (!string.equals(this.footer)) {
            this.footer = string;
            this.repaintFooter();
        }
    }

    public Color getGpsDotColor() {
        return this.gpsDotColor;
    }

    public void setGpsDotColor(Color color) {
        if (!color.equals(this.gpsDotColor)) {
            this.gpsDotColor = color;
            this.repaintFooter();
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(75, 1);
    }

    public void installMenu(Menu menu) {
        this.screenManager.uninstallField();
        MenuItem[] menuItemArray = menu.getItems();
        if (menuItemArray.length > 7) {
            throw new IllegalArgumentException("Too many menu items");
        }
        this.removeAllMenuItems();
        this.menu = menu;
        for (int i = 0; i < menuItemArray.length; ++i) {
            this.addMenuItem(menuItemArray[i]);
        }
        this.selectedIndex = -1;
        this.focusButton(menu.getDefaultItem());
        this.repaint();
    }

    public void clear() {
        this.installMenu(new Menu("", new MenuItem[0]));
    }

    private void addMenuItem(MenuItem menuItem) {
        boolean bl;
        if (menuItem == null) {
            return;
        }
        boolean bl2 = bl = menuItem.getMenuPanel() == null;
        if (bl) {
            menuItem.addNotify(this);
            menuItem.setFocused(false);
        }
    }

    private void removeAllMenuItems() {
        if (this.menu != null) {
            MenuItem[] menuItemArray = this.menu.getItems();
            for (int i = 0; i < menuItemArray.length; ++i) {
                MenuItem menuItem = menuItemArray[i];
                if (menuItem == null) continue;
                this.removeMenuItem(menuItem);
            }
        }
    }

    private void removeMenuItem(MenuItem menuItem) {
        menuItem.removeNotify();
    }

    public void setOtherMenu(MenuPanel menuPanel) {
        this.otherMenu = menuPanel;
    }

    public MenuPanel getOtherMenu() {
        return this.otherMenu;
    }

    public void setButtonsEnabled(boolean bl) {
        if (bl != this.buttonsEnabled) {
            this.buttonsEnabled = bl;
            if (!bl) {
                this.focusButton(null);
            }
            if (this.menu != null) {
                MenuItem[] menuItemArray = this.menu.getItems();
                for (int i = 0; i < menuItemArray.length; ++i) {
                    if (menuItemArray[i] == null) continue;
                    menuItemArray[i].setEnabled(bl);
                }
            }
            this.repaint();
        }
    }

    public void invokeButton(int n) {
        MenuItem[] menuItemArray;
        if (this.buttonsEnabled && n < (menuItemArray = this.menu.getItems()).length && menuItemArray[n] != null && menuItemArray[n].isEnabled()) {
            menuItemArray[n].press();
        }
    }

    public MenuItem getSelectedItem() {
        if (this.menu == null || this.selectedIndex < 0) {
            return null;
        }
        MenuItem[] menuItemArray = this.menu.getItems();
        return menuItemArray[this.selectedIndex];
    }

    public void focusButton(MenuItem menuItem) {
        if (menuItem != null && !this.menu.contains(menuItem)) {
            throw new IllegalArgumentException("focusButton called on an item that is not in the current menu: " + menuItem + ": text=" + menuItem.getText());
        }
        this.focusButton(this.itemIndex(menuItem));
    }

    public void focusButton(int n) {
        MenuItem menuItem;
        if (this.selectedIndex >= 0) {
            menuItem = this.getSelectedItem();
            menuItem.setFocused(false);
            menuItem.repaint();
        }
        this.selectedIndex = n;
        if (this.selectedIndex >= 0) {
            menuItem = this.getSelectedItem();
            menuItem.setFocused(true);
            menuItem.repaint();
        }
    }

    private int itemIndex(MenuItem menuItem) {
        if (this.menu == null) {
            return -1;
        }
        return this.menu.itemIndex(menuItem);
    }

    public void setMenuItem(MenuItem menuItem, int n) {
        MenuItem menuItem2;
        if (this.menu.getItems().length > n && (menuItem2 = this.menu.getItems()[n]) != null) {
            menuItem2.removeFromPanel();
        }
        if (this.menu.setMenuItem(menuItem, n) != null) {
            menuItem.addToPanel(this);
            menuItem.setFocused(false);
            if (n == this.selectedIndex) {
                this.selectedIndex = -1;
                this.focusButton(menuItem);
            }
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.menu.setEnabled(bl);
    }

    public MenuItem[] getMenuItems() {
        return this.menu.getItems();
    }

    public Menu getMenu() {
        return this.menu;
    }

    public ScreenManager getScreenManager() {
        return this.screenManager;
    }

    int pointToMenuItem(Point point) {
        if (this.menu == null) {
            return -1;
        }
        MenuItem[] menuItemArray = this.menu.getItems();
        Rectangle rectangle = new Rectangle(0, TITLE_HEIGHT, 75, 52);
        int n = this.getSize().height;
        int n2 = (n - 364 - TITLE_HEIGHT - FOOTER_HEIGHT) / 6;
        for (int i = 0; i < menuItemArray.length; ++i) {
            if (menuItemArray[i] != null && rectangle.contains(point)) {
                if (menuItemArray[i].isEnabled()) {
                    return i;
                }
                return -1;
            }
            rectangle.y += 52 + n2;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        inMenuItemCursor = new Cursor(12);
        outMenuItemCursor = new Cursor(0);
        ICON_X = new XIcon();
        ICON_O = new OIcon();
        ICON_TRIANGLE = new TriangleIcon();
    }

    private static class TriangleIcon
    implements Icon {
        private static final int[] xpts = new int[]{0, 8, 4};
        private static final int[] ypts = new int[]{8, 8, 0};

        private TriangleIcon() {
        }

        public int getIconHeight() {
            return 9;
        }

        public int getIconWidth() {
            return 9;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            graphics.fillPolygon(xpts, ypts, xpts.length);
            graphics.translate(-n, -n2);
        }
    }

    private static class OIcon
    implements Icon {
        private static final int W = 9;
        private static final int H = 9;

        private OIcon() {
        }

        public int getIconHeight() {
            return 9;
        }

        public int getIconWidth() {
            return 9;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.fillOval(n, n2, 9, 9);
        }
    }

    private static class XIcon
    implements Icon {
        private static final int W = 9;
        private static final int H = 9;
        private static final int MX = 8;
        private static final int MY = 8;
        private static final int T = 2;
        private static final int[] xpts1 = new int[]{0, 2, 8, 8, 6, 0};
        private static final int[] ypts = new int[]{0, 0, 6, 8, 8, 2};
        private static final int[] xpts2 = new int[xpts1.length];

        private XIcon() {
        }

        public int getIconHeight() {
            return 9;
        }

        public int getIconWidth() {
            return 9;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            graphics.fillPolygon(xpts1, ypts, ypts.length);
            graphics.fillPolygon(xpts2, ypts, ypts.length);
            graphics.translate(-n, -n2);
        }

        static {
            for (int i = 0; i < xpts1.length; ++i) {
                XIcon.xpts2[i] = 8 - xpts1[i];
            }
        }
    }

    private class menuPanelMouseMotionHandler
    extends MouseMotionAdapter {
        private menuPanelMouseMotionHandler() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = MenuPanel.this.pointToMenuItem(mouseEvent.getPoint());
            if (n >= 0) {
                MenuPanel.this.setCursor(inMenuItemCursor);
            } else {
                MenuPanel.this.setCursor(outMenuItemCursor);
            }
        }
    }

    private class menuPanelMouseHandler
    extends MouseAdapter {
        private menuPanelMouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = MenuPanel.this.pointToMenuItem(mouseEvent.getPoint());
            if (n >= 0) {
                MenuPanel.this.invokeButton(n);
            }
        }
    }
}

