/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.menu;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListInterface;
import elgato.infrastructure.valueobject.ValueListener;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class RangeControlMenuButton
extends SubMenuButton {
    private ListActuator rangeHold;
    private ValueListener rangeHoldListener;

    public RangeControlMenuButton(final Screen screen, ListActuator listActuator, LongActuator longActuator) {
        super(Text.Range_Ctrl, screen.getContextString("rangeContorl"), new Menu(Text.Range_Ctrl, new MenuItem[0]));
        this.rangeHold = listActuator;
        RangeHoldButton rangeHoldButton = new RangeHoldButton(this.rangeHold, screen.getContextString("rangeHold"), screen.getListenerBaseName());
        final UpButton upButton = new UpButton(longActuator, Text.Range_Up, screen.getContextString("range.up"));
        final DownButton downButton = new DownButton(longActuator, "\n\n" + Text.Range_Down, screen.getContextString("range.down"));
        this.rangeHoldListener = new ValueListener(){
            private final String listenerName;
            {
                this.listenerName = screen.getListenerBaseName() + ".rangeHoldListener";
            }

            public String getListenerName() {
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                boolean bl = valueInterface.intValue() == 1;
                upButton.setEnabled(bl);
                downButton.setEnabled(bl);
            }
        };
        Menu menu = this.getMenu();
        menu.setMenuItem(rangeHoldButton, 0);
        menu.setMenuItem(upButton, 1);
        menu.setMenuItem(downButton, 2);
        menu.getItems()[6].setText(Text.Back);
    }

    private class DownButton
    extends PushButton
    implements ActionListener {
        int[] xPts = null;
        int[] yPts = null;
        LongActuator upDownActuator;

        public DownButton(LongActuator longActuator, String string, String string2) {
            super(string, string2);
            this.upDownActuator = longActuator;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.upDownActuator.setValue(-1);
            this.upDownActuator.send();
        }

        protected void drawExtras(Graphics graphics, int n, int n2, int n3, int n4) {
            super.drawExtras(graphics, n, n2, n3, n4);
            if (this.xPts == null) {
                int n5 = 32;
                int n6 = n5 / 4;
                int n7 = 10;
                int n8 = n7 / 2;
                int n9 = (n3 - n5) / 2;
                int n10 = n4 / 2 - n7;
                int n11 = n9 + n;
                int n12 = n10 + n2;
                this.xPts = new int[]{n11 + 2 * n6, n11 + 4 * n6, n11 + 3 * n6, n11 + 3 * n6, n11 + n6, n11 + n6, n11};
                this.yPts = new int[]{n12 + (n7 + n8), n12 + n8, n12 + n8, n12, n12, n12 + n8, n12 + n8};
            }
            graphics.fillPolygon(this.xPts, this.yPts, this.xPts.length);
        }
    }

    private class UpButton
    extends PushButton
    implements ActionListener {
        int[] xPts = null;
        int[] yPts = null;
        LongActuator upDownActuator;

        public UpButton(LongActuator longActuator, String string, String string2) {
            super(string, string2);
            this.upDownActuator = longActuator;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.upDownActuator.setValue(1);
            this.upDownActuator.send();
        }

        protected void drawExtras(Graphics graphics, int n, int n2, int n3, int n4) {
            super.drawExtras(graphics, n, n2, n3, n4);
            if (this.xPts == null) {
                int n5 = 32;
                int n6 = n5 / 4;
                int n7 = 10;
                int n8 = n7 / 2;
                int n9 = (n3 - n5) / 2;
                int n10 = n4 / 2;
                int n11 = n9 + n;
                int n12 = n10 + n2;
                this.xPts = new int[]{n11 + 2 * n6, n11, n11 + n6, n11 + n6, n11 + 3 * n6, n11 + 3 * n6, n11 + 4 * n6};
                this.yPts = new int[]{n12, n12 + n7, n12 + n7, n12 + (n7 + n8), n12 + (n7 + n8), n12 + n7, n12 + n7};
            }
            graphics.fillPolygon(this.xPts, this.yPts, this.xPts.length);
        }
    }

    private class RangeHoldButton
    extends MultiStateActuatorButton {
        public RangeHoldButton(ValueListInterface valueListInterface, String string, String string2) {
            super(valueListInterface, string, string2 + ".rangeHoldButton");
        }

        public void addNotify(MenuPanel menuPanel) {
            RangeControlMenuButton.this.rangeHold.addValueListener(RangeControlMenuButton.this.rangeHoldListener);
            RangeControlMenuButton.this.rangeHold.fireValueChanged();
            super.addNotify(menuPanel);
        }

        public void removeNotify() {
            RangeControlMenuButton.this.rangeHold.removeValueListener(RangeControlMenuButton.this.rangeHoldListener);
            super.removeNotify();
        }
    }
}

