/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.menu;

import elgato.infrastructure.commChannel.HardwareEventListener;
import elgato.infrastructure.mainScreens.ProductFactory;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.menu.MenuSymbol;
import elgato.infrastructure.menu.PushButton;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class ScreenButton
extends PushButton
implements ActionListener,
HardwareEventListener {
    private final boolean push;
    private final boolean bOverAirButton;

    private ScreenButton(String string, boolean bl) {
        super(string, "");
        this.push = bl;
        this.bOverAirButton = false;
        this.addActionListener(this);
    }

    private ScreenButton(String string, boolean bl, boolean bl2) {
        super(string, "");
        this.push = bl;
        this.bOverAirButton = bl2;
        this.addActionListener(this);
    }

    public static ScreenButton newLoadingButton(String string, String string2) {
        if (!MeasurementFactory.instance().validMeasurementType(string2)) {
            return null;
        }
        MeasurementScreenButton measurementScreenButton = new MeasurementScreenButton(string, false, string2, false);
        return measurementScreenButton;
    }

    public static ScreenButton newLoadingButton(String string, String string2, boolean bl) {
        if (!MeasurementFactory.instance().validMeasurementType(string2)) {
            return null;
        }
        MeasurementScreenButton measurementScreenButton = new MeasurementScreenButton(string, false, string2, bl);
        return measurementScreenButton;
    }

    private static void enabledBasedOnAvailability(ScreenButton screenButton, String string) {
        screenButton.setEnabled(MeasurementFactory.instance().measurementAvailable(string));
    }

    public static ScreenButton newPushingButton(String string, Screen screen) {
        return new NonMeasurementScreenButton(string, true, screen);
    }

    public static ScreenButton newPushingButtonWithArrow(String string, Screen screen) {
        return new NonMeasurementScreenButton(string, true, screen){

            protected void drawExtras(Graphics graphics, int n, int n2, int n3, int n4) {
                super.drawExtras(graphics, n, n2, n3, n4);
                MenuSymbol.draw(graphics, n, n2, n3, n4);
            }
        };
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Screen screen = this.getScreen();
        if (screen != null) {
            ScreenManager screenManager = this.getMenuPanel().getScreenManager();
            ProductFactory.bOverAirTest = this.bOverAirButton;
            if (this.push) {
                screenManager.pushScreen(screen);
            } else {
                screenManager.loadScreen(screen);
            }
        }
    }

    protected abstract Screen getScreen();

    public abstract /* synthetic */ void hardwareFailed();

    private static class NonMeasurementScreenButton
    extends ScreenButton {
        private final Screen screen;

        public NonMeasurementScreenButton(String string, boolean bl, Screen screen) {
            super(string, bl);
            this.screen = screen;
        }

        protected Screen getScreen() {
            return this.screen;
        }

        public void hardwareFailed() {
        }
    }

    private static class MeasurementScreenButton
    extends ScreenButton {
        private final String measurementType;

        public MeasurementScreenButton(String string, boolean bl, String string2, boolean bl2) {
            super(string, bl, bl2);
            this.measurementType = string2;
        }

        public void addNotify(MenuPanel menuPanel) {
            super.addNotify(menuPanel);
            ScreenButton.enabledBasedOnAvailability((ScreenButton)this, this.measurementType);
            MeasurementFactory.instance().getCommandProcessor().addHardwareFailureListener(this);
        }

        public void removeNotify() {
            super.removeNotify();
            MeasurementFactory.instance().getCommandProcessor().removeHardwareFailureListener(this);
        }

        protected Screen getScreen() {
            return MeasurementFactory.instance().getScreenForMeasurementType(this.measurementType);
        }

        public void hardwareFailed() {
            ScreenButton.enabledBasedOnAvailability((ScreenButton)this, this.measurementType);
            this.repaint();
        }
    }
}

