/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.menu;

import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.ListActuatorButton;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.menu.MenuItem;
import elgato.measurement.sigGen.SigGenMeasurementSettings;

public class SigGenButtonFactory {
    private static SigGenMeasurementSettings sigGenMeasurementSettings = SigGenMeasurementSettings.instance();

    public static ActuatorEditor createFrequencyButton(Screen screen) {
        return new ActuatorEditor(SigGenMeasurementSettings.instance().getCenterFrequency(), screen.getContextString("frequency"), screen.getListenerBaseName() + ".cfButton");
    }

    public static ActuatorEditor createAmplitudeButton(Screen screen) {
        return new ActuatorEditor(SigGenMeasurementSettings.instance().getAmplitude(), screen.getContextString("amplitude"), screen.getListenerBaseName() + ".amplitudeButton");
    }

    public static MultiStateActuatorButton createRfButton(Screen screen) {
        return new MultiStateActuatorButton(sigGenMeasurementSettings.getRFOnOff(), screen.getContextString("rf"), screen.getListenerBaseName() + ".rfOnButton");
    }

    public static MenuItem createLossButton(Screen screen) {
        return MeasurementScreen.createLossButton(sigGenMeasurementSettings.getStashedLoss(), sigGenMeasurementSettings.getRfOutLoss(), sigGenMeasurementSettings.getLossToggle(), screen.getContextString("rf.out.loss"), screen.getListenerBaseName() + ".RfOutLossButton");
    }

    public static MultiStateActuatorButton createPersistButton(Screen screen, String string) {
        MultiStateActuatorButton multiStateActuatorButton = new MultiStateActuatorButton(SigGenMeasurementSettings.instance().getBackgroundMode(), screen.getContextString("backGroundMode"), screen.getListenerBaseName() + ".persistButton");
        multiStateActuatorButton.setText(string);
        return multiStateActuatorButton;
    }

    public static ListActuatorButton createModulationFormatButton(Screen screen, String string) {
        ListActuatorButton listActuatorButton = new ListActuatorButton(SigGenMeasurementSettings.instance().getModulationFormat(), screen.getContextString("format"), screen.getListenerBaseName() + ".modFormatButton");
        listActuatorButton.setText(string);
        return listActuatorButton;
    }
}

