/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.menu;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.StateButtonGroup;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class StateButton
extends MenuItem {
    private StateButtonGroup group;
    private Command commandToSend;

    public StateButton(String string, String string2, StateButtonGroup stateButtonGroup, Command command) {
        super(string, string2);
        this.group = stateButtonGroup;
        this.commandToSend = command;
    }

    public void press() {
        this.group.selectButton(this);
        MeasurementFactory.instance().getCommandProcessor().send(this.commandToSend);
    }

    public boolean isHighlighted() {
        return this.group.isSelected(this);
    }

    protected void drawExtras(Graphics graphics, int n, int n2, int n3, int n4) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = n - 1;
        int n6 = n2 + fontMetrics.getAscent() + fontMetrics.getLeading() / 2;
        if (this.isHighlighted()) {
            graphics.setColor(Color.black);
            String string = this.getText();
            graphics.fillRect(n5, n2, fontMetrics.stringWidth(string) + 2, fontMetrics.getHeight() + 2);
            graphics.setColor(Color.white);
            graphics.drawString(string, n, n6);
        }
    }

    public StateButtonGroup getGroup() {
        return this.group;
    }
}

