/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.menu;

import elgato.infrastructure.html.HTMLHelpScreen;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.menu.SimpleMenuButton;
import elgato.infrastructure.util.Text;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class SubMenuButton
extends SimpleMenuButton {
    final int CANCEL_BUTTON_MENU_LOCATION = 6;
    private Menu previousMenu;
    private PushButton cancelButton;
    private ActionListener cancelButtonListener;
    private boolean helpEnabled = false;

    public SubMenuButton(String string, String string2, Menu menu) {
        this(string, string2, menu, false);
    }

    public SubMenuButton(String string, String string2, Menu menu, boolean bl) {
        super(string, string2, menu);
        this.helpEnabled = bl;
    }

    public SubMenuButton(String string, String string2) {
        super(string, string2);
    }

    protected void setMenu(Menu menu) {
        super.setMenu(menu);
        this.ensureNoItemAtCancelLocation();
        this.cancelButton = new PushButton(Text.Cancel, "cancel"){

            public void addNotify(MenuPanel menuPanel) {
                HTMLHelpScreen.setHelpEnabled(SubMenuButton.this.helpEnabled);
                super.addNotify(menuPanel);
            }

            public void removeNotify() {
                HTMLHelpScreen.setHelpEnabled(true);
                super.removeNotify();
            }
        };
        menu.setMenuItem(this.cancelButton, 6);
    }

    public void installMenu(MenuPanel menuPanel) {
        this.addCancelListeners(menuPanel);
        this.previousMenu = menuPanel.getMenu();
        menuPanel.installMenu(this.getMenu());
    }

    private void addCancelListeners(final MenuPanel menuPanel) {
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                menuPanel.installMenu(SubMenuButton.this.previousMenu);
            }
        });
        if (this.cancelButtonListener != null) {
            this.cancelButton.addActionListener(this.cancelButtonListener);
        }
    }

    private void ensureNoItemAtCancelLocation() {
        if (this.getMenu().getItems().length == 7) {
            MenuItem menuItem = this.getMenu().getItems()[6];
        }
    }

    public String getSubText() {
        return this.getBodyText();
    }

    public void setSubText(String string) {
        if (string == null) {
            string = "";
        }
        this.setBodyText(string);
        this.repaint();
    }

    public void setCancelButtonTitle(String string) {
        this.cancelButton.setText(string);
    }

    public void setCancelButtonActionListener(ActionListener actionListener) {
        if (this.cancelButtonListener != null) {
            throw new IllegalStateException("A cancel listener has already been set on this SubMenuButton");
        }
        this.cancelButtonListener = actionListener;
    }

    public PushButton getCancelButton() {
        return this.cancelButton;
    }
}

