/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.menu;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.ListActuatorButton;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.widgets.DefaultEListCellRenderer;
import elgato.measurement.timeFreqRef.TimeFreqRefMeasurementSettings;

public class TimeFreqRefButtonFactory {
    public static ListActuatorButton createTimeFreqRefButton(String string) {
        ListActuator listActuator = TimeFreqRefMeasurementSettings.instance().getTimeFreqRef();
        ListActuatorButton listActuatorButton = new ListActuatorButton(listActuator, "freq.time.ref", string + ".timeFreqRefButton");
        listActuatorButton.setCellRenderer(new FreqTimeColumnRenderer());
        return listActuatorButton;
    }

    public static class FreqTimeColumnRenderer
    extends DefaultEListCellRenderer {
        public FreqTimeColumnRenderer() {
            super(new int[]{50, 50});
        }

        protected String[] columnValues(Object object) {
            Value value = (Value)object;
            return new String[]{value.getLongLabel(), this.makeFrequencyTimeLabel(value.intValue())};
        }

        private String makeFrequencyTimeLabel(int n) {
            if (n == 30 || n == 31) {
                return Text.Frequency_ampersand_Time;
            }
            return Text.Frequency_Only;
        }
    }
}

