/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.metrics;

import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.metrics.MetricsTable;
import elgato.infrastructure.metrics.MetricsTableModel;
import elgato.infrastructure.metrics.ValueSource;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.tablelayout.TableLayoutConstraints;
import elgato.infrastructure.widgets.Glue;
import java.awt.Color;
import java.awt.Component;

public abstract class BasicMeasurementMetrics
extends MeasurementMetrics {
    protected static final Color BG_COLOR = Color.darkGray;
    private ValueSource[][] valueSources = this.createValueSources();
    private Measurement measurement;
    private MetricsTable[] metricsTables;

    public BasicMeasurementMetrics() {
        TableLayout tableLayout = new TableLayout(new float[][]{new float[0], {-2.0f}});
        this.setLayout(tableLayout);
        int n = -1;
        this.metricsTables = new MetricsTable[this.valueSources.length];
        for (int i = 0; i < this.valueSources.length; ++i) {
            tableLayout.insertColumn(++n, -1.0f);
            this.metricsTables[i] = new MetricsTable(new MetricsTableModel(this.valueSources[i]));
            this.add((Component)this.metricsTables[i], TableLayoutConstraints.newCell(n, 0));
            if (i == this.valueSources.length - 1) continue;
            tableLayout.insertColumn(++n, this.getBarLeftMargin());
            tableLayout.insertColumn(++n, 1.0f);
            this.add((Component)new Glue(1, 1, BG_COLOR), TableLayoutConstraints.newCell(n, 0));
            tableLayout.insertColumn(++n, this.getBarRightMargin());
        }
    }

    public BasicMeasurementMetrics(float[] fArray) {
        if (fArray.length != this.valueSources.length) {
            throw new IllegalArgumentException("tableColumnWidths.length must be the same as valueSources.length.");
        }
        TableLayout tableLayout = new TableLayout(new float[][]{new float[0], {-2.0f}});
        this.setLayout(tableLayout);
        int n = -1;
        this.metricsTables = new MetricsTable[this.valueSources.length];
        for (int i = 0; i < this.valueSources.length; ++i) {
            tableLayout.insertColumn(++n, fArray[i]);
            this.metricsTables[i] = new MetricsTable(new MetricsTableModel(this.valueSources[i]));
            this.add((Component)this.metricsTables[i], TableLayoutConstraints.newCell(n, 0));
            if (i == this.valueSources.length - 1) continue;
            tableLayout.insertColumn(++n, this.getBarLeftMargin());
            tableLayout.insertColumn(++n, 1.0f);
            this.add((Component)new Glue(1, 1, BG_COLOR), TableLayoutConstraints.newCell(n, 0));
            tableLayout.insertColumn(++n, this.getBarRightMargin());
        }
    }

    public void dispose() {
        this.measurement = null;
        this.valueSources = null;
        this.metricsTables = null;
    }

    protected abstract ValueSource[][] createValueSources();

    protected int getBarLeftMargin() {
        return 2;
    }

    protected int getBarRightMargin() {
        return 2;
    }

    public TabDelimitable[] getTabDelimitables() {
        int n = 0;
        for (int i = 0; i < this.valueSources.length; ++i) {
            ValueSource[] valueSourceArray = this.valueSources[i];
            n += valueSourceArray.length;
        }
        TabDelimitable[] tabDelimitableArray = new TabDelimitable[n];
        int n2 = 0;
        for (int i = 0; i < this.valueSources.length; ++i) {
            ValueSource[] valueSourceArray = this.valueSources[i];
            for (int j = 0; j < valueSourceArray.length; ++j) {
                ValueSource valueSource = valueSourceArray[j];
                tabDelimitableArray[n2++] = valueSource;
            }
        }
        return tabDelimitableArray;
    }

    public void setMeasurement(Measurement measurement) {
        this.measurement = measurement;
        boolean bl = this.isMeasurementValid();
        for (int i = 0; i < this.valueSources.length; ++i) {
            ValueSource[] valueSourceArray = this.valueSources[i];
            for (int j = 0; j < valueSourceArray.length; ++j) {
                valueSourceArray[j].compute(bl);
            }
        }
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    public MetricsTable[] getMetricsTables() {
        return this.metricsTables;
    }

    public ValueSource[][] getValueSource() {
        return this.valueSources;
    }

    public ValueSource getValueSource(int n, int n2) {
        return this.valueSources[n][n2];
    }

    protected boolean isMeasurementValid() {
        return true;
    }

    protected class ReadingValueSource
    extends ValueSource {
        private final int readingId;
        private boolean ignoreValidFlag;

        public ReadingValueSource(String string, NumberFieldStrategy numberFieldStrategy, boolean bl, int n) {
            super(string, numberFieldStrategy, bl);
            this.readingId = n;
        }

        protected long getRawValue() {
            return BasicMeasurementMetrics.this.measurement.getLongReadingValue(this.readingId);
        }

        public void compute(boolean bl) {
            if (this.ignoreValidFlag) {
                super.compute(true);
            } else {
                super.compute(bl);
            }
        }

        public ReadingValueSource setIgnoreValidFlag(boolean bl) {
            this.ignoreValidFlag = bl;
            return this;
        }
    }
}

