/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.metrics;

import elgato.infrastructure.metrics.TechnicolorTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.table.TableModel;

public class MetricsTable
extends JComponent {
    private static final int ASCENT = 12;
    private static final int ROW_HEIGHT = 16;
    private TechnicolorTableModel model;
    private Font metricsFont = new Font("SansSerif", 0, 12);
    LabelColumn[] columns;

    public MetricsTable(TechnicolorTableModel technicolorTableModel) {
        this(technicolorTableModel, null);
    }

    public MetricsTable(TechnicolorTableModel technicolorTableModel, LabelColumn[] labelColumnArray) {
        this.model = technicolorTableModel;
        if (labelColumnArray == null) {
            if (technicolorTableModel.getColumnCount() != 3) {
                throw new IllegalArgumentException("Columns must be explicitly specified for other than 3 columns");
            }
            labelColumnArray = new LabelColumn[]{new LabelColumn(), new ValueColumn(), new UnitsColumn()};
        }
        this.columns = labelColumnArray;
        if (labelColumnArray.length != technicolorTableModel.getColumnCount()) {
            throw new IllegalArgumentException("# of columns inconsistent");
        }
        for (int i = 0; i < labelColumnArray.length; ++i) {
            LabelColumn labelColumn = labelColumnArray[i];
            labelColumn.setModel(technicolorTableModel);
            labelColumn.setMetricsTable(this);
        }
        this.setPreferredSize(new Dimension(480, 16 * this.model.getRowCount()));
    }

    public void setMetricsFont(Font font) {
        this.metricsFont = font;
    }

    public Font getMetricsFont() {
        return this.metricsFont;
    }

    protected void paintComponent(Graphics graphics) {
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            int n = 0;
            int n2 = this.columns[i].getX(graphics);
            for (int j = 0; j < this.model.getRowCount(); ++j) {
                this.columns[i].draw(this, graphics, this.model.getValueAt(j, i), this.model.getColorAt(j, i), n2, n);
                n += 16;
            }
        }
    }

    public static class ValueColumn
    extends LabelColumn {
        public int getX(Graphics graphics) {
            return this.getUnitsX(graphics);
        }

        public void draw(Component component, Graphics graphics, Object object, Color color, int n, int n2) {
            super.draw(component, graphics, object, color, n - this.itemWidth(graphics, object), n2);
        }
    }

    public static class UnitsColumn
    extends LabelColumn {
        public int getX(Graphics graphics) {
            return this.getUnitsX(graphics) + 4;
        }
    }

    public static class LabelColumn {
        protected static final int GAP = 4;
        private int maxUnitsWidth = 30;
        protected TableModel model;
        protected MetricsTable metricsTable;

        public void setModel(TableModel tableModel) {
            this.model = tableModel;
        }

        public void setMetricsTable(MetricsTable metricsTable) {
            this.metricsTable = metricsTable;
        }

        public void draw(Component component, Graphics graphics, Object object, Color color, int n, int n2) {
            if (object instanceof Icon) {
                Icon icon = (Icon)object;
                icon.paintIcon(component, graphics, n, n2);
            } else {
                graphics.setFont(this.metricsTable.getMetricsFont());
                graphics.setColor(color);
                graphics.drawString(String.valueOf(object), n, n2 + 12);
            }
        }

        protected int itemWidth(Graphics graphics, Object object) {
            if (object instanceof Icon) {
                return ((Icon)object).getIconWidth();
            }
            return this.stringWidth(graphics, object.toString());
        }

        protected int getUnitsX(Graphics graphics) {
            int n = this.getMaxColumnWidth(graphics, 2);
            if (n == 0) {
                n = this.maxUnitsWidth;
            } else {
                this.maxUnitsWidth = n;
            }
            return graphics.getClipBounds().width - (n + 4);
        }

        private int getMaxColumnWidth(Graphics graphics, int n) {
            int n2 = 0;
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                Object object = this.model.getValueAt(i, n);
                int n3 = this.itemWidth(graphics, object);
                if (n2 >= n3) continue;
                n2 = n3;
            }
            return n2;
        }

        protected int stringWidth(Graphics graphics, String string) {
            return graphics.getFontMetrics().stringWidth(string);
        }

        public int getX(Graphics graphics) {
            return 4;
        }
    }
}

