/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.metrics;

import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.util.Resources;
import java.awt.Color;

public abstract class ValueSource
implements TabDelimitable {
    public static final String NOT_MEASURED = "-----";
    public static final String NO_UNITS = "";
    public static final long NO_VALUE = -333000L;
    public static final Color DARK_BLUE = Resources.getResources("elgato/gui").getColor("darkBlue");
    private String label;
    private boolean recognizeMinus333000;
    protected final String[] result = new String[2];
    private NumberFieldStrategy strategy;
    protected boolean isMeasurementValid;
    protected boolean validValue;

    public ValueSource(String string, NumberFieldStrategy numberFieldStrategy, boolean bl) {
        this.strategy = numberFieldStrategy;
        this.label = string;
        this.recognizeMinus333000 = bl;
    }

    public void compute(boolean bl) {
        long l = this.getRawValue();
        this.isMeasurementValid = bl;
        boolean bl2 = this.validValue = !this.isInvalidValue(l);
        if (bl && this.validValue) {
            this.strategy.formatWithUnits(this.cookValue(l), this.result);
        } else {
            this.dashMetric();
        }
    }

    protected boolean isInvalidValue(long l) {
        return this.recognizeMinus333000 && l == -333000L || l == Integer.MAX_VALUE || l == Integer.MIN_VALUE;
    }

    protected void dashMetric() {
        this.result[0] = NOT_MEASURED;
        this.result[1] = NO_UNITS;
    }

    protected abstract long getRawValue();

    protected long cookValue(long l) {
        return l;
    }

    protected String getFormattedValue() {
        return this.result[0];
    }

    protected String getFormattedUnits() {
        return this.result[1];
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public Color getLabelColor() {
        return this.getColor(DARK_BLUE);
    }

    public Color getValueColor() {
        return this.getColor(Color.black);
    }

    public Color getInvalidColor() {
        return Color.gray;
    }

    private Color getColor(Color color) {
        if (this.isMeasurementValid() && this.isValueValid()) {
            return color;
        }
        return this.getInvalidColor();
    }

    protected final void setResultsEmpty() {
        this.result[0] = NO_UNITS;
        this.result[1] = NO_UNITS;
    }

    public boolean isMeasurementValid() {
        return this.isMeasurementValid;
    }

    public boolean isValueValid() {
        return this.validValue;
    }

    public String toTabDelimitedString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getLabel()).append('\t').append(this.getFormattedValue()).append('\t').append(this.getFormattedUnits());
        return stringBuffer.toString();
    }

    public void setResultFormat(NumberFieldStrategy numberFieldStrategy) {
        this.strategy = numberFieldStrategy;
    }
}

