/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.peakSearch;

import elgato.infrastructure.analyzer.IndexToValueMapper;
import elgato.infrastructure.peakSearch.ActivityFinder;

public class DiscreteActivityFinder
implements ActivityFinder {
    int iMaxPeakIndex;
    private final int maxPeaks;
    private long[] peakXValues;
    private int peakCount;

    public DiscreteActivityFinder(int n) {
        this.maxPeaks = n;
    }

    public void processTrace(int[] nArray, int n, int n2, IndexToValueMapper indexToValueMapper) {
        this.processTrace(nArray, indexToValueMapper);
    }

    public void processTrace(int[] nArray, IndexToValueMapper indexToValueMapper) {
        int n;
        this.peakCount = 0;
        int[] nArray2 = new int[this.maxPeaks];
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] <= 0) continue;
            if (n == this.iMaxPeakIndex) {
                this.iMaxPeakIndex = this.peakCount;
            }
            nArray2[this.peakCount++] = n;
        }
        this.peakXValues = new long[this.peakCount];
        for (n = 0; n < this.peakCount; ++n) {
            this.peakXValues[n] = indexToValueMapper.getXValueForIndex(nArray2[n]);
        }
    }

    public void setMaxPeakIndex(int n) {
        this.iMaxPeakIndex = n;
    }

    public int getMaxPeakIndex() {
        return this.iMaxPeakIndex;
    }

    public int getNumPeaks() {
        return this.peakCount;
    }

    public long getPeakXValue(int n) {
        return this.peakXValues[n];
    }

    public int findPeakIndex(long l) {
        int n = 0;
        int n2 = this.peakCount - 1;
        for (int i = 0; i < n2; ++i) {
            if (l < this.peakXValues[i] || l >= this.peakXValues[i + 1]) continue;
            n = i;
            break;
        }
        if (l >= this.peakXValues[n2]) {
            n = n2;
        }
        return n;
    }
}

