/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.peakSearch;

import elgato.infrastructure.analyzer.IndexToValueMapper;
import elgato.infrastructure.peakSearch.PeakFinder;

public class DiscretePeakFinder
implements PeakFinder {
    protected final int maxPeaks;
    protected long[] peakXValues;
    protected int peakCount;
    private int iFirstPeakIndex;

    public DiscretePeakFinder(int n) {
        this.maxPeaks = n;
    }

    public void processTrace(int[] nArray, int n, int n2, IndexToValueMapper indexToValueMapper) {
        int n3;
        boolean bl = false;
        this.peakCount = 0;
        int[] nArray2 = new int[this.maxPeaks];
        int n4 = Integer.MAX_VALUE;
        while (this.peakCount < this.maxPeaks && (n3 = this.findNextValueNotGreaterThan(n4, nArray2, nArray, n, n2)) >= 0) {
            if (!bl) {
                this.iFirstPeakIndex = n3;
            }
            bl = true;
            nArray2[this.peakCount++] = n3;
            n4 = nArray[n3];
        }
        this.peakXValues = new long[this.peakCount];
        for (n3 = 0; n3 < this.peakCount; ++n3) {
            this.peakXValues[n3] = indexToValueMapper.getXValueForIndex(nArray2[n3]);
        }
    }

    public int getFirstPeakIndex() {
        return this.iFirstPeakIndex;
    }

    private int findNextValueNotGreaterThan(int n, int[] nArray, int[] nArray2, int n2, int n3) {
        int n4 = 0;
        int n5 = -1;
        int n6 = n2 + n3;
        block0: for (int i = n2; i < n6; ++i) {
            int n7 = nArray2[i];
            if (n7 > n || n5 != -1 && n7 <= n4) continue;
            for (int j = 0; j < this.peakCount; ++j) {
                int n8 = nArray[j];
                if (i == n8) continue block0;
            }
            n4 = n7;
            n5 = i;
        }
        return n5;
    }

    public int getNumPeaks() {
        return this.peakCount;
    }

    public long getPeakXValue(int n) {
        return this.peakXValues[n];
    }

    public int getIndexForAbsoluteValue(long l) {
        for (int i = 0; i < this.peakXValues.length; ++i) {
            if (this.peakXValues[i] != l) continue;
            return i;
        }
        return -1;
    }
}

