/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.peakSearch;

import elgato.infrastructure.analyzer.IndexToValueMapper;
import elgato.infrastructure.peakSearch.PeakFinder;
import elgato.infrastructure.util.Arrays;
import elgato.infrastructure.util.Comparator;
import elgato.infrastructure.util.FastMath;
import java.util.Vector;

public class EverestPeakFinder
implements PeakFinder {
    private static final int MAX_PEAKS = 32;
    private int smoothingFilterWidth;
    private int minPeakHeight;
    private int traceStart;
    private int traceEnd;
    private final Vector peaks = new Vector();
    private int minValue;
    private int maxValue;
    private long[] peakXValues;
    private int iFirstPeakIndex;

    public EverestPeakFinder() {
        this(2, 7);
    }

    public EverestPeakFinder(int n, int n2) {
        this.smoothingFilterWidth = n;
        this.minPeakHeight = n2;
    }

    public void processTrace(int[] nArray, int n, int n2, IndexToValueMapper indexToValueMapper) {
        boolean bl = false;
        int[] nArray2 = EverestPeakFinder.getMinMax(nArray, n, n2);
        this.minValue = nArray2[0];
        this.maxValue = nArray2[1];
        this.traceStart = n;
        this.traceEnd = n + n2 - 1;
        int[] nArray3 = new int[nArray.length];
        FastMath.movingAverage(nArray, n, nArray3, n, n2, this.smoothingFilterWidth);
        this.findPeaks(nArray, nArray3, this.traceStart, this.traceEnd);
        Object[] objectArray = new Peak[this.peaks.size()];
        this.peaks.copyInto(objectArray);
        this.peaks.removeAllElements();
        Arrays.sort(objectArray, new PeakComparator(nArray));
        int n3 = Math.min(objectArray.length, 32);
        this.peakXValues = new long[n3];
        for (int i = 0; i < n3; ++i) {
            Object object = objectArray[i];
            if (!bl) {
                this.iFirstPeakIndex = ((Peak)object).peakIndex;
            }
            bl = true;
            this.peakXValues[i] = indexToValueMapper.getXValueForIndex(((Peak)object).peakIndex);
        }
    }

    private void findPeaks(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 2) {
            return;
        }
        Peak peak = this.scanForPeak(nArray, nArray2, n, n2);
        if (peak != null && !this.peakExists(peak)) {
            this.addPeak(peak);
            this.findPeaks(nArray, nArray2, this.findFirstPeakEndBelow(peak.start), peak.start);
            this.findPeaks(nArray, nArray2, peak.end, this.findFirstPeakStartAbove(peak.end));
        }
    }

    private boolean peakExists(Peak peak) {
        for (int i = 0; i < this.peaks.size(); ++i) {
            Peak peak2 = (Peak)this.peaks.elementAt(i);
            if (peak2.peakIndex != peak.peakIndex) continue;
            return true;
        }
        return false;
    }

    private void addPeak(Peak peak) {
        this.peaks.addElement(peak);
    }

    private Peak scanForPeak(int[] nArray, int[] nArray2, int n, int n2) {
        int n3;
        int n4;
        int n5 = -1;
        int n6 = Integer.MIN_VALUE;
        for (n4 = n; n4 <= n2; ++n4) {
            if (nArray[n4] <= n6 || !this.localMaximum(n4, nArray)) continue;
            n5 = n4;
            n6 = nArray[n4];
        }
        if (n5 < 0) {
            return null;
        }
        n5 = this.centerOnPlateau(n5, nArray);
        n4 = n;
        int n7 = Integer.MAX_VALUE;
        for (n3 = n5; n3 >= n; --n3) {
            if (nArray2[n3] < n7) {
                n7 = nArray2[n3];
            }
            if (nArray2[n3] <= n7 + this.minPeakHeight * (this.maxValue - this.minValue) / 256) continue;
            n4 = n3;
            break;
        }
        n3 = n2;
        int n8 = Integer.MAX_VALUE;
        for (n7 = n5; n7 <= n2; ++n7) {
            if (nArray2[n7] < n8) {
                n8 = nArray2[n7];
            }
            if (nArray2[n7] <= n8 + this.minPeakHeight * (this.maxValue - this.minValue) / 256) continue;
            n3 = n7;
            break;
        }
        return new Peak(n5, n4, n3);
    }

    private int centerOnPlateau(int n, int[] nArray) {
        int n2;
        int n3;
        int n4 = nArray[n];
        for (n3 = n; n3 >= this.traceStart && nArray[n3] == n4; --n3) {
        }
        for (n2 = n; n2 <= this.traceEnd && nArray[n2] == n4; ++n2) {
        }
        return n3 + (n2 - n3) / 2;
    }

    private boolean localMaximum(int n, int[] nArray) {
        int n2;
        int n3 = n - 1;
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n2 = n3 + 3) > this.traceEnd + 1) {
            n2 = this.traceEnd + 1;
        }
        for (int i = n3; i < n2; ++i) {
            if (nArray[i] <= nArray[n]) continue;
            return false;
        }
        return true;
    }

    private int findFirstPeakEndBelow(int n) {
        int n2 = n;
        for (int i = 0; i < this.peaks.size(); ++i) {
            Peak peak = (Peak)this.peaks.elementAt(i);
            int n3 = n - peak.end;
            if (n3 <= 0 || n3 >= n2) continue;
            n2 = n3;
        }
        return n - n2;
    }

    private int findFirstPeakStartAbove(int n) {
        int n2 = this.traceEnd - n;
        for (int i = 0; i < this.peaks.size(); ++i) {
            Peak peak = (Peak)this.peaks.elementAt(i);
            int n3 = peak.start - n;
            if (n3 <= 0 || n3 >= n2) continue;
            n2 = n3;
        }
        return n + n2;
    }

    private static int[] getMinMax(int[] nArray, int n, int n2) {
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = n + n2;
        for (int i = n; i < n5; ++i) {
            int n6 = nArray[i];
            if (n6 < n3) {
                n3 = n6;
            }
            if (n6 <= n4) continue;
            n4 = n6;
        }
        return new int[]{n3, n4};
    }

    public int getNumPeaks() {
        return this.peakXValues.length;
    }

    public int getFirstPeakIndex() {
        return this.iFirstPeakIndex;
    }

    public long getPeakXValue(int n) {
        return this.peakXValues[n];
    }

    public int getIndexForAbsoluteValue(long l) {
        for (int i = 0; i < this.peakXValues.length; ++i) {
            if (this.peakXValues[i] != l) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return "Everest sm=" + this.smoothingFilterWidth + " minPkH=" + this.minPeakHeight;
    }

    private static class PeakComparator
    implements Comparator {
        private final int[] trace;

        public PeakComparator(int[] nArray) {
            this.trace = nArray;
        }

        public int compare(Object object, Object object2) {
            Peak peak = (Peak)object;
            Peak peak2 = (Peak)object2;
            return this.trace[peak2.peakIndex] - this.trace[peak.peakIndex];
        }
    }

    private static class Peak {
        private final int peakIndex;
        private final int start;
        private final int end;

        public Peak(int n, int n2, int n3) {
            this.peakIndex = n;
            this.start = n2;
            this.end = n3;
        }
    }
}

