/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.readings;

import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.util.UIHelper;
import elgato.infrastructure.widgets.ELabel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public abstract class ReadingField
implements TabDelimitable {
    protected String label;
    protected String units;
    protected int readingIndex;
    protected String longLabel;
    public static final String NOT_MEASURED = "-----";
    public static final String NO_UNITS = "";
    public static final long NO_VALUE_THOUSAND = -333000L;

    public ReadingField(String string, String string2, int n) {
        this.label = string;
        this.units = string2;
        this.readingIndex = n;
    }

    public ReadingField(String string, int n) {
        this(string, NO_UNITS, n);
    }

    public String getLabel() {
        return this.label;
    }

    public String getUnits() {
        return this.units;
    }

    public int getReadingIndex() {
        return this.readingIndex;
    }

    public abstract String getValue();

    public void setLongLabel(String string) {
        this.longLabel = string;
    }

    public String getLongLabel() {
        if (this.longLabel == null) {
            return this.label;
        }
        return this.longLabel;
    }

    public String formatValue(double d, int n) {
        return UIHelper.format(d, n);
    }

    public ELabel createDynamicLabel(Color color, Font font) {
        return new ELabel(this.getValue(), color, font){

            public void paint(Graphics graphics) {
                this.setTextNoRepaint(ReadingField.this.getValue());
                super.paint(graphics);
            }
        };
    }

    public String toTabDelimitedString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getLongLabel()).append('\t').append(this.getValue());
        if (!this.getUnits().equals(NO_UNITS)) {
            stringBuffer.append('\t').append(this.getUnits());
        }
        return stringBuffer.toString();
    }
}

