/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.mainScreens.FixedPanel;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.MeasurementListener;
import elgato.infrastructure.scriptedTests.ScriptedTest;
import elgato.infrastructure.scriptedTests.SiteConfigurationValues;
import elgato.infrastructure.scriptedTests.SoftwareFileSystem;
import elgato.infrastructure.scriptedTests.TestScreenDefinition;
import elgato.measurement.twoPortInsertionLoss.TwoPortInsertionLossCalibrateScreen;
import java.awt.Component;

public class CalibrationTestScreenDefinition
extends TestScreenDefinition {
    private String[] filename;

    CalibrationTestScreenDefinition(SoftwareFileSystem softwareFileSystem, String string, String[] stringArray) {
        super("", "", softwareFileSystem, string);
        this.filename = stringArray;
    }

    public Screen getScreen(final ScriptedTest scriptedTest) {
        MeasurementFactory.instance().getCommandProcessor().send(Command.makeSetActiveCommand("antInsLoss"));
        Command command = Command.makeSetCommand("antInsLoss");
        SiteConfigurationValues siteConfigurationValues = SiteConfigurationValues.instance();
        command.addProperty("start", siteConfigurationValues.getChannelStdStartFreq());
        command.addProperty("stop", siteConfigurationValues.getChannelStdStopFreq());
        MeasurementFactory.instance().getCommandProcessor().send(command);
        MeasurementListener measurementListener = new MeasurementListener(){

            public void measurementReceived(Measurement measurement) {
            }
        };
        return new TwoPortInsertionLossCalibrateScreen(measurementListener){

            protected void doOtherStuff(ScreenManager screenManager) {
                super.doOtherStuff(screenManager);
                MeasurementFactory.instance().getCommandProcessor().setInactive();
                screenManager.pushScreen(scriptedTest.nextScreen());
            }

            public void installScreen(ScreenManager screenManager) {
                super.installScreen(screenManager);
                this.setContinueButtonText("Proceed");
            }

            protected Component installFirstPanel() {
                int n = SiteConfigurationValues.instance().getTxSplitter() ? 0 : 1;
                return new FixedPanel(CalibrationTestScreenDefinition.this.fileLocation.getImageIcon(CalibrationTestScreenDefinition.this.id, CalibrationTestScreenDefinition.this.filename[n]));
            }
        };
    }
}

