/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.scriptedTests.CertificationSuiteReader;
import elgato.infrastructure.scriptedTests.SiteConfigurationValues;
import elgato.infrastructure.scriptedTests.SoftwareFileSystem;
import java.util.Vector;

public class CertificationSuite {
    private String name;
    private String id;
    private String version;
    private Vector testList;
    private Vector calTestList;
    private Vector utilTestList;
    private static CertificationSuite instance;
    private String[] requiredOptions;

    public static CertificationSuite instance() {
        if (instance == null) {
            instance = new CertificationSuite();
        }
        return instance;
    }

    public static void clearInstance() {
        instance = null;
    }

    public void goStuffYourself(SoftwareFileSystem softwareFileSystem, String string) {
        CertificationSuiteReader.instance().configure(this, softwareFileSystem, string);
    }

    public Vector getTestList() {
        return this.testList;
    }

    public void setTestList(Vector vector) {
        this.testList = vector;
    }

    public Vector getCalTestList() {
        return this.calTestList;
    }

    public void setCalTestList(Vector vector) {
        this.calTestList = vector;
    }

    public Vector getUtilTestList() {
        return this.utilTestList;
    }

    public void setUtilTestList(Vector vector) {
        this.utilTestList = vector;
    }

    public Vector getFilteredTestList(SiteConfigurationValues siteConfigurationValues) {
        return this.filterList(siteConfigurationValues, this.testList);
    }

    public Vector getFilteredCalTestList(SiteConfigurationValues siteConfigurationValues) {
        return this.filterList(siteConfigurationValues, this.calTestList);
    }

    public Vector getFilteredUtilTestList(SiteConfigurationValues siteConfigurationValues) {
        return this.filterList(siteConfigurationValues, this.utilTestList);
    }

    private Vector filterList(SiteConfigurationValues siteConfigurationValues, Vector vector) {
        Vector<DesiredTest> vector2 = new Vector<DesiredTest>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            DesiredTest desiredTest = (DesiredTest)vector.elementAt(i);
            if (!desiredTest.isDesired(siteConfigurationValues)) continue;
            vector2.addElement(desiredTest);
        }
        return vector2;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setRequiredOptions(String[] stringArray) {
        this.requiredOptions = stringArray;
    }

    public String[] getRequiredOptions() {
        return this.requiredOptions;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public boolean hasRequiredOptions() {
        for (int i = 0; i < this.requiredOptions.length; ++i) {
            if (MeasurementFactory.instance().measurementAvailable(this.requiredOptions[i])) continue;
            return false;
        }
        return true;
    }

    public static interface DesiredTest {
        public boolean isDesired(SiteConfigurationValues var1);
    }
}

