/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.scriptedTests.CertificationSuite;
import elgato.infrastructure.scriptedTests.MeasurementScreenDefinition;
import elgato.infrastructure.scriptedTests.RxLimits;
import elgato.infrastructure.scriptedTests.ScriptedTest;
import elgato.infrastructure.scriptedTests.SiteTestTypeFactory;
import elgato.infrastructure.scriptedTests.SoftwareFileSystem;
import elgato.infrastructure.scriptedTests.TestScreenDefinition;
import java.util.Hashtable;
import java.util.Vector;

public abstract class CertificationSuiteReader {
    private static CertificationSuiteReader instance;
    private static final Hashtable screenDefs;
    Hashtable sectorLists = new Hashtable();
    Hashtable rxLists = new Hashtable();
    Hashtable txLists = new Hashtable();
    Hashtable chanStandardLists = new Hashtable();
    Hashtable cabinetConfLists = new Hashtable();
    Hashtable carrierConfLists = new Hashtable();
    Hashtable powerOutTables = new Hashtable();
    Hashtable connectionDeviceLists = new Hashtable();
    Hashtable troubleshootConnectionDeviceLists = new Hashtable();
    Hashtable rxValuesArrays = new Hashtable();
    Hashtable powerValuesArrays = new Hashtable();
    Vector testList = new Vector();
    Vector calTestList = new Vector();
    Vector utilTestList = new Vector();
    Vector stationTypes = new Vector();
    protected SoftwareFileSystem swDirectory;

    public CertificationSuiteReader() {
        MeasurementScreenDefinition measurementScreenDefinition = new MeasurementScreenDefinition("pwrMeter");
        measurementScreenDefinition.addDynamicDisplaySetting(5, "displayUPwrLim");
        measurementScreenDefinition.addDynamicDisplaySetting(4, "displayLPwrLim");
        screenDefs.put("pwrMeter", measurementScreenDefinition);
        measurementScreenDefinition = new MeasurementScreenDefinition("spectrum");
        measurementScreenDefinition.addDynamicDisplaySetting(6, "refLevel");
        screenDefs.put("spectrum", measurementScreenDefinition);
        measurementScreenDefinition = new MeasurementScreenDefinition("adjChan");
        measurementScreenDefinition.addDynamicDisplaySetting(6, "refLevel");
        screenDefs.put("adjChan", measurementScreenDefinition);
        screenDefs.put("cdmaAn", new MeasurementScreenDefinition("cdmaAn"));
        measurementScreenDefinition = new MeasurementScreenDefinition("antInsLoss");
        measurementScreenDefinition.addDynamicDisplaySetting(0, "insertionLossUpperLimit");
        measurementScreenDefinition.addDynamicDisplaySetting(1, "insertionLossLowerLimit");
        measurementScreenDefinition.addDynamicDisplaySetting(3, "insertionLossLowerLimit");
        measurementScreenDefinition.addDynamicDisplaySetting(2, "insertionLossUpperLimit");
        screenDefs.put("antInsLoss", measurementScreenDefinition);
    }

    public static final CertificationSuiteReader instance() {
        return instance;
    }

    public static final void setInstance(CertificationSuiteReader certificationSuiteReader) {
        instance = certificationSuiteReader;
    }

    protected abstract void populateDataLists(SoftwareFileSystem var1, String var2);

    public void configure(CertificationSuite certificationSuite, SoftwareFileSystem softwareFileSystem, String string) {
        this.testList = new Vector();
        this.calTestList = new Vector();
        this.utilTestList = new Vector();
        this.stationTypes = new Vector();
        this.swDirectory = softwareFileSystem;
        this.populateDataLists(softwareFileSystem, string);
        SiteTestTypeFactory.setInstance(null);
        for (int i = 0; i < this.stationTypes.size(); ++i) {
            this.addBaseStationType((BaseStationDef)this.stationTypes.elementAt(i));
        }
        certificationSuite.setTestList(this.createVector(CertificationSuiteReader.convertVectorToPseudoTestListEntryArray(this.testList), 0));
        certificationSuite.setCalTestList(this.createVector(CertificationSuiteReader.convertVectorToPseudoTestListEntryArray(this.calTestList), this.testList.size()));
        certificationSuite.setUtilTestList(this.createVector(CertificationSuiteReader.convertVectorToPseudoTestListEntryArray(this.utilTestList), this.testList.size() + this.calTestList.size()));
    }

    protected Vector createVector(PseudoTestListEntry[] pseudoTestListEntryArray, int n) {
        Vector<ScriptedTest> vector = new Vector<ScriptedTest>();
        for (int i = 0; i < pseudoTestListEntryArray.length; ++i) {
            ScriptedTest scriptedTest = new ScriptedTest(pseudoTestListEntryArray[i].name, pseudoTestListEntryArray[i].moniker, pseudoTestListEntryArray[i].screenDefinitions, pseudoTestListEntryArray[i].measurementScreenDef, pseudoTestListEntryArray[i].hasSaveDataButton, pseudoTestListEntryArray[i].requiresMultiCarrier, pseudoTestListEntryArray[i].baseStations);
            scriptedTest.setIndex(i + n);
            vector.addElement(scriptedTest);
        }
        return vector;
    }

    protected RxLimits[] getPowerValues(String string) {
        return (RxLimits[])this.powerValuesArrays.get(string);
    }

    protected RxLimits[] getRxValues(String string) {
        return (RxLimits[])this.rxValuesArrays.get(string);
    }

    protected String[][][] getTroubleShootConnectionDeviceList(String string) {
        return (String[][][])this.troubleshootConnectionDeviceLists.get(string);
    }

    protected String[][] getConnectionDeviceList(String string) {
        return (String[][])this.connectionDeviceLists.get(string);
    }

    protected String[] getSector(String string) {
        return (String[])this.sectorLists.get(string);
    }

    protected String[] getCabinet(String string) {
        return (String[])this.cabinetConfLists.get(string);
    }

    protected String[] getCarrier(String string) {
        return (String[])this.carrierConfLists.get(string);
    }

    protected String[] getChanStd(String string) {
        return (String[])this.chanStandardLists.get(string);
    }

    protected String[] getTx(String string) {
        return (String[])this.txLists.get(string);
    }

    protected String[] getRx(String string) {
        return (String[])this.rxLists.get(string);
    }

    protected Hashtable getPowerOutTable(String string) {
        return (Hashtable)this.powerOutTables.get(string);
    }

    protected void addBaseStationType(BaseStationDef baseStationDef) {
        SiteTestTypeFactory.getInstance().addSiteType(baseStationDef.name, this.getSector(baseStationDef.sectorList), this.getRx(baseStationDef.rxList), this.getTx(baseStationDef.txList), this.getChanStd(baseStationDef.chanStdList), this.getCabinet(baseStationDef.cabConfigList), this.getCarrier(baseStationDef.carrierConfigList), this.getPowerOutTable(baseStationDef.powerOutTable), baseStationDef.recommendedOCNS, this.getConnectionDeviceList(baseStationDef.connectionDevices), this.getTroubleShootConnectionDeviceList(baseStationDef.troubleshootConnectionDevices), this.getRxValues(baseStationDef.rxValues), this.getPowerValues(baseStationDef.powerValues));
    }

    protected static PseudoTestListEntry[] convertVectorToPseudoTestListEntryArray(Vector vector) {
        PseudoTestListEntry[] pseudoTestListEntryArray = new PseudoTestListEntry[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            pseudoTestListEntryArray[i] = (PseudoTestListEntry)vector.elementAt(i);
        }
        return pseudoTestListEntryArray;
    }

    protected static TestScreenDefinition[] covertVectorToTestScreenDefs(Vector vector) {
        TestScreenDefinition[] testScreenDefinitionArray = new TestScreenDefinition[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            testScreenDefinitionArray[i] = (TestScreenDefinition)vector.elementAt(i);
        }
        return testScreenDefinitionArray;
    }

    public void saveConfig(String string, String string2, String string3) {
        this.swDirectory.saveConfig(string, string2, string3);
    }

    public String[] getConfigList(String string) {
        return this.swDirectory.getConfigList(string);
    }

    public String readConfig(String string, String string2) {
        return this.swDirectory.getConfig(string, string2);
    }

    public void deleteFile(String string, String string2) {
        this.swDirectory.deleteConfigFile(string, string2);
    }

    Hashtable getScreenDefs() {
        return screenDefs;
    }

    static {
        screenDefs = new Hashtable();
    }

    protected static class BaseStationDef {
        String name;
        String sectorList;
        String rxList;
        String txList;
        String chanStdList;
        String cabConfigList;
        String carrierConfigList;
        String powerOutTable;
        String recommendedOCNS;
        String connectionDevices;
        String troubleshootConnectionDevices;
        String rxValues;
        String powerValues;

        protected BaseStationDef() {
        }
    }

    protected static class PseudoTestListEntry {
        TestScreenDefinition[] screenDefinitions;
        String name;
        String moniker;
        MeasurementScreenDefinition measurementScreenDef;
        boolean hasSaveDataButton;
        boolean requiresMultiCarrier;
        String[] baseStations = null;

        public PseudoTestListEntry(String string, String string2, String string3, boolean bl, boolean bl2, TestScreenDefinition[] testScreenDefinitionArray, String[] stringArray) {
            this.screenDefinitions = testScreenDefinitionArray;
            this.name = string;
            this.moniker = string2;
            string3 = string3 == null ? "" : string3;
            this.measurementScreenDef = (MeasurementScreenDefinition)screenDefs.get(string3);
            this.hasSaveDataButton = bl;
            this.requiresMultiCarrier = bl2;
            this.baseStations = stringArray;
        }

        public PseudoTestListEntry(String string, String string2, String string3, boolean bl, boolean bl2) {
            this(string, string2, string3, bl, bl2, null, null);
        }
    }
}

