/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.mainScreens.GenericMessageScreen;
import elgato.infrastructure.mainScreens.MessageScreen;
import elgato.infrastructure.mainScreens.MessageScreenListener;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.Palette;
import elgato.infrastructure.menu.AlphaEditScreen;
import elgato.infrastructure.menu.ItemSelectionEvent;
import elgato.infrastructure.menu.ItemSelectionListener;
import elgato.infrastructure.menu.ListScreen;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.menu.TimeFreqRefButtonFactory;
import elgato.infrastructure.scriptedTests.DigitalGainsScreen;
import elgato.infrastructure.scriptedTests.ListEntry;
import elgato.infrastructure.scriptedTests.ListEntryCellRenderer;
import elgato.infrastructure.scriptedTests.LoadDataItemSelectionListener;
import elgato.infrastructure.scriptedTests.ParameterListEntry;
import elgato.infrastructure.scriptedTests.ParameterListEntry_ListSelect;
import elgato.infrastructure.scriptedTests.ParameterListEntry_TextEnter;
import elgato.infrastructure.scriptedTests.SiteConfigurationValues;
import elgato.infrastructure.scriptedTests.SiteTestType;
import elgato.infrastructure.scriptedTests.SiteTestTypeFactory;
import elgato.infrastructure.scriptedTests.SoftwareFileSystem;
import elgato.infrastructure.scriptedTests.SoftwareHomeScreen;
import elgato.infrastructure.scriptedTests.TestMenuScreen;
import elgato.infrastructure.util.TextMessage;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.AbstractEListModel;
import elgato.infrastructure.widgets.DefaultEListCellRenderer;
import elgato.infrastructure.widgets.DefaultEListModel;
import elgato.infrastructure.widgets.EListCellRenderer;
import elgato.infrastructure.widgets.EListModel;
import elgato.measurement.sigGen.SigGenMeasurementSettings;
import elgato.measurement.timeFreqRef.TimeFreqRefMeasurementSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class ConfigurationScreen
extends ListScreen {
    public static final String DASH_STRING = "----------------------------------------";
    public static final String BLANK_LINE = "";
    public static final String BASE_STATION_HEADER = "BASE STATION SELECTIONS";
    public static final String CALIBRATION_HEADER = "CALIBRATION VALUE SELECTIONS";
    public static final String LIMITS_HEADER = "PASS/FAIL LIMIT SELECTIONS";
    private static final String DEFAULT_USER_CONFIG_FILE_NAME = "userConfig";
    protected static ActionListener configurationChangedListener;
    private static ScreenManager screenManager;
    static Hashtable configValues;
    private static ConfigurationScreen instance;
    static String[] listOrder;

    private ConfigurationScreen(EListModel eListModel, ItemSelectionListener itemSelectionListener, EListCellRenderer eListCellRenderer) {
        super(eListModel, 0, itemSelectionListener, "Configuration Menu", eListCellRenderer, false);
        Enumeration enumeration = configValues.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (configValues.get(string) instanceof ParameterListEntry_ListSelect) {
                ConfigurationScreen.getConfigListEntry(string).addListener(new KeyListValueListener(string, (ParameterListEntry)configValues.get(string)));
                continue;
            }
            if (!(configValues.get(string) instanceof ParameterListEntry_TextEnter)) continue;
            ConfigurationScreen.getConfigTextEntry(string).getValue().addValueListener(new KeyValueListener(string, this));
        }
        ConfigurationScreen.getConfigListEntry("SiteTestType").addListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationScreen.this.updateListModels(SiteTestTypeFactory.getInstance(actionEvent.getSource().toString()));
            }
        });
        ConfigurationScreen.getConfigListEntry("ShowDiagrams").setElistModel(new String[]{"Yes", "No"});
        ConfigurationScreen.getConfigListEntry("freqTimeRef").setElistModel(TimeFreqRefMeasurementSettings.instance().getTimeFreqRef().getValueList());
        ConfigurationScreen.getConfigListEntry("SiteTestType").setElistModel(SiteTestTypeFactory.getInstance().getTypeList());
        this.updateListModels(SiteConfigurationValues.instance().getSiteTestType());
        ConfigurationScreen.getConfigTextEntry("PnOffset").setValidation(new ParameterListEntry_TextEnter.Validation(){

            public boolean validate(ValueInterface valueInterface) {
                if (((Object)valueInterface).toString().length() > 3) {
                    return false;
                }
                int n = Integer.valueOf(((Object)valueInterface).toString());
                boolean bl = n >= 0;
                return bl &= n <= 511;
            }
        });
        ConfigurationScreen.getConfigTextEntry("PowerOut").setValidation(new ParameterListEntry_TextEnter.Validation(){

            public boolean validate(ValueInterface valueInterface) {
                if (((Object)valueInterface).toString().length() > 5) {
                    return false;
                }
                double d = Double.valueOf(((Object)valueInterface).toString());
                boolean bl = d >= -10.0;
                return bl &= d <= 50.0;
            }
        });
    }

    public static ConfigurationScreen getInstance() {
        return instance;
    }

    protected MenuItem makeCancelButton() {
        return new PushButton("Main\nMenu", this.getContextString(BLANK_LINE), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScreenManager screenManager = ConfigurationScreen.this.getScreenManager();
                screenManager.popScreen();
                ((SoftwareHomeScreen)screenManager.getCurrentScreen()).update();
            }
        });
    }

    static ParameterListEntry_ListSelect getConfigListEntry(String string) {
        return (ParameterListEntry_ListSelect)configValues.get(string);
    }

    private static ParameterListEntry_TextEnter getConfigTextEntry(String string) {
        return (ParameterListEntry_TextEnter)configValues.get(string);
    }

    public static ConfigurationScreen buildConfigurationMenuListScreen(ScreenManager screenManager, String string) {
        ConfigurationScreen.screenManager = screenManager;
        configValues.put("Sector", new ParameterListEntry_ListSelect("Sector", ConfigurationScreen.screenManager, BLANK_LINE));
        configValues.put("BaseStationName", new ParameterListEntry_TextEnter("Site Name", ConfigurationScreen.screenManager, BLANK_LINE, string, false));
        configValues.put("ChannelStd", new ParameterListEntry_ListSelect("Channel STD", ConfigurationScreen.screenManager, BLANK_LINE));
        configValues.put("CabinetConfig", new ParameterListEntry_ListSelect("Cabinet", ConfigurationScreen.screenManager, BLANK_LINE));
        configValues.put("TXConfig", new ParameterListEntry_ListSelect("TX Configuration", ConfigurationScreen.screenManager, BLANK_LINE));
        configValues.put("RXConfig", new ParameterListEntry_ListSelect("RX Configuration", ConfigurationScreen.screenManager, BLANK_LINE));
        configValues.put("CarrierConfig", new ParameterListEntry_ListSelect("Carrier Configuration", ConfigurationScreen.screenManager, BLANK_LINE));
        configValues.put("Channel", ConfigurationScreen.makeIntegerEntry("Channel", BLANK_LINE, string + ".Channel"));
        configValues.put("RXReceivePowerUpper", ConfigurationScreen.makeTestCableEntry("RX Receive Power Upper Limit", BLANK_LINE, string + ".RxPwrULim"));
        configValues.put("RXReceivePowerLower", ConfigurationScreen.makeTestCableEntry("RX Receive Power Lower Limit", BLANK_LINE, string + ".RxPwrLLim"));
        configValues.put("RXReceiveFERUpper", ConfigurationScreen.makeDecimalEntry("RX Receive FER Upper Limit", BLANK_LINE, string + ".RxFerULim"));
        configValues.put("RXReceiveFERLower", ConfigurationScreen.makeDecimalEntry("RX Receive FER Lower Limit", BLANK_LINE, string + ".RxFerLLim"));
        configValues.put("PmRefCalFactor", ConfigurationScreen.makePercentEntry("Power Meter Reference Cal Factor", BLANK_LINE, string + ".PmCalFactor"));
        configValues.put("PmCalFactor.North American Cellular", ConfigurationScreen.makePercentEntry("P.M. Cal Factor: North American Cellular", BLANK_LINE, string + ".PmRefCalFactor1"));
        configValues.put("PmCalFactor.North American PCS", ConfigurationScreen.makePercentEntry("P.M. Cal Factor: North American PCS", BLANK_LINE, string + ".PmRefCalFactor2"));
        configValues.put("PmCalFactor.Korean PCS Band", ConfigurationScreen.makePercentEntry("P.M. Cal Factor: Korean PCS", BLANK_LINE, string + ".PmRefCalFactor3"));
        configValues.put("PmCalFactor.NMT-450", ConfigurationScreen.makePercentEntry("P.M. Cal Factor: NMT-450", BLANK_LINE, string + ".PmRefCalFactor4"));
        configValues.put("PnOffset", ConfigurationScreen.makeIntegerEntry("Base Station PN Offset", BLANK_LINE, string + ".PnOffset"));
        configValues.put("PowerOut", ConfigurationScreen.makePowerOutEntry("Base Station Power Out", BLANK_LINE, string + ".PwrOut"));
        configValues.put("CarrierPowerOut", ConfigurationScreen.makePowerOutEntry("Carrier Power Out", BLANK_LINE, string + ".CarrierPwrOut"));
        configValues.put("RfInLoss", ConfigurationScreen.makeTestCableEntry("RF IN/OUT Path Loss", BLANK_LINE, string + ".RfInLoss"));
        configValues.put("freqTimeRef", new ParameterListEntry_ListSelect("Frequency/Time Reference", ConfigurationScreen.screenManager, BLANK_LINE){

            protected EListCellRenderer getCellRenderer() {
                return new TimeFreqRefButtonFactory.FreqTimeColumnRenderer();
            }

            protected String getDisplayString(Object object) {
                return ((Value)object).getLongLabel();
            }
        });
        configValues.put("ShowDiagrams", new ParameterListEntry_ListSelect("Show Drawings with Tests", ConfigurationScreen.screenManager, BLANK_LINE));
        configValues.put("SiteTestType", new ParameterListEntry_ListSelect("Base Station Type", ConfigurationScreen.screenManager, BLANK_LINE));
        configValues.put(DASH_STRING, new ParameterListEntry_StaticText(DASH_STRING, ConfigurationScreen.screenManager));
        configValues.put(BLANK_LINE, new ParameterListEntry_StaticText(BLANK_LINE, ConfigurationScreen.screenManager));
        configValues.put(BASE_STATION_HEADER, new ParameterListEntry_StaticText(BASE_STATION_HEADER, ConfigurationScreen.screenManager));
        configValues.put(CALIBRATION_HEADER, new ParameterListEntry_StaticText(CALIBRATION_HEADER, ConfigurationScreen.screenManager));
        configValues.put(LIMITS_HEADER, new ParameterListEntry_StaticText(LIMITS_HEADER, ConfigurationScreen.screenManager));
        ItemSelectionListener itemSelectionListener = new ItemSelectionListener(){

            public void itemSelected(ItemSelectionEvent itemSelectionEvent) {
                ListEntry listEntry = (ListEntry)itemSelectionEvent.getValue();
                listEntry.doEvent();
            }
        };
        if (configurationChangedListener == null) {
            configurationChangedListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SiteTestType siteTestType = SiteTestTypeFactory.getInstance(ConfigurationScreen.getConfigListEntry("SiteTestType").value());
                    SiteConfigurationValues.instance().setSiteTestType(siteTestType);
                    SiteConfigurationValues.instance().setCabinetConfig(ConfigurationScreen.getConfigListEntry("CabinetConfig").value());
                    SiteConfigurationValues.instance().setCarrierConfig(ConfigurationScreen.getConfigListEntry("CarrierConfig").value());
                }
            };
        }
        ConfigurationScreen.getConfigListEntry("SiteTestType").addListener(configurationChangedListener);
        instance = new ConfigurationScreen(new ConfigEListModel(configValues), itemSelectionListener, new ListEntryCellRenderer());
        instance.loadValues();
        return instance;
    }

    public void updateListModels(SiteTestType siteTestType) {
        ConfigurationScreen.getConfigListEntry("ChannelStd").setElistModel(siteTestType.getChanStd());
        ConfigurationScreen.getConfigListEntry("CabinetConfig").setElistModel(siteTestType.getCabinetConf());
        ConfigurationScreen.getConfigListEntry("CarrierConfig").setElistModel(siteTestType.getCarrierConf());
        ConfigurationScreen.getConfigListEntry("TXConfig").setElistModel(siteTestType.getTx());
        ConfigurationScreen.getConfigListEntry("RXConfig").setElistModel(siteTestType.getRx());
        ConfigurationScreen.getConfigListEntry("Sector").setElistModel(siteTestType.getSectors());
        ConfigurationScreen.getConfigTextEntry("PowerOut").setValue(String.valueOf(siteTestType.getBaseStationPowerOutInitialValue(SiteConfigurationValues.instance())));
        ConfigurationScreen.getConfigTextEntry("CarrierPowerOut").setValue(String.valueOf(siteTestType.getCarrierPowerOutInitialValue(SiteConfigurationValues.instance())));
    }

    public void updateLosses() {
        ((ParameterListEntry)configValues.get("RfInLoss")).setValue(SiteConfigurationValues.instance().getValue("RfInLoss"));
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        this.createLeftMenu();
        Menu menu = ConfigurationScreen.screenManager.getRightMenuPanel().getMenu();
        menu.setMenuItem(this.makeDigitalGainsButton(), 3);
        menu.setMenuItem(this.makeTestScreenButton(), 5);
    }

    private MenuItem makeTestScreenButton() {
        return new PushButton("Test\nMenu", this.getContextString(BLANK_LINE), new elgato.infrastructure.menu.ActionListener(){

            public void actionPerformed() {
                ScreenManager screenManager = ConfigurationScreen.this.getScreenManager();
                screenManager.popScreen();
                screenManager.pushScreen(TestMenuScreen.buildTestMenuListScreen(screenManager));
            }
        });
    }

    private PushButton makeDigitalGainsButton() {
        return new PushButton("Digital\nGains", BLANK_LINE, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationScreen.this.getScreenManager().pushScreen(new DigitalGainsScreen("Digital Gains"));
            }
        });
    }

    private void createLeftMenu() {
        Menu menu = screenManager.getLeftMenuPanel().getMenu();
        ConfigurationScreen.setTitle(SiteConfigurationValues.instance().getCurrentFilename());
        menu.setMenuItem(this.makeLoadDataButton(), 0);
        menu.setMenuItem(this.makeSaveDataButton(), 1);
        menu.setMenuItem(this.makeDeleteConfigButton(), 3);
        menu.setMenuItem(this.makeRestoreDefaultButton(), 5);
    }

    static void setTitle(String string) {
        Menu menu = screenManager.getLeftMenuPanel().getMenu();
        menu.setTitle(string);
    }

    private MenuItem makeDeleteConfigButton() {
        PushButton pushButton = new PushButton("Delete\nConfig", "delete config", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ItemSelectionListener itemSelectionListener = new ItemSelectionListener(this){
                    private final /* synthetic */ 10 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void itemSelected(ItemSelectionEvent itemSelectionEvent) {
                        String string = (String)itemSelectionEvent.getValue();
                        SiteConfigurationValues.instance().deleteConfigFile(string);
                    }
                };
                Object[] objectArray = SiteConfigurationValues.instance().getConfigurationFileList();
                if (objectArray != null && objectArray.length > 0) {
                    screenManager.pushScreen(new ListScreen(new DefaultEListModel(objectArray), 0, itemSelectionListener, "Select Configuration to Delete", new DefaultEListCellRenderer()));
                } else {
                    ConfigurationScreen.displayNoConfigMessageScreen();
                }
            }
        });
        return pushButton;
    }

    private MenuItem makeLoadDataButton() {
        PushButton pushButton = new PushButton("Load\nConfig", "loadScript", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoadDataItemSelectionListener loadDataItemSelectionListener = LoadDataItemSelectionListener.instance();
                Object[] objectArray = SiteConfigurationValues.instance().getConfigurationFileList();
                if (objectArray != null && objectArray.length > 0) {
                    screenManager.pushScreen(new ListScreen(new DefaultEListModel(objectArray), 0, loadDataItemSelectionListener, "Select Configuration to Load", new DefaultEListCellRenderer()));
                } else {
                    ConfigurationScreen.displayNoConfigMessageScreen();
                }
            }
        });
        return pushButton;
    }

    private MenuItem makeRestoreDefaultButton() {
        PushButton pushButton = new PushButton("Restore\nDefault\nConfig", "loadScript", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SiteConfigurationValues siteConfigurationValues = SiteConfigurationValues.instance();
                String string = siteConfigurationValues.getPackageId();
                SoftwareFileSystem softwareFileSystem = SoftwareFileSystem.getRegisteredFileSystem(string);
                try {
                    siteConfigurationValues.readDefaultConfig(softwareFileSystem, string);
                    ConfigurationScreen.setTitle("defaultconfig");
                    ConfigurationScreen.loadValues();
                }
                catch (IOException iOException) {
                    screenManager.pushScreen(new GenericMessageScreen(TextMessage.MEDIA_DATA_READ_FAILURE, true, 0));
                }
            }
        });
        return pushButton;
    }

    private MenuItem makeSaveDataButton() {
        PushButton pushButton = new PushButton("Save\nConfig", "saveScript", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = SiteConfigurationValues.instance().getCurrentFilename();
                if ("defaultconfig".equals(string)) {
                    string = ConfigurationScreen.DEFAULT_USER_CONFIG_FILE_NAME;
                }
                Value value = Value.createValue("Save Configuration File", string);
                value.setPalette(Palette.createDefault());
                ValueListener valueListener = new ValueListener(this){
                    private String listenerBase;
                    private String listenerName;
                    private final /* synthetic */ 14 this$1;
                    {
                        this.this$1 = var1_1;
                        this.listenerName = ".saveDataButton";
                    }

                    public String getListenerName() {
                        if (this.listenerBase == null) {
                            this.listenerBase = 14.access$100(this.this$1).getListenerBaseName();
                            this.listenerName = this.listenerBase + this.listenerName;
                        }
                        return this.listenerName;
                    }

                    public void valueChanged(ValueInterface valueInterface) {
                        String string = ((Object)valueInterface).toString();
                        14.access$100(this.this$1).saveData(string);
                        ConfigurationScreen.setTitle(string);
                    }
                };
                value.addValueListener(valueListener);
                screenManager.pushScreen(new AlphaEditScreen(value));
            }

            static /* synthetic */ ConfigurationScreen access$100(14 var0) {
                return var0.ConfigurationScreen.this;
            }
        });
        return pushButton;
    }

    void saveData(String string) {
        SiteConfigurationValues siteConfigurationValues = SiteConfigurationValues.instance();
        siteConfigurationValues.setPowerMeterAmplitude(String.valueOf((double)SigGenMeasurementSettings.instance().getAmplitude().longValue() / 1000.0));
        siteConfigurationValues.save(string);
    }

    protected static void loadValues() {
        SiteConfigurationValues siteConfigurationValues = SiteConfigurationValues.instance();
        Enumeration enumeration = configValues.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!(configValues.get(string) instanceof ParameterListEntry)) continue;
            ParameterListEntry parameterListEntry = (ParameterListEntry)configValues.get(string);
            if (siteConfigurationValues.getValue(string) == null) continue;
            parameterListEntry.setValue(siteConfigurationValues.getValue(string));
        }
        screenManager.repaintImmediately();
    }

    protected void storeValues() {
        SiteConfigurationValues siteConfigurationValues = SiteConfigurationValues.instance();
        Enumeration enumeration = configValues.keys();
        while (enumeration.hasMoreElements()) {
            ParameterListEntry parameterListEntry;
            String string = (String)enumeration.nextElement();
            if (!(configValues.get(string) instanceof ParameterListEntry) || (parameterListEntry = (ParameterListEntry)configValues.get(string)).value() == null) continue;
            siteConfigurationValues.setValue(string, parameterListEntry.value(), false);
        }
    }

    public static void displayLoadErrorMessageScreen() {
        GenericMessageScreen genericMessageScreen = new GenericMessageScreen(TextMessage.MEDIA_DATA_NO_PCMCIA_LOAD_FAILURE, true, 4);
        screenManager.pushScreen(genericMessageScreen);
    }

    public static void displayWrongConfigMessageScreen() {
        GenericMessageScreen genericMessageScreen = new GenericMessageScreen(TextMessage.MEDIA_DATA_INVALID_SCRIPT_FAILURE, true, 4);
        screenManager.pushScreen(genericMessageScreen);
    }

    public static void displayNoConfigMessageScreen() {
        GenericMessageScreen genericMessageScreen = new GenericMessageScreen(TextMessage.MEDIA_DATA_NO_SCRIPT_LIST, true, 4);
        screenManager.pushScreen(genericMessageScreen);
    }

    public void displaySaveErrorMessageScreen(ScreenManager screenManager) {
        GenericMessageScreen genericMessageScreen = new GenericMessageScreen(TextMessage.MEDIA_DATA_NO_PCMCIA_SAVE_FAILURE, true, 4);
        screenManager.pushScreen(genericMessageScreen);
    }

    private static ParameterListEntry_TextEnter makeIntegerEntry(String string, String string2, String string3) {
        return new ParameterListEntry_TextEnter(string, screenManager, string2, string3, true){

            protected Palette getPalette() {
                return Palette.createUnsignedInteger();
            }
        };
    }

    private static ParameterListEntry_TextEnter makePowerOutEntry(String string, String string2, String string3) {
        ParameterListEntry_TextEnter parameterListEntry_TextEnter = new ParameterListEntry_TextEnter(string, screenManager, string2, string3, true){

            protected Palette getPalette() {
                return Palette.createSignedDecimal();
            }
        };
        parameterListEntry_TextEnter.setLabel("dBm");
        return parameterListEntry_TextEnter;
    }

    private static ParameterListEntry_TextEnter makeDecimalEntry(String string, String string2, String string3) {
        ParameterListEntry_TextEnter parameterListEntry_TextEnter = new ParameterListEntry_TextEnter(string, screenManager, string2, string3, true){

            protected Palette getPalette() {
                return Palette.createUnsignedDecimal();
            }
        };
        parameterListEntry_TextEnter.setLabel(BLANK_LINE);
        return parameterListEntry_TextEnter;
    }

    private static ParameterListEntry_TextEnter makePercentEntry(String string, String string2, String string3) {
        ParameterListEntry_TextEnter parameterListEntry_TextEnter = new ParameterListEntry_TextEnter(string, screenManager, string2, string3, true){

            protected Palette getPalette() {
                return Palette.createUnsignedDecimal();
            }
        };
        parameterListEntry_TextEnter.setLabel("%");
        return parameterListEntry_TextEnter;
    }

    private static ParameterListEntry_TextEnter makeTestCableEntry(String string, String string2, String string3) {
        ParameterListEntry_TextEnter parameterListEntry_TextEnter = new ParameterListEntry_TextEnter(string, screenManager, string2, string3, true){

            protected Palette getPalette() {
                return Palette.createSignedDecimal();
            }
        };
        parameterListEntry_TextEnter.setLabel("dB");
        return parameterListEntry_TextEnter;
    }

    public ParameterListEntry_ListSelect getSiteTestTypeActuator() {
        return ConfigurationScreen.getConfigListEntry("SiteTestType");
    }

    public ActionListener getListener() {
        return configurationChangedListener;
    }

    static {
        configValues = new Hashtable(20);
        listOrder = new String[]{BASE_STATION_HEADER, DASH_STRING, "SiteTestType", "CabinetConfig", "CarrierConfig", "PowerOut", "CarrierPowerOut", "Sector", "BaseStationName", "RXConfig", "TXConfig", "Channel", "ChannelStd", "PnOffset", "freqTimeRef", "ShowDiagrams", BLANK_LINE, CALIBRATION_HEADER, DASH_STRING, "RfInLoss", "PmRefCalFactor", "PmCalFactor.North American Cellular", "PmCalFactor.North American PCS", "PmCalFactor.Korean PCS Band", "PmCalFactor.NMT-450", BLANK_LINE, LIMITS_HEADER, DASH_STRING, "RXReceivePowerUpper", "RXReceivePowerLower", "RXReceiveFERUpper", "RXReceiveFERLower"};
    }

    private static class ParameterListEntry_StaticText
    extends ParameterListEntry {
        public ParameterListEntry_StaticText(String string, ScreenManager screenManager) {
            super(string, new ScreenManager[]{screenManager}, ConfigurationScreen.BLANK_LINE);
        }

        public void doEvent() {
        }
    }

    class ConfirmConfigDeleteScreen
    extends MessageScreen
    implements MessageScreenListener {
        String prompt = "";
        private String fileName;

        public ConfirmConfigDeleteScreen(String string, int n, int n2, String string2) {
            super(ConfigurationScreen.BLANK_LINE, true, n, n2);
            this.prompt = string;
            this.fileName = string2;
            this.addListener(this);
        }

        public void messageScreenExit(int n) {
            if (n == 2) {
                SiteConfigurationValues.instance().delete(this.fileName);
            }
        }

        public void installScreen(ScreenManager screenManager) {
            super.installScreen(screenManager);
            this.getHTMLRenderer().addVariableReplacment("$CONFIGFILE$", this.fileName);
            this.setMessage(this.prompt);
        }
    }

    private static class KeyListValueListener
    implements ActionListener {
        private String key;
        private ParameterListEntry entry;

        public KeyListValueListener(String string, ParameterListEntry parameterListEntry) {
            this.key = string;
            this.entry = parameterListEntry;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SiteConfigurationValues.instance().setValue(this.key, this.entry.value(), true);
        }
    }

    private static class KeyValueListener
    implements ValueListener {
        private String key;
        private ConfigurationScreen screen;
        private static boolean ignore = false;
        private String listenerBase;
        private String listenerName = ".KeyValueListener";

        public String getListenerName() {
            if (this.listenerBase == null && this.screen != null) {
                this.listenerBase = this.screen.getListenerBaseName();
                this.listenerName = this.listenerBase + this.listenerName;
            }
            return this.listenerName;
        }

        public KeyValueListener(String string, ConfigurationScreen configurationScreen) {
            this.key = string;
            this.screen = configurationScreen;
        }

        public void valueChanged(ValueInterface valueInterface) {
            if (!ignore) {
                ignore = true;
                SiteConfigurationValues.instance().setValue(this.key, ((Object)valueInterface).toString(), true);
                ConfigurationScreen.loadValues();
                ignore = false;
            }
        }
    }

    static class ConfigEListModel
    extends AbstractEListModel {
        private Hashtable table;

        public ConfigEListModel(Hashtable hashtable) {
            this.table = hashtable;
        }

        public int size() {
            return listOrder.length;
        }

        public Object getItem(int n) {
            return this.table.get(listOrder[n]);
        }

        public void insertItem(int n, Object object) {
        }

        public void deleteItem(int n) {
        }
    }
}

