/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.html.HTMLHelpScreen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.Palette;
import elgato.infrastructure.menu.ItemSelectionEvent;
import elgato.infrastructure.menu.ItemSelectionListener;
import elgato.infrastructure.menu.ListScreen;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.scriptedTests.ConfigurationScreen;
import elgato.infrastructure.scriptedTests.ListEntry;
import elgato.infrastructure.scriptedTests.ParameterListEntry_TextEnter;
import elgato.infrastructure.scriptedTests.SiteConfigurationValues;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.DefaultEListCellRenderer;
import elgato.infrastructure.widgets.DefaultEListModel;
import elgato.infrastructure.widgets.EList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class DigitalGainsScreen
extends ListScreen {
    private final String INSTRUCTIONS = Text.DIGITAL_GAINS_INSTRUCTIONS;
    protected static ScreenManager[] screenManagers = new ScreenManager[1];
    protected DigitalGainsListEntry pilot;
    protected DigitalGainsListEntry sync;
    protected DigitalGainsListEntry page;
    protected DigitalGainsListEntry ocns;
    protected DigitalGainsListEntry numChannels;

    public DigitalGainsScreen(String string) {
        super(new DefaultEListModel(new ListEntry[]{DigitalGainsScreen.blankLine()}), 0, new ItemSelectionListener(){

            public void itemSelected(ItemSelectionEvent itemSelectionEvent) {
                ListEntry listEntry = (ListEntry)itemSelectionEvent.getValue();
                listEntry.doEvent();
            }
        }, string, new DigitalGainsListEntryRenderer(), false);
    }

    private ListEntry[] getList() {
        SiteConfigurationValues siteConfigurationValues = SiteConfigurationValues.instance();
        this.pilot = new DigitalGainsListEntry("Pilot Gain", siteConfigurationValues.getPilotGain(), siteConfigurationValues.getRecommendedPilot(), screenManagers, this.getListenerBaseName() + ".pilot");
        this.sync = new DigitalGainsListEntry("Sync Gain", siteConfigurationValues.getSyncGain(), siteConfigurationValues.getRecommendedSync(), screenManagers, this.getListenerBaseName() + ".sync");
        this.page = new DigitalGainsListEntry("Paging Gain", siteConfigurationValues.getPageGain(), siteConfigurationValues.getRecommendedPage(), screenManagers, this.getListenerBaseName() + ".page");
        this.ocns = new DigitalGainsListEntry("OCNS Nominal Gain", siteConfigurationValues.getOcns(), siteConfigurationValues.getRecommendedOCNS(), screenManagers, this.getListenerBaseName() + ".ocns");
        this.numChannels = new DigitalGainsListEntry("Number of OCNS Channels", siteConfigurationValues.getNumChannels(), siteConfigurationValues.getRecommendedChannels(), screenManagers, this.getListenerBaseName() + ".numChannels");
        return new ListEntry[]{new DigitalGainsListEntry("", "ALTERNATE", "RECOMMENDED", screenManagers, this.getListenerBaseName()), DigitalGainsScreen.blankLine(), this.pilot, this.sync, this.page, this.ocns, this.numChannels, DigitalGainsScreen.blankLine(), this.makeCalculatedPowerEntry()};
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        this.setModel(new DefaultEListModel(this.getList()));
        screenManager.getRightMenuPanel().installMenu(this.makeRightMenu());
        HTMLHelpScreen.setHelpEnabled(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JTextArea jTextArea = new JTextArea(this.INSTRUCTIONS, 8, 1);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setBackground(Color.black);
        jTextArea.setForeground(Color.white);
        jTextArea.setFont(new Font("SansSerif", 0, 12));
        jPanel.add((Component)jTextArea, "North");
        this.list = new EList(this.listModel);
        this.list.setCellRenderer(this.cellRenderer);
        this.list.select(this.initialSelectedIndex);
        jPanel.add((Component)this.list, "Center");
        screenManager.installDisplay(new BorderWrapper(jPanel, ListScreen.BORDER, true));
        this.setSelectedIndex(2);
        this.selectedItemChanged();
        Menu menu = this.getScreenManager().getRightMenuPanel().getMenu();
        menu.setMenuItem(this.makeUseAlternateButton(), 2);
        menu.setMenuItem(this.makeUseRecommendedButton(), 3);
        DigitalGainsScreen.screenManagers[0] = this.getScreenManager();
        this.pilot.value.addValueListener(new ValueListener(){
            private final String listenerName = ".pilot";

            public String getListenerName() {
                return DigitalGainsScreen.this.listenerBaseName + ".pilot";
            }

            public void valueChanged(ValueInterface valueInterface) {
                if (valueInterface.intValue() > 254) {
                    valueInterface.setValue(254);
                } else if (valueInterface.intValue() < 0) {
                    valueInterface.setValue(0);
                }
                SiteConfigurationValues.instance().setPilotGain(((Object)valueInterface).toString());
            }
        });
        this.sync.value.addValueListener(new ValueListener(){
            private final String listenerName = ".sync";

            public String getListenerName() {
                return DigitalGainsScreen.this.listenerBaseName + ".sync";
            }

            public void valueChanged(ValueInterface valueInterface) {
                if (valueInterface.intValue() > 254) {
                    valueInterface.setValue(254);
                } else if (valueInterface.intValue() < 0) {
                    valueInterface.setValue(0);
                }
                SiteConfigurationValues.instance().setSyncGain(((Object)valueInterface).toString());
            }
        });
        this.page.value.addValueListener(new ValueListener(){
            private final String listenerName = ".page";

            public String getListenerName() {
                return DigitalGainsScreen.this.listenerBaseName + ".page";
            }

            public void valueChanged(ValueInterface valueInterface) {
                if (valueInterface.intValue() > 254) {
                    valueInterface.setValue(254);
                } else if (valueInterface.intValue() < 0) {
                    valueInterface.setValue(0);
                }
                SiteConfigurationValues.instance().setPageGain(((Object)valueInterface).toString());
            }
        });
        this.ocns.value.addValueListener(new ValueListener(){
            private final String listenerName = ".ocns";

            public String getListenerName() {
                return DigitalGainsScreen.this.listenerBaseName + ".ocns";
            }

            public void valueChanged(ValueInterface valueInterface) {
                if (valueInterface.intValue() > 254) {
                    valueInterface.setValue(254);
                } else if (valueInterface.intValue() < 0) {
                    valueInterface.setValue(0);
                }
                SiteConfigurationValues.instance().setOcns(((Object)valueInterface).toString());
            }
        });
        this.numChannels.value.addValueListener(new ValueListener(){
            private final String listenerName = ".numChannels";

            public String getListenerName() {
                return DigitalGainsScreen.this.listenerBaseName + ".numChannels";
            }

            public void valueChanged(ValueInterface valueInterface) {
                if (valueInterface.intValue() > 30) {
                    valueInterface.setValue(30);
                } else if (valueInterface.intValue() < 0) {
                    valueInterface.setValue(0);
                }
                SiteConfigurationValues.instance().setNumChannels(((Object)valueInterface).toString());
            }
        });
    }

    protected MenuItem makeSelectButton(String string) {
        MenuItem menuItem = super.makeSelectButton(string);
        menuItem.setText("Edit\nAlternate\nValue");
        return menuItem;
    }

    protected MenuItem makeCancelButton() {
        return new PushButton("Return", "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DigitalGainsScreen.this.backToConfigScreen();
            }
        });
    }

    private void backToConfigScreen() {
        ConfigurationScreen.loadValues();
        screenManagers[0].popScreen();
    }

    MenuItem makeUseAlternateButton() {
        PushButton pushButton = new PushButton("Use\nAlternate\nValues", "useAlternateValues", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SiteConfigurationValues siteConfigurationValues = SiteConfigurationValues.instance();
                siteConfigurationValues.setPilotGain(DigitalGainsScreen.this.pilot.value());
                siteConfigurationValues.setPageGain(DigitalGainsScreen.this.page.value());
                siteConfigurationValues.setSyncGain(DigitalGainsScreen.this.sync.value());
                siteConfigurationValues.setOcns(DigitalGainsScreen.this.ocns.value());
                siteConfigurationValues.setNumChannels(DigitalGainsScreen.this.numChannels.value());
                String string = DigitalGainsScreen.powerCalc(DigitalGainsScreen.this.pilot.getActualInt(), DigitalGainsScreen.this.page.getActualInt(), DigitalGainsScreen.this.sync.getActualInt(), DigitalGainsScreen.this.ocns.getActualInt(), DigitalGainsScreen.this.numChannels.getActualInt(), DigitalGainsScreen.this.getValueForC());
                DigitalGainsScreen.setPowerOutValues(siteConfigurationValues, string);
                DigitalGainsScreen.this.backToConfigScreen();
            }
        });
        return pushButton;
    }

    MenuItem makeUseRecommendedButton() {
        PushButton pushButton = new PushButton("Use\nRecommended\nValues", "useRecommendedValues", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SiteConfigurationValues siteConfigurationValues = SiteConfigurationValues.instance();
                siteConfigurationValues.setPilotGain(DigitalGainsScreen.this.pilot.getRecommended());
                siteConfigurationValues.setPageGain(DigitalGainsScreen.this.page.getRecommended());
                siteConfigurationValues.setSyncGain(DigitalGainsScreen.this.sync.getRecommended());
                siteConfigurationValues.setOcns(DigitalGainsScreen.this.ocns.getRecommended());
                siteConfigurationValues.setNumChannels(DigitalGainsScreen.this.numChannels.getRecommended());
                String string = DigitalGainsScreen.powerCalc(DigitalGainsScreen.this.pilot.getRecommendedInt(), DigitalGainsScreen.this.page.getRecommendedInt(), DigitalGainsScreen.this.sync.getRecommendedInt(), DigitalGainsScreen.this.ocns.getRecommendedInt(), DigitalGainsScreen.this.numChannels.getRecommendedInt(), DigitalGainsScreen.this.getValueForC());
                DigitalGainsScreen.setPowerOutValues(siteConfigurationValues, string);
                DigitalGainsScreen.this.backToConfigScreen();
            }
        });
        return pushButton;
    }

    static void setPowerOutValues(SiteConfigurationValues siteConfigurationValues, String string) {
        if ("N/A".equals(siteConfigurationValues.getCarrierPowerOut())) {
            siteConfigurationValues.setPowerOut(string);
        } else {
            double d = siteConfigurationValues.getPowerDifference();
            siteConfigurationValues.setCarrierPowerOut(string);
            double d2 = Double.valueOf(string) + d;
            siteConfigurationValues.setPowerOut(String.valueOf(d2));
        }
    }

    protected void scrollList(int n) {
        super.scrollList(n);
        int n2 = this.getSelectedIndex();
        if (n2 < 2) {
            this.setSelectedIndex(2);
        } else if (n2 > 6) {
            this.setSelectedIndex(6);
        }
    }

    private static DigitalGainsListEntry blankLine() {
        return new DigitalGainsListEntry("", "", "", screenManagers, "blankLine");
    }

    DigitalGainsListEntry makeCalculatedPowerEntry() {
        return new DigitalGainsListEntry("Power Out", "44.4", "44.6", screenManagers, this.listenerBaseName){

            public String getActual() {
                return DigitalGainsScreen.powerCalc(DigitalGainsScreen.this.pilot.getActualInt(), DigitalGainsScreen.this.page.getActualInt(), DigitalGainsScreen.this.sync.getActualInt(), DigitalGainsScreen.this.ocns.getActualInt(), DigitalGainsScreen.this.numChannels.getActualInt(), DigitalGainsScreen.this.getValueForC());
            }

            public String getRecommended() {
                return DigitalGainsScreen.powerCalc(DigitalGainsScreen.this.pilot.getRecommendedInt(), DigitalGainsScreen.this.page.getRecommendedInt(), DigitalGainsScreen.this.sync.getRecommendedInt(), DigitalGainsScreen.this.ocns.getRecommendedInt(), DigitalGainsScreen.this.numChannels.getRecommendedInt(), DigitalGainsScreen.this.getValueForC());
            }
        };
    }

    private double getValueForC() {
        return SiteConfigurationValues.instance().getCValue();
    }

    static String powerCalc(int n, int n2, int n3, int n4, int n5, double d) {
        double d2 = Math.pow((double)n / 254.0, 2.0);
        double d3 = Math.pow((double)n2 / 254.0, 2.0);
        double d4 = Math.pow((double)n3 / 254.0, 2.0);
        double d5 = Math.pow((double)n4 / 254.0, 2.0) * (double)n5;
        double d6 = (d2 + d3 + d4 + d5) * d / 0.001;
        d6 = Math.log(d6) / Math.log(10.0) * 10.0;
        return SiteConfigurationValues.convertStringToDecimal(d6);
    }

    public static class DigitalGainsListEntryRenderer
    extends DefaultEListCellRenderer {
        public DigitalGainsListEntryRenderer() {
            super(new int[]{50, 25, 25});
        }

        protected String[] columnValues(Object object) {
            DigitalGainsListEntry digitalGainsListEntry = (DigitalGainsListEntry)object;
            return new String[]{object.toString(), digitalGainsListEntry.getActual(), digitalGainsListEntry.getRecommended()};
        }
    }

    public static class DigitalGainsListEntry
    extends ParameterListEntry_TextEnter {
        private String recommended;

        protected Palette getPalette() {
            return Palette.createUnsignedInteger();
        }

        public String getActual() {
            return ((Object)this.getValue()).toString();
        }

        public int getActualInt() {
            return this.getValue().intValue();
        }

        public String getRecommended() {
            return this.recommended;
        }

        public int getRecommendedInt() {
            return new Integer(this.recommended);
        }

        public DigitalGainsListEntry(String string, String string2, String string3, ScreenManager[] screenManagerArray, String string4) {
            super(string, screenManagerArray, string2, string4);
            this.recommended = string3;
        }
    }
}

