/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.scriptedTests.SimpleEncryptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class Encrypt {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.out.println("usage: Encrypt <filename> <outfile>");
            System.exit(1);
        }
        String string = stringArray[0];
        File file = new File(stringArray[1]);
        SimpleEncryptor simpleEncryptor = new SimpleEncryptor();
        String string2 = Encrypt.readFromFile(string);
        Encrypt.encryptFile(file, simpleEncryptor, string2);
        Encrypt.writeVersionFile(stringArray, string2);
    }

    private static void writeVersionFile(String[] stringArray, String string) throws FileNotFoundException, IOException {
        String string2 = Encrypt.findVersionNumber(string);
        if (string2.length() > 0) {
            System.out.println(stringArray[0] + " encrypted: version=" + string2);
            File file = new File("software_version.out");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
        } else {
            System.out.println(stringArray[0] + " encrypted");
        }
    }

    private static void encryptFile(File file, SimpleEncryptor simpleEncryptor, String string) throws FileNotFoundException, IOException {
        String string2 = simpleEncryptor.encrypt(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(string2.getBytes());
        fileOutputStream.close();
    }

    private static String findVersionNumber(String string) {
        int n = string.indexOf("softwareversion");
        if (n < 0) {
            return "";
        }
        int n2 = string.indexOf("\"", n);
        int n3 = string.indexOf("\"", n2 + 1);
        return string.substring(n2 + 1, n3);
    }

    private static String readFromFile(String string) {
        String string2 = "";
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[512];
            while ((n = fileInputStream.read(byArray)) > 0) {
                String string3 = new String(byArray);
                if (n < 512) {
                    string3 = string3.substring(0, n);
                }
                string2 = string2 + string3;
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            return "Exception while reading from the file.\n" + iOException.getMessage();
        }
        return string2;
    }
}

