/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.mainScreens.FixedPanel;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.scriptedTests.GraphicsTestScreenDefinition;
import elgato.infrastructure.scriptedTests.ScriptedTest;
import elgato.infrastructure.scriptedTests.ScriptedTestScreen;
import elgato.infrastructure.scriptedTests.SiteConfigurationValues;
import elgato.infrastructure.scriptedTests.SiteTestType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class GraphicScreen
extends ScriptedTestScreen {
    JTextArea footer;
    protected GraphicsTestScreenDefinition testScreenDefinition;
    private static final String ID_RX0_RECEIVE_PATH_GAIN = "rx0-receieve-path-gain";
    private static final String ID_RX1_RECEIVE_PATH_GAIN = "rx1-receive-path-gain";
    private static final String ID_RF_IN_PATH_LOSS = "rf-in-path-loss";
    private static final String ID_RF_OUT_PATH_LOSS = "rf-out-path-loss";
    private static final String ID_POWER_METER_PATH_LOSS = "power-meter-path-loss";
    private static final String ID_MEASURE_DEVICE_LOSS = "measure-device-loss-";

    public GraphicScreen(GraphicsTestScreenDefinition graphicsTestScreenDefinition, ScriptedTest scriptedTest) {
        super(graphicsTestScreenDefinition.getUpperText(), scriptedTest);
        this.testScreenDefinition = graphicsTestScreenDefinition;
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        this.testScreenDefinition.setScriptedTest(this.scriptedTest);
        screenManager.installDisplay(this.createGraphicsPanel(new BorderLayout(0, 0), "North", "Center"));
        screenManager.getRightMenuPanel().installMenu(this.makeRightMenu());
    }

    private JPanel createGraphicsPanel(LayoutManager layoutManager, String string, String string2) {
        JPanel jPanel = new JPanel(layoutManager);
        FixedPanel fixedPanel = new FixedPanel(this.testScreenDefinition.getImageIconFromFile());
        jPanel.add((Component)this.createJtextArea(this.headerText), string);
        jPanel.add((Component)fixedPanel, string2);
        this.footer = this.createJtextArea(this.getFooterText());
        jPanel.add((Component)this.footer, "South");
        return jPanel;
    }

    String getFooterText() {
        if (this.scriptedTest.getId().startsWith(ID_MEASURE_DEVICE_LOSS)) {
            return "Make Cable Connection To: Device under Test";
        }
        if (this.scriptedTest.getId().equals(ID_RF_IN_PATH_LOSS) || this.scriptedTest.getId().equals(ID_RF_OUT_PATH_LOSS) || this.scriptedTest.getId().equals(ID_POWER_METER_PATH_LOSS)) {
            return "Make Cable Connection To: See Picture Above";
        }
        if (this.scriptedTest.getId().equals(ID_RX0_RECEIVE_PATH_GAIN)) {
            return "Connect: DUT OUTPUT-TRM MAIN input cable   DUT INPUT-DPM Main Antenna Input";
        }
        if (this.scriptedTest.getId().equals(ID_RX1_RECEIVE_PATH_GAIN)) {
            return "Connect: DUT OUTPUT-TRM DIV input cable   DUT INPUT-DPM Diversity Ant Input";
        }
        return "Make Cable Connection To: " + SiteTestType.getInstance().getConnectionDeviceName(SiteConfigurationValues.instance());
    }
}

