/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.scriptedTests.GraphicScreen;
import elgato.infrastructure.scriptedTests.ScriptedTest;
import elgato.infrastructure.scriptedTests.SiteConfigurationValues;
import elgato.infrastructure.scriptedTests.SoftwareFileSystem;
import elgato.infrastructure.scriptedTests.TestScreenDefinition;
import elgato.infrastructure.widgets.ImageIcon;

public class GraphicsTestScreenDefinition
extends TestScreenDefinition {
    static final int SPLITTER_AND_INDOOR = 0;
    static final int SPLITTER_AND_OUTDOOR = 1;
    static final int NO_SPLITTER_AND_INDOOR = 2;
    static final int NO_SPLITTER_AND_OUTDOOR = 3;
    static final int SPLITTER_AND_RF_LOSS = 0;
    static final int SPLITTER_AND_POWER_METER_LOSS = 1;
    static final int NO_SPLITTER = 2;
    private ScriptedTest scriptedTest;
    boolean rfWithSplitter;

    GraphicsTestScreenDefinition(String string, String[] stringArray, SoftwareFileSystem softwareFileSystem, String string2, boolean bl) {
        super(string, stringArray, softwareFileSystem, string2);
        this.rfWithSplitter = bl;
    }

    public Screen getScreen(ScriptedTest scriptedTest) {
        this.scriptedTest = scriptedTest;
        return new GraphicScreen(this, scriptedTest);
    }

    String getProperFileName() {
        return this.getFileNames()[this.getFileIndex()];
    }

    public ImageIcon getImageIconFromFile() {
        return this.fileLocation.getImageIcon(this.id, this.getProperFileName());
    }

    void setScriptedTest(ScriptedTest scriptedTest) {
        this.scriptedTest = scriptedTest;
    }

    int getFileIndex() {
        if (this.scriptedTest.getHasSaveDataButton()) {
            return this.getIndexForRxAndTxTests();
        }
        return this.getIndexForCalibrationTests();
    }

    private int getIndexForCalibrationTests() {
        SiteConfigurationValues siteConfigurationValues = SiteConfigurationValues.instance();
        if (siteConfigurationValues.getTxSplitter()) {
            if (this.rfWithSplitter) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    private int getIndexForRxAndTxTests() {
        SiteConfigurationValues siteConfigurationValues = SiteConfigurationValues.instance();
        if (siteConfigurationValues.getTxSplitter()) {
            if (siteConfigurationValues.getCabinetConfig().startsWith("Indoor")) {
                return 0;
            }
            return 1;
        }
        if (siteConfigurationValues.getCabinetConfig().startsWith("Indoor")) {
            return 2;
        }
        return 3;
    }
}

