/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.scriptedTests.InputTestScreenDefinition;
import elgato.infrastructure.scriptedTests.ScriptedTest;
import elgato.infrastructure.scriptedTests.ScriptedTestScreen;
import elgato.measurement.sigGen.SigGenMeasurementSettings;
import javax.swing.JPanel;

public class InputScreen
extends ScriptedTestScreen {
    public static long pmAmplitude;
    private static LongActuator firstLongActuator;
    private static LongActuator secondLongActuator;
    protected InputTestScreenDefinition testScreenDefinition;
    static final String AMPLITUDE = "%AMPLITUDE%";

    public InputScreen(InputTestScreenDefinition inputTestScreenDefinition, ScriptedTest scriptedTest) {
        super(inputTestScreenDefinition.getUpperText(), scriptedTest);
        this.testScreenDefinition = inputTestScreenDefinition;
        if (this.testScreenDefinition.whichActuator == 1) {
            firstLongActuator = LongActuator.createDecimal("", "", inputTestScreenDefinition.actuatorLabel, new RangeValidator(this.testScreenDefinition.rangeValidatorMin, this.testScreenDefinition.rangeValidatorMax), " ", 10);
        } else {
            secondLongActuator = LongActuator.createDecimal("", "", inputTestScreenDefinition.actuatorLabel, new RangeValidator(this.testScreenDefinition.rangeValidatorMin, this.testScreenDefinition.rangeValidatorMax), " ", 10);
        }
        this.startSigGen = inputTestScreenDefinition.startSigGen;
    }

    protected void doScreenSpecificFireOffSigGenCommand(Command command) {
        super.doScreenSpecificFireOffSigGenCommand(command);
        if (!this.scriptedTest.isRerun()) {
            command.addProperty("srcAmp", this.testScreenDefinition.amplitude);
            pmAmplitude = this.testScreenDefinition.amplitude;
        } else {
            pmAmplitude = SigGenMeasurementSettings.instance().getAmplitude().longValue();
        }
    }

    protected void doScreenSpecificInstallConfig(ScreenManager screenManager) {
        JPanel jPanel = new JPanel();
        if (this.headerText != "") {
            this.headerText = this.setToken(this.headerText, AMPLITUDE, SigGenMeasurementSettings.instance().getAmplitude().toString());
            jPanel.add(this.createJtextArea(this.headerText));
        }
        if (this.testScreenDefinition.getTextOrFilename() != "") {
            String string = this.testScreenDefinition.getTextOrFilename();
            string = this.setToken(string, AMPLITUDE, SigGenMeasurementSettings.instance().getAmplitude().toString());
            this.contentJTextArea = this.createJtextArea(string);
            jPanel.add(this.contentJTextArea);
        }
        screenManager.installDisplay(jPanel);
        screenManager.getRightMenuPanel().installMenu(this.makeRightMenu());
        if (this.testScreenDefinition.whichActuator == 1) {
            screenManager.getRightMenuPanel().getMenu().setMenuItem(new ActuatorEditor(firstLongActuator, "", this.getListenerBaseName() + "firstLongActuator"), 1);
        } else {
            screenManager.getRightMenuPanel().getMenu().setMenuItem(new ActuatorEditor(secondLongActuator, "", this.getListenerBaseName() + "secondLongActuator"), 1);
        }
        screenManager.getRightMenuPanel().getMenuItems()[1].press();
    }

    public void uninstallScreen(ScreenManager screenManager) {
        super.uninstallScreen(screenManager);
    }

    public static LongActuator getFirstLongActuator() {
        return firstLongActuator;
    }

    public static LongActuator getSecondLongActuator() {
        return secondLongActuator;
    }
}

