/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.scriptedTests.SimpleEncryptor;
import elgato.infrastructure.scriptedTests.SoftwareFileSystem;
import elgato.infrastructure.util.FileSystemHelper;
import elgato.infrastructure.widgets.ImageIcon;
import java.io.IOException;
import java.io.StringBufferInputStream;

public class LocalUnixSoftwareFileSystem
extends SoftwareFileSystem {
    public LocalUnixSoftwareFileSystem(String string, String string2) {
        super(string, string2);
    }

    protected String getTextContent(String string) {
        return FileSystemHelper.getInstance().readFromFile(string);
    }

    protected void saveTextContent(String string, String string2) {
        try {
            FileSystemHelper.getInstance().writeToFile(string, new StringBufferInputStream(string2));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected ImageIcon getImageContent(String string) {
        return new ImageIcon(string, true);
    }

    protected String adjustBaseDirectory(String string) {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return string;
    }

    protected String computeFilePath(String string) {
        return this.baseDirectory + "sw" + string + "/";
    }

    protected String makeSubdirectory(String string) {
        return string + "/";
    }

    protected String decryptScript(String string) {
        return new SimpleEncryptor().decrypt(string);
    }

    protected String encryptConfigFile(String string) {
        return new SimpleEncryptor().encrypt(string);
    }

    protected String decryptConfigFile(String string) {
        return this.decryptScript(string);
    }

    protected String[] directoryListing(String string) {
        return FileSystemHelper.getInstance().getFileList(string);
    }

    protected boolean hasPackage(String string) {
        return !this.readTextFile(this.getDefaultConfigFileName(string)).startsWith("Exception while reading from the file.");
    }

    protected void removeFile(String string) {
        FileSystemHelper.getInstance().removeFile(string);
    }

    protected void validateConfigDirectory(String string) {
        String string2 = this.configFileDirectoryName(string);
        String[] stringArray = FileSystemHelper.getInstance().getFileList(string2);
        if (stringArray == null) {
            FileSystemHelper.getInstance().mkdir(string2);
        }
    }
}

