/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.analyzer.LocationMonitor;
import elgato.infrastructure.html.HtmlTable;
import elgato.infrastructure.mainScreens.SaveTestDataMessageScreen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.scriptedTests.SiteConfigurationValues;
import elgato.infrastructure.util.FileSystemHelper;
import elgato.infrastructure.util.RuntimeConfiguration;
import elgato.infrastructure.util.Text;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class MeasurementResults {
    private static MeasurementResults instance;
    private String[] results = this.initializeResults();
    private String userInputedDate = "";
    public static final String NO_GPS_DATETIME = "<p>Date/Time: No GPS";
    public static final String MESSAGE = "<tr><td colspan=\"5\"> </td></tr><tr><td colspan=\"5\"> *** OCNS Channel levels are relative to Channel Power ***</td></tr>";
    int counter = 0;

    public static MeasurementResults getInstance() {
        if (instance == null) {
            instance = new MeasurementResults();
        }
        return instance;
    }

    public void setUserInputedDate(String string) {
        this.userInputedDate = string;
    }

    private String[] initializeResults() {
        return new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
    }

    public int getSize() {
        return this.counter;
    }

    public String getMessage(int n) {
        return this.results[n];
    }

    public String getTimeDateHeader() {
        LocationMonitor locationMonitor = LocationMonitor.instance();
        String string = locationMonitor != null && locationMonitor.isDataAvailable() && locationMonitor.isGpsLocked() ? "<p>Date/Time: " + locationMonitor.getTime() + "</p>\n" : (SiteConfigurationValues.instance().getFreqTimeRef().equals(Text.GPS) ? "<p>Date/Time: No GPS " + this.userInputedDate + "</p>\n" : SiteConfigurationValues.instance().getFreqTimeRef() + " " + this.userInputedDate + "</p>\n");
        return "<tr><td colspan=\"5\">" + string + "</td></tr>";
    }

    public String makeStringToWrite() {
        HtmlTable htmlTable = new HtmlTable();
        htmlTable.setColumnWidths(new String[]{"28%", "28%", "17%", "17%", "10%"});
        htmlTable.addRow(new String[]{"Test Conditions", "Measured value", "Lower limit", "Upper limit", Text.Fail});
        htmlTable.addRow(new String[]{"-----------------------", "----------------------", "---------------", "---------------", "-----"});
        String string = new String(this.getReportHeader() + this.getTimeDateHeader() + this.getMessages() + "<TABLE>\n" + htmlTable.getRow(0) + htmlTable.getRow(1));
        for (int i = 0; i < this.results.length; ++i) {
            if (this.results[i].length() <= 0) continue;
            int n = this.results[i].indexOf("<tr>");
            string = string + "  " + this.results[i].substring(n);
        }
        string = string + "</TABLE><BR>Points passed = " + this.getPoints(Text.PASS) + "<BR>Points failed = " + this.getPoints(Text.FAIL);
        return this.replaceAllPassWithSpaces(string);
    }

    private String getMessages() {
        return MESSAGE;
    }

    String getReportHeader() {
        SiteConfigurationValues siteConfigurationValues = SiteConfigurationValues.instance();
        HtmlTable htmlTable = new HtmlTable();
        htmlTable.setColumnWidths(new String[]{"28%", "28%"});
        htmlTable.addRow(new String[]{"Site Name", siteConfigurationValues.getBaseStationName() + " Site"});
        htmlTable.addRow(new String[]{"Sector", siteConfigurationValues.getSector()});
        htmlTable.addRow(new String[]{"PN Offset", siteConfigurationValues.getPnOffset()});
        htmlTable.addRow(new String[]{"Channel", siteConfigurationValues.getChannel()});
        htmlTable.addRow(new String[]{"Power Out", siteConfigurationValues.getPowerOut() + " dBm"});
        htmlTable.addRow(new String[]{"Carr Conf", siteConfigurationValues.getCarrierConfig()});
        htmlTable.addRow(new String[]{"B.S. Type", siteConfigurationValues.getSiteTestType().getName()});
        return htmlTable.getHtml();
    }

    String replaceAllPassWithSpaces(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while ((n = string.indexOf("PASS", n)) != -1) {
            stringBuffer.setCharAt(n, ' ');
            stringBuffer.setCharAt(n + 1, ' ');
            stringBuffer.setCharAt(n + 2, ' ');
            stringBuffer.setCharAt(n + 3, ' ');
            n += 4;
        }
        return stringBuffer.toString();
    }

    public void clear() {
        this.results = this.initializeResults();
        this.counter = 0;
    }

    public static void setTestInstance(MeasurementResults measurementResults) {
        instance = measurementResults;
    }

    int getPoints(String string) {
        int n = 0;
        for (int i = 0; i < this.results.length; ++i) {
            int n2 = 0;
            while ((n2 = this.results[i].indexOf(string, n2)) > -1) {
                ++n;
                n2 += 4;
            }
        }
        return n;
    }

    public void writeResults(String string, ScreenManager screenManager, int n) {
        boolean bl = false;
        for (int i = 0; i < this.results.length; ++i) {
            if (!this.results[i].startsWith(new Integer(n).toString())) continue;
            bl = true;
            this.results[i] = n + string;
            break;
        }
        if (!bl) {
            this.results[this.counter] = n + string;
            ++this.counter;
        }
        this.writeInterumResults(screenManager);
    }

    void writeInterumResults(ScreenManager screenManager) {
        String string = this.makeStringToWrite();
        String string2 = "c:\\tempResults";
        if (RuntimeConfiguration.isEmbedded()) {
            string2 = "/flash/tempResults";
        }
        try {
            FileSystemHelper.getInstance().writeToFile(string2, new ByteArrayInputStream(string.getBytes()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeFinalResults(ScreenManager screenManager) {
        SaveTestDataMessageScreen saveTestDataMessageScreen = new SaveTestDataMessageScreen(this.makeStringToWrite(), screenManager);
        screenManager.pushScreen(saveTestDataMessageScreen);
    }
}

