/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.scriptedTests.SiteConfigurationValues;
import elgato.infrastructure.scriptedTests.SiteTestType;
import elgato.infrastructure.util.HashMap;
import elgato.infrastructure.util.KeyValuePair;
import elgato.measurement.acp.ACPMeasurementSettings;
import elgato.measurement.cdma.CdmaMeasurementSettings;
import elgato.measurement.powerMeter.PowerMeterMeasurementSettings;
import elgato.measurement.spectrum.SpectrumMeasurementSettings;
import elgato.measurement.timeFreqRef.TimeFreqRefMeasurementSettings;
import elgato.measurement.twoPortInsertionLoss.TwoPortInsertionLossMeasurementSettings;
import java.util.Enumeration;
import java.util.Hashtable;

public class MeasurementScreenDefinition {
    public static final int RX0 = 0;
    public static final int RX1 = 1;
    public static final int KEY_RX0_UPPER_LIMIT = 0;
    public static final int KEY_RX0_LOWER_LIMIT = 1;
    public static final int KEY_RX1_UPPER_LIMIT = 2;
    public static final int KEY_RX1_LOWER_LIMIT = 3;
    public static final int KEY_POWER_LOWER_LIMIT = 4;
    public static final int KEY_POWER_UPPER_LIMIT = 5;
    public static final int KEY_REF_LEVEL = 6;
    private String measurementName;
    private Hashtable dynamicDisplayParameters;
    private Hashtable dynamicParameters;

    public MeasurementScreenDefinition(String string) {
        this.measurementName = string;
        this.dynamicDisplayParameters = new Hashtable();
        this.dynamicParameters = new Hashtable();
    }

    public MeasurementScreen getMeasurementScreen() {
        if (this.measurementName != null && this.measurementName.trim().length() != 0) {
            return (MeasurementScreen)MeasurementFactory.instance().getScreenForMeasurementType(this.measurementName);
        }
        return null;
    }

    public MeasurementSettings getSettingsModel() {
        if (this.measurementName != null && this.measurementName.trim().length() != 0) {
            return this.figureCorrectMeasurement();
        }
        return null;
    }

    private MeasurementSettings figureCorrectMeasurement() {
        if ("spectrum".equals(this.measurementName)) {
            return SpectrumMeasurementSettings.instance();
        }
        if ("adjChan".equals(this.measurementName)) {
            return ACPMeasurementSettings.instance();
        }
        if ("antInsLoss".equals(this.measurementName)) {
            return TwoPortInsertionLossMeasurementSettings.instance();
        }
        if ("cdmaAn".equals(this.measurementName)) {
            return CdmaMeasurementSettings.instance();
        }
        if ("pwrMeter".equals(this.measurementName)) {
            return PowerMeterMeasurementSettings.instance();
        }
        return null;
    }

    private void sendFreqTimeRef() {
        TimeFreqRefMeasurementSettings timeFreqRefMeasurementSettings = TimeFreqRefMeasurementSettings.instance();
        timeFreqRefMeasurementSettings.setFreqTimeRefByString(SiteConfigurationValues.instance().getFreqTimeRef());
        timeFreqRefMeasurementSettings.getTimeFreqRef().send();
    }

    public void sendSettings(String string, boolean bl) {
        long l;
        Object object;
        HashMap hashMap = this.combineParameterLists(string, this.retrieveDisplayParameters(string), this.dynamicDisplayParameters, bl);
        HashMap hashMap2 = this.combineParameterLists(string, this.retrieveParameters(string), this.dynamicParameters, false);
        this.sendCenterFrequency();
        if (this.measurementName.equals("spectrum")) {
            SpectrumMeasurementSettings.instance().bSemState = false;
        }
        this.sendSettingsToServer(hashMap2, this.measurementName);
        this.sendSettingsToServer(hashMap, "display." + this.measurementName);
        this.sendFreqTimeRef();
        if (this.measurementName.equals("cdmaAn")) {
            object = Command.makeSetCommand(this.measurementName);
            ((Command)object).addProperty("pnAuto", 0L);
            ((Command)object).addProperty("pn", SiteConfigurationValues.instance().getPnOffset());
            MeasurementFactory.instance().getCommandProcessor().send((Command)object);
        }
        if (this.measurementName.equals("pwrMeter")) {
            l = (long)(new Double(SiteConfigurationValues.instance().getPowerMeterLoss()) * 1000.0);
            object = Command.makeSetCommand(this.measurementName);
            ((Command)object).addProperty("pmRefCf", SiteConfigurationValues.instance().getRefCalFactor());
            ((Command)object).addProperty("calFactor", SiteConfigurationValues.instance().getPmCalFactor());
            ((Command)object).addProperty("pwrOffset", l);
            MeasurementFactory.instance().getCommandProcessor().send((Command)object);
            object = Command.makeGlobalSetCommand();
            ((Command)object).addProperty("pwrOffset", l);
            MeasurementFactory.instance().getCommandProcessor().send((Command)object);
            object = Command.makeSetCommand("display.pwrMeter");
            ((Command)object).addProperty("lossToggle", 1L);
            ((Command)object).addProperty("stashingpwrOffset", l);
            MeasurementFactory.instance().getCommandProcessor().send((Command)object);
            object = Command.makeSetCommand("display.global");
            ((Command)object).addProperty("lossToggle", 1L);
            ((Command)object).addProperty("pwrOffset", l);
            MeasurementFactory.instance().getCommandProcessor().send((Command)object);
        }
        if (this.measurementName.equals("spectrum") || this.measurementName.equals("adjChan") || this.measurementName.equals("cdmaAn")) {
            l = (long)(new Double(SiteConfigurationValues.instance().getRfInLoss()) * 1000.0);
            object = Command.makeGlobalSetCommand();
            ((Command)object).addProperty("atten", l);
            MeasurementFactory.instance().getCommandProcessor().send((Command)object);
            object = Command.makeSetCommand("display.global");
            ((Command)object).addProperty("inLossToggle", 1L);
            ((Command)object).addProperty("stashingatten", l);
            MeasurementFactory.instance().getCommandProcessor().send((Command)object);
        }
        if (this.measurementName.equals("adjChan")) {
            object = ACPMeasurementSettings.instance();
            if (SiteConfigurationValues.instance().getChannelStdIndex() == 16) {
                ((ACPMeasurementSettings)object).getFormatList().send(0);
                ((ACPMeasurementSettings)object).getFormatType().send(1);
            } else {
                ((ACPMeasurementSettings)object).getFormatType().send(0);
            }
        }
        if (this.measurementName.equals("spectrum")) {
            object = Command.makeSetCommand("display.spectrum");
            l = this.getProperPower(bl);
            ((Command)object).addProperty("dbReferenceLevel", l + 10000L);
            ((Command)object).addProperty("upper.groupOneLevel", l);
            ((Command)object).addProperty("upper.spanCenterFrequency", SiteConfigurationValues.instance().getForwardFrequency());
            MeasurementFactory.instance().getCommandProcessor().send((Command)object);
        }
    }

    private long getProperPower(boolean bl) {
        String string = SiteConfigurationValues.instance().getPowerOut();
        String string2 = SiteConfigurationValues.instance().getCarrierPowerOut();
        String string3 = bl || "N/A".equals(string2) ? string : string2;
        double d = Double.valueOf(string3) * 1000.0;
        return (long)d;
    }

    private HashMap retrieveParameters(String string) {
        return SiteConfigurationValues.instance().getSettings(string);
    }

    private HashMap retrieveDisplayParameters(String string) {
        return SiteConfigurationValues.instance().getSettings("display." + string);
    }

    private void sendCenterFrequency() {
        if (!this.measurementName.equals("pwrMeter") && !this.measurementName.equals("antInsLoss")) {
            Command command = Command.makeSetCommand(this.measurementName);
            command.addProperty("cf", SiteConfigurationValues.instance().getForwardFrequency() / 1000L);
            MeasurementFactory.instance().getCommandProcessor().send(command);
        }
    }

    private void sendSettingsToServer(HashMap hashMap, String string) {
        Command command = Command.makeSetCommand(string);
        Enumeration enumeration = hashMap.elements();
        while (enumeration.hasMoreElements()) {
            KeyValuePair keyValuePair = (KeyValuePair)enumeration.nextElement();
            command.addProperty(keyValuePair.getKey(), keyValuePair.getValue());
        }
        MeasurementFactory.instance().getCommandProcessor().send(command);
    }

    public String getMeasurementName() {
        return this.measurementName;
    }

    public void addDynamicDisplaySetting(int n, String string) {
        this.dynamicDisplayParameters.put(new Integer(n), string);
    }

    public void addDynamicSetting(int n, String string) {
        this.dynamicParameters.put(new Integer(n), string);
    }

    HashMap combineParameterLists(String string, HashMap hashMap, Hashtable hashtable, boolean bl) {
        Object object;
        HashMap hashMap2 = new HashMap();
        Object object2 = hashMap.elements();
        while (object2.hasMoreElements()) {
            object = (KeyValuePair)object2.nextElement();
            hashMap2.put(((KeyValuePair)object).getKey(), ((KeyValuePair)object).getValue());
        }
        object2 = SiteTestType.getInstance();
        object = hashtable.keys();
        while (object.hasMoreElements()) {
            Integer n = (Integer)object.nextElement();
            String string2 = (String)hashtable.get(n);
            String string3 = "";
            switch (n) {
                case 1: {
                    string3 = ((SiteTestType)object2).getrxLowerLimit(0);
                    break;
                }
                case 0: {
                    string3 = ((SiteTestType)object2).getRxUpperLimit(0);
                    break;
                }
                case 3: {
                    string3 = ((SiteTestType)object2).getrxLowerLimit(1);
                    break;
                }
                case 2: {
                    string3 = ((SiteTestType)object2).getRxUpperLimit(1);
                    break;
                }
                case 4: {
                    string3 = ((SiteTestType)object2).getPowerLowerLimitDefault(bl);
                    break;
                }
                case 5: {
                    string3 = ((SiteTestType)object2).getPowerUpperLimitDefault(bl);
                    break;
                }
                case 6: {
                    if (this.measurementName.equals("adjChan")) {
                        string3 = String.valueOf(ACPMeasurementSettings.instance().getRefLevel().longValue() + 10000L);
                    }
                    if (!this.measurementName.equals("spectrum")) break;
                    string3 = String.valueOf(SpectrumMeasurementSettings.instance().getRefLevel().longValue() + 10000L);
                }
            }
            hashMap2.put(string2, string3);
        }
        return hashMap2;
    }

    Hashtable getDynamicDisplaySettings() {
        return this.dynamicDisplayParameters;
    }

    Hashtable getDynamicSettings() {
        return this.dynamicParameters;
    }
}

