/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.html.HtmlTable;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.scriptedTests.InputScreen;
import elgato.infrastructure.scriptedTests.MeasurementResults;
import elgato.infrastructure.scriptedTests.PassFailTestScreenDefinition;
import elgato.infrastructure.scriptedTests.ScriptedTest;
import elgato.infrastructure.scriptedTests.ScriptedTestScreen;
import elgato.infrastructure.scriptedTests.TestMenuScreen;
import elgato.infrastructure.scriptedTests.TestScreenDefinition;
import elgato.infrastructure.util.Text;
import elgato.measurement.sigGen.SigGenMeasurementSettings;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class PassFailScreen
extends ScriptedTestScreen {
    protected PassFailTestScreenDefinition testScreenDefinition;

    public PassFailScreen(PassFailTestScreenDefinition passFailTestScreenDefinition, ScriptedTest scriptedTest) {
        super(passFailTestScreenDefinition.getUpperText(), scriptedTest);
        this.testScreenDefinition = passFailTestScreenDefinition;
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        screenManager.getRightMenuPanel().installMenu(this.scriptedTest.makeRightMenuForMeasurement(screenManager));
        screenManager.getRightMenuPanel().setMenuItem(this.makeNextTestButton(screenManager), 0);
        screenManager.getRightMenuPanel().setMenuItem(this.makeSaveDataButton(screenManager), 2);
        JPanel jPanel = new JPanel();
        JTextArea jTextArea = this.createJtextArea("");
        this.headerText = Text.Error;
        double d = Double.valueOf(this.getValue());
        if (this.testScreenDefinition.getLowerLimit() <= d && d <= this.testScreenDefinition.getUpperLimit()) {
            this.headerText = TestScreenDefinition.PASS;
            this.setHeaderTextAndColor(jTextArea, MeasurementMetrics.DARK_GREEN);
        } else {
            this.headerText = TestScreenDefinition.FAIL;
            this.setHeaderTextAndColor(jTextArea, Color.red);
        }
        this.createContentJtextArea();
        if (SigGenMeasurementSettings.instance().getAmplitude().longValue() != InputScreen.pmAmplitude) {
            this.headerText = Text.Error;
            this.contentJTextArea.setText("Unable to inject a " + (double)InputScreen.pmAmplitude / 1000.0 + " dBm signal into the BTS receiver\n\n" + "A possible reason is that the RF Out Path Loss is incorrect or too great.  " + "Re-check RF Out Path Loss value and if using the E7495A only, insure the total RF Out Path Loss is no greater than 43 dB.\n\n" + "The amplitude value has been adjusted to : " + (double)SigGenMeasurementSettings.instance().getAmplitude().longValue() / 1000.0 + " dBm.");
            this.setHeaderTextAndColor(jTextArea, Color.red);
        }
        if (this.headerText.equals(Text.FAIL) || this.headerText.equals(Text.Error)) {
            this.getScreenManager().getRightMenuPanel().setMenuItem(this.createSigGenButton(), 5);
            this.getScreenManager().getRightMenuPanel().setMenuItem(this.createRerunTestButton(), 3);
        } else {
            this.getScreenManager().getRightMenuPanel().setMenuItem(null, 5);
            this.getScreenManager().getRightMenuPanel().setMenuItem(null, 3);
        }
        jPanel.add(jTextArea);
        jPanel.add(this.contentJTextArea);
        screenManager.installDisplay(jPanel);
    }

    private MenuItem createRerunTestButton() {
        return new PushButton(Text.Rerun_This_n_Test, this.getContextString(""), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PassFailScreen.this.scriptedTest.rerun();
                ScreenManager screenManager = PassFailScreen.this.getScreenManager();
                screenManager.popScreen();
                screenManager.pushScreen(PassFailScreen.this.scriptedTest.prevScreen());
            }
        });
    }

    String getValue() {
        if (this.testScreenDefinition.useFer()) {
            return this.getFER();
        }
        return this.getRxPowerValue();
    }

    private void createContentJtextArea() {
        String string = "Lower Limit = " + this.testScreenDefinition.getLowerLimit() + "\n" + this.scriptedTest.getName() + " = " + this.getValue() + "\n" + "Upper Limit = " + this.testScreenDefinition.getUpperLimit();
        if (this.headerText.equals(Text.FAIL)) {
            string = string + "\n\n" + this.testScreenDefinition.getUpperText();
        }
        this.contentJTextArea = new JTextArea(string);
        this.contentJTextArea.setSize(this.getDesiredWidth(), 50);
        this.contentJTextArea.setLineWrap(true);
        this.contentJTextArea.setWrapStyleWord(true);
        this.contentJTextArea.setEditable(false);
    }

    private String formatResultLine(String string, String string2, String string3, String string4, String string5) {
        HtmlTable htmlTable = new HtmlTable();
        htmlTable.addRow(new String[]{string, string2, string3, string4, string5});
        return htmlTable.getRow(0);
    }

    private String createResultLine(double d, double d2, double d3, String string, String string2) {
        String string3 = this.format(d) + " " + string2;
        String string4 = this.format(d2);
        String string5 = this.format(d3);
        if (d2 == Double.POSITIVE_INFINITY) {
            string4 = "";
        }
        if (d3 == Double.NEGATIVE_INFINITY) {
            string5 = "";
        }
        return this.formatResultLine(string, string3, string5, string4, this.addPassFail(d, d2, d3));
    }

    private String format(double d) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        return decimalFormat.format(d);
    }

    private String addPassFail(double d, double d2, double d3) {
        if (d3 != Double.MIN_VALUE && d < d3 || d2 != Double.MAX_VALUE && d > d2) {
            return TestScreenDefinition.FAIL;
        }
        return TestScreenDefinition.PASS;
    }

    String getTestResults(ScreenManager screenManager) {
        return this.createResultLine(Double.valueOf(this.getValue()), this.testScreenDefinition.getUpperLimit(), this.testScreenDefinition.getLowerLimit(), this.scriptedTest.getName(), "");
    }

    private String getFER() {
        return InputScreen.getFirstLongActuator().longValue() / 10L + "." + InputScreen.getFirstLongActuator().longValue() % 10L;
    }

    String getRxPowerValue() {
        long l = InputScreen.getSecondLongActuator().longValue() - InputScreen.getFirstLongActuator().longValue();
        return String.valueOf((double)l / 10.0);
    }

    private MenuItem makeSaveDataButton(final ScreenManager screenManager) {
        if (!this.scriptedTest.getHasSaveDataButton()) {
            return null;
        }
        PushButton pushButton = new PushButton("Save Data", this.getContextString(""), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = PassFailScreen.this.getTestResults(screenManager);
                if (string.length() > 0) {
                    MeasurementResults.getInstance().writeResults(string, screenManager, PassFailScreen.this.scriptedTest.getIndex());
                }
            }
        });
        return pushButton;
    }

    private MenuItem makeNextTestButton(final ScreenManager screenManager) {
        return new PushButton("Proceed\n(save data)", "testing", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = PassFailScreen.this.getTestResults(screenManager);
                if (string.length() > 0) {
                    MeasurementResults.getInstance().writeResults(string, screenManager, PassFailScreen.this.scriptedTest.getIndex());
                }
                TestMenuScreen.turnSigGenOff();
                screenManager.popScreen();
                TestMenuScreen testMenuScreen = (TestMenuScreen)screenManager.getCurrentScreen();
                if (testMenuScreen != null) {
                    testMenuScreen.advanceSelection();
                }
            }
        });
    }
}

