/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.scriptedTests.ScriptedTest;
import elgato.infrastructure.scriptedTests.SiteConfigurationValues;
import elgato.infrastructure.scriptedTests.SoftwareFileSystem;
import elgato.infrastructure.scriptedTests.TestMenuScreen;
import elgato.infrastructure.scriptedTests.TestScreenDefinition;
import elgato.measurement.powerMeter.PowerMeterModeScreen;

public class PowerMeterFunctionTestScreenDefinition
extends TestScreenDefinition {
    private int mode;
    private boolean showSkipButton;

    PowerMeterFunctionTestScreenDefinition(SoftwareFileSystem softwareFileSystem, String string, int n, boolean bl) {
        super("", "", softwareFileSystem, string);
        this.mode = n;
        this.showSkipButton = bl;
    }

    public Screen getScreen(final ScriptedTest scriptedTest) {
        MeasurementFactory.instance().getCommandProcessor().send(Command.makeSetActiveCommand("pwrMeter"));
        Command command = Command.makeSetCommand("pwrMeter");
        command.addProperty("pmRefCf", SiteConfigurationValues.instance().getRefCalFactor());
        command.addProperty("calFactor", SiteConfigurationValues.instance().getPmCalFactor());
        MeasurementFactory.instance().getCommandProcessor().send(command);
        String string = "";
        string = this.mode == 3 ? "Zeroing the Power Meter" : "Calibrating the Power Meter";
        return new PowerMeterModeScreen(this.mode, "", string, ""){

            public void installScreen(ScreenManager screenManager) {
                super.installScreen(screenManager);
                screenManager.getRightMenuPanel().getMenu().setMenuItem(this.makeSkipButton(), 5);
            }

            protected void doOtherStuff() {
                super.doOtherStuff();
                Screen screen = scriptedTest.nextScreen();
                if (screen != null) {
                    this.screenManager.pushScreen(screen);
                } else if (!scriptedTest.showMeasurementScreen(this.screenManager)) {
                    ((TestMenuScreen)this.screenManager.getCurrentScreen()).advanceSelection();
                }
            }

            private MenuItem makeSkipButton() {
                if (PowerMeterFunctionTestScreenDefinition.this.showSkipButton) {
                    return new PushButton(this, "Skip", ""){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void press() {
                            super.press();
                            this.this$1.getScreenManager().popScreen();
                            Screen screen = 1.access$100(this.this$1).nextScreen();
                            if (screen != null) {
                                1.access$200(this.this$1).pushScreen(screen);
                            } else if (!1.access$100(this.this$1).showMeasurementScreen(1.access$300(this.this$1))) {
                                ((TestMenuScreen)1.access$400(this.this$1).getCurrentScreen()).advanceSelection();
                            }
                        }
                    };
                }
                return null;
            }

            static /* synthetic */ ScriptedTest access$100(1 var0) {
                return var0.scriptedTest;
            }

            static /* synthetic */ ScreenManager access$200(1 var0) {
                return var0.screenManager;
            }

            static /* synthetic */ ScreenManager access$300(1 var0) {
                return var0.screenManager;
            }

            static /* synthetic */ ScreenManager access$400(1 var0) {
                return var0.screenManager;
            }
        };
    }
}

