/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.menu.SimpleMenuButton;
import elgato.infrastructure.scriptedTests.CertificationSuite;
import elgato.infrastructure.scriptedTests.MeasurementResults;
import elgato.infrastructure.scriptedTests.MeasurementScreenDefinition;
import elgato.infrastructure.scriptedTests.SiteConfigurationValues;
import elgato.infrastructure.scriptedTests.TestMenuScreen;
import elgato.infrastructure.scriptedTests.TestScreenDefinition;
import elgato.infrastructure.util.Arrays;
import elgato.measurement.cdma.CdmaScreen;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ScriptedTest
implements CertificationSuite.DesiredTest {
    private String testName;
    private final String moniker;
    private int index;
    private boolean hasSaveDataButton;
    private boolean requiresMultiCarrier;
    MeasurementScreenDefinition measurementScreenDef;
    MeasurementScreen measurementScreen = null;
    TestScreenDefinition[] testDefinitions;
    private int screenNumber = 0;
    private boolean rerun = false;
    boolean firstTime = true;
    private String[] legalBaseStations = null;
    private static final String ID_RX0_RECEIVE_PATH_GAIN = "rx0-receieve-path-gain";
    private static final String ID_RX1_RECEIVE_PATH_GAIN = "rx1-receive-path-gain";
    static /* synthetic */ Class class$elgato$infrastructure$scriptedTests$GraphicScreen;

    public ScriptedTest(String string, String string2, TestScreenDefinition[] testScreenDefinitionArray, MeasurementScreenDefinition measurementScreenDefinition, boolean bl, boolean bl2, String[] stringArray) {
        this.testName = string;
        this.moniker = string2;
        this.measurementScreenDef = measurementScreenDefinition;
        this.testDefinitions = testScreenDefinitionArray;
        this.hasSaveDataButton = bl;
        this.legalBaseStations = stringArray;
        this.requiresMultiCarrier = bl2;
    }

    public String getId() {
        return this.moniker;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public Screen nextScreen() {
        return this.gotoScreen(this.screenNumber);
    }

    public Screen prevScreen() {
        --this.screenNumber;
        return this.gotoScreen(--this.screenNumber);
    }

    public Screen gotoScreen(int n) {
        this.screenNumber = n;
        if (this.screenNumber < this.testDefinitions.length) {
            TestScreenDefinition testScreenDefinition;
            if ((testScreenDefinition = this.testDefinitions[this.screenNumber++]) == null) {
                return null;
            }
            Screen screen = this.buildScreen(testScreenDefinition);
            if (!SiteConfigurationValues.instance().getShowDiagrams() && screen.getClass().equals(class$elgato$infrastructure$scriptedTests$GraphicScreen == null ? (class$elgato$infrastructure$scriptedTests$GraphicScreen = ScriptedTest.class$("elgato.infrastructure.scriptedTests.GraphicScreen")) : class$elgato$infrastructure$scriptedTests$GraphicScreen)) {
                return this.nextScreen();
            }
            return screen;
        }
        return null;
    }

    private Screen buildScreen(TestScreenDefinition testScreenDefinition) {
        return testScreenDefinition.getScreen(this);
    }

    public MeasurementScreen getMeasurementScreen() {
        MeasurementScreenDefinition measurementScreenDefinition = this.getProperScreenDef();
        if (measurementScreenDefinition == null) {
            return null;
        }
        this.measurementScreen = this.getProperScreenDef().getMeasurementScreen();
        return this.measurementScreen;
    }

    public String getName() {
        return this.testName;
    }

    public void reset() {
        this.screenNumber = 0;
        this.rerun = false;
    }

    public void rerun() {
        this.rerun = true;
    }

    public boolean isRerun() {
        return this.rerun;
    }

    public boolean showMeasurementScreen(ScreenManager screenManager) {
        this.measurementScreen = this.getMeasurementScreen();
        if (this.measurementScreen != null) {
            if (this.getId().equals(ID_RX0_RECEIVE_PATH_GAIN) || this.getId().equals(ID_RX1_RECEIVE_PATH_GAIN)) {
                TraceChart.setInvert(true);
            }
            screenManager.pushScreen(this.measurementScreen);
            Menu menu = this.addTestMenuButtonToLeftPanel(screenManager);
            if (TraceChart.getInvert()) {
                menu = screenManager.getLeftMenuPanel().getMenu();
                menu.setMenuItem(null, 1);
                menu.setMenuItem(null, 2);
                menu.setMenuItem(null, 4);
                menu.setMenuItem(null, 6);
            }
            MeasurementScreenDefinition measurementScreenDefinition = this.getProperScreenDef();
            measurementScreenDefinition.sendSettings(this.moniker, this.requiresMultiCarrier);
            measurementScreenDefinition.sendSettings(this.moniker, this.requiresMultiCarrier);
            if (this.measurementScreen.getTopic().equals("cdmaAn")) {
                ((CdmaScreen)this.measurementScreen).showPassFailPanel();
            }
            this.firstTime = false;
        }
        return this.measurementScreen != null;
    }

    private MeasurementScreenDefinition getProperScreenDef() {
        return this.measurementScreenDef;
    }

    public MeasurementScreenDefinition getScreenDef() {
        return this.getProperScreenDef();
    }

    public Menu addTestMenuButtonToLeftPanel(ScreenManager screenManager) {
        Menu menu = screenManager.getLeftMenuPanel().getMenu();
        menu.setMenuItem(new SimpleMenuButton("Test Menu", "", this.makeRightMenuForMeasurement(screenManager)), 3);
        menu.getItems()[3].press();
        return menu;
    }

    public Menu makeRightMenuForMeasurement(ScreenManager screenManager) {
        return new Menu("Test Menu", new MenuItem[]{this.makeNextTestButton(screenManager), null, this.makeSaveDataButton(screenManager), null, null, null, this.makeMeasurementCancelButton(screenManager)});
    }

    MenuItem makeSaveDataButton(final ScreenManager screenManager) {
        if (!this.hasSaveDataButton) {
            return null;
        }
        PushButton pushButton = new PushButton("Save Data", "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScriptedTest.this.storeResults(screenManager);
            }
        });
        return pushButton;
    }

    private void saveValues() {
        if (this.getCurrentSettingsModel() != null) {
            LongActuator[] longActuatorArray = this.getCurrentSettingsModel().getStorableActuators();
            for (int i = 0; i < longActuatorArray.length; ++i) {
                SiteConfigurationValues.instance().captureSettingsValue("display." + this.moniker + "|" + longActuatorArray[i].getWebPlugConversion().getPropertyName(), longActuatorArray[i].longValue() + "");
            }
        }
    }

    private MeasurementSettings getCurrentSettingsModel() {
        if (this.measurementScreenDef != null) {
            return this.measurementScreenDef.getSettingsModel();
        }
        return null;
    }

    protected MenuItem makeMeasurementCancelButton(final ScreenManager screenManager) {
        return new PushButton("Return to\nMenu", "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScriptedTest.this.saveValues();
                TestMenuScreen.turnSigGenOff();
                screenManager.popScreen();
            }
        });
    }

    private MenuItem makeNextTestButton(final ScreenManager screenManager) {
        String string = this.hasSaveDataButton ? "\n(save data)" : "";
        return new PushButton("Proceed" + string, "testing", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ScriptedTest.this.measurementScreen != null) {
                    ScriptedTest.this.storeResults(screenManager);
                }
                ScriptedTest.this.saveValues();
                TestMenuScreen.turnSigGenOff();
                screenManager.popScreen();
                Screen screen = ScriptedTest.this.nextScreen();
                if (screen != null) {
                    screenManager.pushScreen(screen);
                } else {
                    ((TestMenuScreen)screenManager.getCurrentScreen()).advanceSelection();
                }
            }
        });
    }

    private void storeResults(ScreenManager screenManager) {
        String string = this.measurementScreen.getTestResults(screenManager, this.getName());
        if (string.length() > 0) {
            MeasurementResults.getInstance().writeResults(string, screenManager, this.getIndex());
        }
    }

    public boolean getHasSaveDataButton() {
        return this.hasSaveDataButton;
    }

    public boolean isDesired(SiteConfigurationValues siteConfigurationValues) {
        boolean bl = this.legalBaseStations == null || Arrays.contains(this.legalBaseStations, siteConfigurationValues.getSiteTestType().getName());
        boolean bl2 = !this.requiresMultiCarrier || !"N/A".equals(siteConfigurationValues.getCarrierPowerOut());
        return bl && bl2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

