/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.gui.MainWindow;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.mainScreens.DefaultProgressIndicator;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.mainScreens.StatusBar;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.scriptedTests.ScriptedTest;
import elgato.infrastructure.scriptedTests.SiteConfigurationValues;
import elgato.infrastructure.scriptedTests.TestMenuScreen;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.Text;
import elgato.measurement.sigGen.SigGenMeasurementSettings;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public abstract class ScriptedTestScreen
extends Screen {
    protected ScriptedTest scriptedTest;
    protected JTextArea contentJTextArea;
    String headerText;
    protected DefaultProgressIndicator progressIndicator;
    boolean startSigGen = false;

    public ScriptedTestScreen(String string, ScriptedTest scriptedTest) {
        this.scriptedTest = scriptedTest;
        this.headerText = string;
    }

    protected JTextArea createJtextArea(String string) {
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setSize(this.getDesiredWidth(), 50);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        return jTextArea;
    }

    protected int getDesiredWidth() {
        Rectangle rectangle = MainWindow.getRootPanel().getBounds();
        int n = this.getScreenManager().getLeftMenuPanel().getWidth();
        int n2 = this.getScreenManager().getRightMenuPanel().getWidth();
        return rectangle.width - n - n2 - 30;
    }

    void setHeaderTextAndColor(JTextArea jTextArea, Color color) {
        jTextArea.setForeground(color);
        jTextArea.setText(this.headerText);
    }

    protected Menu makeRightMenu() {
        return new Menu("", new MenuItem[]{this.makeProceedButton(), null, null, null, null, null, this.makeCancelButton()});
    }

    protected void doStuff() {
    }

    protected MenuItem makeProceedButton() {
        return new PushButton("Proceed", this.getContextString(""), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScriptedTestScreen.this.doStuff();
                ScreenManager screenManager = ScriptedTestScreen.this.getScreenManager();
                screenManager.popScreen();
                Screen screen = ScriptedTestScreen.this.scriptedTest.nextScreen();
                if (screen != null) {
                    screenManager.pushScreen(screen);
                } else if (!ScriptedTestScreen.this.scriptedTest.showMeasurementScreen(screenManager)) {
                    ((TestMenuScreen)screenManager.getCurrentScreen()).advanceSelection();
                }
            }
        });
    }

    protected MenuItem makeCancelButton() {
        return new PushButton("Return to\nMenu", this.getContextString(""), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScreenManager screenManager = ScriptedTestScreen.this.getScreenManager();
                screenManager.popScreen();
                TestMenuScreen.turnSigGenOff();
            }
        });
    }

    protected DefaultProgressIndicator showProgressIndicator(ScreenManager screenManager, String string) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(null);
        CardLayout cardLayout = new CardLayout();
        jPanel.setLayout(cardLayout);
        DefaultProgressIndicator defaultProgressIndicator = new DefaultProgressIndicator(string);
        jPanel.add((Component)defaultProgressIndicator, "progress");
        defaultProgressIndicator.start();
        cardLayout.show(jPanel, "progress");
        screenManager.installDisplay(jPanel);
        return defaultProgressIndicator;
    }

    String setToken(String string, String string2, String string3) {
        int n;
        while ((n = string.indexOf(string2)) >= 0) {
            string = string.substring(0, n) + string3 + string.substring(n + string2.length());
        }
        return string;
    }

    String getBodyText() {
        return this.contentJTextArea.getText();
    }

    protected void startSigGenThread(ScreenManager screenManager) {
        screenManager.installRightMenu(new Menu("", new MenuItem[]{null, null, null, null, null, null, null}));
        this.progressIndicator = this.showProgressIndicator(screenManager, Text.Signal_Generator_Is_Loading);
        SigGenLoadedThread sigGenLoadedThread = new SigGenLoadedThread(screenManager);
        sigGenLoadedThread.start();
    }

    void fireOffSigGen(ScreenManager screenManager) {
        this.startSigGenThread(screenManager);
        SigGenMeasurementSettings sigGenMeasurementSettings = SigGenMeasurementSettings.instance();
        SiteConfigurationValues siteConfigurationValues = SiteConfigurationValues.instance();
        long l = (long)(new Double(siteConfigurationValues.getRfOutLoss()) * 1000.0);
        Command command = Command.makeSetCommand("source");
        command.addProperty("srcCf", siteConfigurationValues.getReverseFrequency() / 1000L);
        command.addProperty("pilotId", Double.valueOf(siteConfigurationValues.getPnOffset()).longValue());
        command.addProperty("rfOutLoss", l);
        this.doScreenSpecificFireOffSigGenCommand(command);
        command.addProperty("backgroundMode", 0L);
        command.addProperty("pwrOnOff", 1L);
        command.addProperty("modulation", 290L);
        sigGenMeasurementSettings.getLossToggle().send(1);
        sigGenMeasurementSettings.getStashedLoss().send(l);
        MeasurementFactory.instance().getCommandProcessor().setActive("source");
        MeasurementFactory.instance().getCommandProcessor().send(command);
    }

    protected void doScreenSpecificFireOffSigGenCommand(Command command) {
    }

    private void installScreenNext(ScreenManager screenManager) {
        if (this.progressIndicator != null) {
            this.progressIndicator.stop();
        }
        super.installScreen(screenManager);
        this.doScreenSpecificInstallConfig(screenManager);
    }

    protected void doScreenSpecificInstallConfig(ScreenManager screenManager) {
    }

    public void installScreen(ScreenManager screenManager) {
        if (this.startSigGen) {
            this.fireOffSigGen(screenManager);
        } else {
            this.progressIndicator = null;
            this.installScreenNext(screenManager);
        }
    }

    static /* synthetic */ void access$200(ScriptedTestScreen scriptedTestScreen, ScreenManager screenManager) {
        scriptedTestScreen.installScreenNext(screenManager);
    }

    public class SigGenLoadedThread
    extends Thread {
        private ScreenManager screenManager;

        public SigGenLoadedThread(ScreenManager screenManager) {
            this.screenManager = screenManager;
            this.setPriority(1);
        }

        public void run() {
            while (!((StatusBar)this.screenManager.getStatusHandler()).getStatus().startsWith("Signal generator is loaded")) {
            }
            EventDispatchThread.invokeLater(new Runnable(this){
                private final /* synthetic */ SigGenLoadedThread this$1;
                {
                    this.this$1 = sigGenLoadedThread;
                }

                public void run() {
                    ScriptedTestScreen.access$200(SigGenLoadedThread.access$100(this.this$1), SigGenLoadedThread.access$000(this.this$1));
                }
            }, "InputScreen.installScreenNext");
        }

        static /* synthetic */ ScreenManager access$000(SigGenLoadedThread sigGenLoadedThread) {
            return sigGenLoadedThread.screenManager;
        }

        static /* synthetic */ ScriptedTestScreen access$100(SigGenLoadedThread sigGenLoadedThread) {
            return sigGenLoadedThread.ScriptedTestScreen.this;
        }
    }
}

