/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.scriptedTests.CarrierCabinetKey;
import elgato.infrastructure.scriptedTests.CertificationSuiteReader;
import elgato.infrastructure.scriptedTests.PowerOutValues;
import elgato.infrastructure.scriptedTests.RxLimits;
import elgato.infrastructure.scriptedTests.SoftwareFileSystem;
import elgato.infrastructure.scriptedTests.TestScreenDefinition;
import elgato.infrastructure.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;

public class SimpleCertificationSuiteReader
extends CertificationSuiteReader {
    protected FileInputBuffer buffer;
    private String packageId;
    static final int BASE_STATION_LIMIT = 0;
    static final int BASE_STATION_LPP = 1;
    static final int BASE_STATION_IMF = 2;
    static final int BASE_STATION_COMBINER = 3;

    protected void populateDataLists(SoftwareFileSystem softwareFileSystem, String string) {
        this.readFile(softwareFileSystem.getScript(string));
    }

    protected void readFile(String string) {
        this.buffer = new FileInputBuffer(string);
        this.processFile();
        this.doFakeReads();
    }

    protected String[] readList() {
        Vector<String> vector = new Vector<String>();
        String string = this.buffer.nextToken();
        while (!"END".equals(string)) {
            vector.addElement(string);
            string = this.buffer.nextToken();
        }
        return Arrays.toArray(vector);
    }

    private void processFile() {
        String string = this.buffer.nextToken();
        while (this.buffer.buffer.length() > 0 && !"ENDFILE".equals(string)) {
            int n;
            int n2;
            int n3;
            Object object;
            if ("RXLIST".equals(string)) {
                object = this.buffer.nextToken();
                this.rxLists.put(object, this.readList());
            } else if ("PACKAGEID".equals(string)) {
                this.packageId = this.buffer.nextToken();
            } else if ("TXLIST".equals(string)) {
                object = this.buffer.nextToken();
                this.txLists.put(object, this.readList());
            } else if ("CABINETCONFIGLIST".equals(string)) {
                object = this.buffer.nextToken();
                this.cabinetConfLists.put(object, this.readList());
            } else if ("CARRIERCONFIG".equals(string)) {
                object = this.buffer.nextToken();
                this.carrierConfLists.put(object, this.readList());
            } else if ("Sector".equals(string)) {
                object = this.buffer.nextToken();
                this.sectorLists.put(object, this.readList());
            } else if ("CHANNELSTANDARD".equals(string)) {
                object = this.buffer.nextToken();
                this.chanStandardLists.put(object, this.readList());
            } else if ("BASESTATIONTYPE".equals(string)) {
                object = new CertificationSuiteReader.BaseStationDef();
                ((CertificationSuiteReader.BaseStationDef)object).name = this.buffer.nextToken();
                ((CertificationSuiteReader.BaseStationDef)object).sectorList = this.buffer.nextToken();
                ((CertificationSuiteReader.BaseStationDef)object).rxList = this.buffer.nextToken();
                ((CertificationSuiteReader.BaseStationDef)object).txList = this.buffer.nextToken();
                ((CertificationSuiteReader.BaseStationDef)object).chanStdList = this.buffer.nextToken();
                ((CertificationSuiteReader.BaseStationDef)object).cabConfigList = this.buffer.nextToken();
                ((CertificationSuiteReader.BaseStationDef)object).carrierConfigList = this.buffer.nextToken();
                ((CertificationSuiteReader.BaseStationDef)object).powerOutTable = this.buffer.nextToken();
                ((CertificationSuiteReader.BaseStationDef)object).recommendedOCNS = this.buffer.nextToken();
                ((CertificationSuiteReader.BaseStationDef)object).connectionDevices = this.buffer.nextToken();
                ((CertificationSuiteReader.BaseStationDef)object).troubleshootConnectionDevices = this.buffer.nextToken();
                ((CertificationSuiteReader.BaseStationDef)object).rxValues = this.buffer.nextToken();
                ((CertificationSuiteReader.BaseStationDef)object).powerValues = this.buffer.nextToken();
                this.stationTypes.addElement(object);
            } else if ("CONNECTIONDEVICELIST".equals(string)) {
                object = this.buffer.nextToken();
                n3 = Integer.parseInt(this.buffer.nextToken());
                n2 = Integer.parseInt(this.buffer.nextToken());
                String[][] stringArray = new String[n3][n2];
                for (int i = 0; i < n3; ++i) {
                    for (n = 0; n < n2; ++n) {
                        stringArray[i][n] = this.buffer.nextToken();
                    }
                }
                this.connectionDeviceLists.put(object, stringArray);
            } else if ("TROUBLESHOOTINGCONNECTIONDEVICELIST".equals(string)) {
                object = this.buffer.nextToken();
                n3 = Integer.parseInt(this.buffer.nextToken());
                n2 = Integer.parseInt(this.buffer.nextToken());
                int n4 = Integer.parseInt(this.buffer.nextToken());
                String[][][] stringArray = new String[n3][n2][n4];
                for (n = 0; n < n3; ++n) {
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n4; ++j) {
                            stringArray[n][i][j] = this.buffer.nextToken();
                        }
                    }
                }
                this.troubleshootConnectionDeviceLists.put(object, stringArray);
            } else if ("TESTDEFINITION".equals(string)) {
                this.testList.addElement(this.readTest());
            } else if ("CALTESTDEFINITION".equals(string)) {
                this.calTestList.addElement(this.readTest());
            }
            string = this.buffer.nextToken();
        }
    }

    private CertificationSuiteReader.PseudoTestListEntry readTest() {
        Object object;
        Vector<TestScreenDefinition> vector = new Vector<TestScreenDefinition>();
        String[] stringArray = null;
        String string = this.buffer.nextToken();
        String string2 = this.buffer.nextToken();
        String string3 = this.buffer.nextToken();
        String string4 = this.buffer.nextToken();
        String string5 = this.buffer.nextToken();
        while ("SCREEN".equals(string5)) {
            String string6;
            String string7;
            object = this.buffer.nextToken();
            if ("GRAPHIC".equals(object)) {
                string7 = this.buffer.nextToken();
                string6 = this.buffer.nextToken();
                String string8 = this.buffer.nextToken();
                String string9 = this.buffer.nextToken();
                String string10 = this.buffer.nextToken();
                boolean bl = "YES".equals(this.buffer.nextToken());
                vector.addElement(TestScreenDefinition.createGraphicScreenDefinition(string7, new String[]{string6, string8, string9, string10}, this.swDirectory, this.packageId, bl));
            } else if ("PASSFAIL".equals(object)) {
                string7 = this.buffer.nextToken();
                string6 = this.buffer.nextToken();
                String string11 = this.buffer.nextToken();
                String string12 = this.buffer.nextToken();
                boolean bl = "YES".equals(this.buffer.nextToken());
                vector.addElement(TestScreenDefinition.createPassFailScreenDefinition(string7, string6, string11, string12, this.swDirectory, this.packageId, bl));
            } else if ("INPUT".equals(object)) {
                string7 = this.buffer.nextToken();
                string6 = this.buffer.nextToken();
                String string13 = this.buffer.nextToken();
                boolean bl = "YES".equals(this.buffer.nextToken().toUpperCase());
                long l = Long.parseLong(this.buffer.nextToken());
                long l2 = Long.parseLong(this.buffer.nextToken());
                long l3 = Long.parseLong(this.buffer.nextToken());
                int n = Integer.parseInt(this.buffer.nextToken());
                vector.addElement(TestScreenDefinition.createInputScreenDefinition(string7, string6, string13, bl, l, l2, l3, n, this.swDirectory, this.packageId));
            } else if ("TEXT".equals(object)) {
                string7 = this.buffer.nextToken();
                string6 = this.buffer.nextToken();
                boolean bl = "YES".equals(this.buffer.nextToken().toUpperCase());
                vector.addElement(TestScreenDefinition.createTextScreenDefinition(string7, string6, this.swDirectory, this.packageId, bl, -90000L));
            }
            string5 = this.buffer.nextToken();
        }
        if (!"ALL".equals(string5)) {
            object = new Vector();
            while (!"END".equals(string5)) {
                ((Vector)object).addElement(string5);
                string5 = this.buffer.nextToken();
            }
            stringArray = Arrays.toArray((Vector)object);
        }
        return new CertificationSuiteReader.PseudoTestListEntry(string, string2, string3, "YES".equals(string4.trim().toUpperCase()), false, CertificationSuiteReader.covertVectorToTestScreenDefs(vector), stringArray);
    }

    private void doFakeReads() {
        this.rxValuesArrays.put("rx800", this.createFRM800RxTables());
        this.rxValuesArrays.put("rx800M", this.createMFRM800RxTables());
        this.rxValuesArrays.put("rx800Compact", this.createCompact800RxTables());
        this.rxValuesArrays.put("rx1900", this.createFRM1900RxTables());
        this.rxValuesArrays.put("rx1900M", this.createMFRM1900RxTables());
        this.rxValuesArrays.put("rx1900Compact", this.createCompact1900RxTables());
        this.rxValuesArrays.put("rx800Rural", this.createRuralRxTables());
        this.powerValuesArrays.put("800", this.createFRM800PowerTables());
        this.powerValuesArrays.put("800M", this.createMFRM800PowerTables());
        this.powerValuesArrays.put("800Compact", this.createCompact800PowerTables());
        this.powerValuesArrays.put("1900", this.createMetro1900PowerTables());
        this.powerValuesArrays.put("1900M", this.createMFRM1900PowerTables());
        this.powerOutTables.put("power800", this.createMetro800Table());
        this.powerOutTables.put("power800M", this.createMFRM800Table());
        this.powerOutTables.put("power800HP", this.createMFRM800HPTable());
        this.powerOutTables.put("power800Compact", this.createCompact800Table());
        this.powerOutTables.put("power800CompactHP", this.createCompact800HPTable());
        this.powerOutTables.put("power1900", this.createMetro1900Table());
        this.powerOutTables.put("power1900M", this.createMFRM1900Table());
        this.powerOutTables.put("power1900HP", this.createMFRM1900HPTable());
        this.powerOutTables.put("power1900Compact", this.createCompact1900Table());
        this.powerOutTables.put("power450", this.createMFRM450Table());
        this.powerOutTables.put("power450HP", this.createMFRM450HPTable());
    }

    private Hashtable createMFRM800Table() {
        String[] stringArray = new String[]{"Indoor", "Outdoor"};
        String[] stringArray2 = new String[]{"1 MFRM Duplexer w/ Preselector", "2 MFRM (1st MFRM) Duplexer", "2 MFRM (2nd MFRM) Duplexer", "1 MFRM/1 SFRM (MFRM) Duplexer", "1 MFRM/1 SFRM (SFRM) Duplexer", "1 MFRM/2 SFRM (MFRM) Duplexer", "1 MFRM/2 SFRM (1st SFRM) Duplexer w/o Combiner", "1 MFRM/2 SFRM (2nd SFRM) Duplexer w/o Combiner", "1 MFRM/2 SFRM (1st SFRM) Duplexer w/ Combiner", "1 MFRM/2 SFRM (2nd SFRM) Duplexer w/ Combiner"};
        Hashtable<CarrierCabinetKey, PowerOutValues> hashtable = new Hashtable<CarrierCabinetKey, PowerOutValues>(10);
        PowerOutValues powerOutValues = new PowerOutValues("41.125", "45.937", 4.319);
        PowerOutValues powerOutValues2 = new PowerOutValues("41.125", "N/A", 4.319);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            hashtable.put(new CarrierCabinetKey(stringArray2[0], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[1], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[2], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[3], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[4], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[5], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[6], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[7], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[8], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[9], string), powerOutValues2);
        }
        return hashtable;
    }

    private Hashtable createMFRM800HPTable() {
        String[] stringArray = new String[]{"Indoor", "Outdoor"};
        String[] stringArray2 = new String[]{"1 MFRM Duplexer w/ Preselector", "2 MFRM (1st MFRM) Duplexer", "2 MFRM (2nd MFRM) Duplexer", "1 MFRM/1 SFRM (MFRM) Duplexer", "1 MFRM/1 SFRM (SFRM) Duplexer", "1 MFRM/2 SFRM (MFRM) Duplexer", "1 MFRM/2 SFRM (1st SFRM) Duplexer w/o Combiner", "1 MFRM/2 SFRM (2nd SFRM) Duplexer w/o Combiner", "1 MFRM/2 SFRM (1st SFRM) Duplexer w/ Combiner", "1 MFRM/2 SFRM (2nd SFRM) Duplexer w/ Combiner"};
        Hashtable<CarrierCabinetKey, PowerOutValues> hashtable = new Hashtable<CarrierCabinetKey, PowerOutValues>(10);
        PowerOutValues powerOutValues = new PowerOutValues("45.625", "45.687", 12.173);
        PowerOutValues powerOutValues2 = new PowerOutValues("45.625", "N/A", 12.173);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            hashtable.put(new CarrierCabinetKey(stringArray2[0], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[1], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[2], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[3], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[4], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[5], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[6], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[7], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[8], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[9], string), powerOutValues2);
        }
        return hashtable;
    }

    private Hashtable createMFRM450Table() {
        Hashtable<CarrierCabinetKey, PowerOutValues> hashtable = new Hashtable<CarrierCabinetKey, PowerOutValues>(10);
        PowerOutValues powerOutValues = new PowerOutValues("41.562", "46.312", 4.776);
        PowerOutValues powerOutValues2 = new PowerOutValues("41.562", "N/A", 4.776);
        String[] stringArray = new String[]{"Indoor", "Outdoor"};
        String[] stringArray2 = new String[]{"1 MFRM Duplexer w/ Preselector", "2 MFRM (1st MFRM) Duplexer", "2 MFRM (2nd MFRM) Duplexer", "1 MFRM/1 SFRM (MFRM) Duplexer", "1 MFRM/1 SFRM (SFRM) Duplexer", "1 MFRM/2 SFRM (MFRM) Duplexer", "1 MFRM/2 SFRM (1st SFRM) Duplexer w/o Combiner", "1 MFRM/2 SFRM (2nd SFRM) Duplexer w/o Combiner", "1 MFRM/2 SFRM (1st SFRM) Duplexer w/ Combiner", "1 MFRM/2 SFRM (2nd SFRM) Duplexer w/ Combiner"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            hashtable.put(new CarrierCabinetKey(stringArray2[0], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[1], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[2], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[3], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[4], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[5], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[6], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[7], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[8], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[9], string), powerOutValues2);
        }
        return hashtable;
    }

    private Hashtable createMFRM450HPTable() {
        Hashtable<CarrierCabinetKey, PowerOutValues> hashtable = new Hashtable<CarrierCabinetKey, PowerOutValues>(10);
        PowerOutValues powerOutValues = new PowerOutValues("46.062", "46.125", 13.46);
        PowerOutValues powerOutValues2 = new PowerOutValues("46.062", "N/A", 13.46);
        String[] stringArray = new String[]{"Indoor", "Outdoor"};
        String[] stringArray2 = new String[]{"1 MFRM Duplexer w/ Preselector", "2 MFRM (1st MFRM) Duplexer", "2 MFRM (2nd MFRM) Duplexer", "1 MFRM/1 SFRM (MFRM) Duplexer", "1 MFRM/1 SFRM (SFRM) Duplexer", "1 MFRM/2 SFRM (MFRM) Duplexer", "1 MFRM/2 SFRM (1st SFRM) Duplexer w/o Combiner", "1 MFRM/2 SFRM (2nd SFRM) Duplexer w/o Combiner", "1 MFRM/2 SFRM (1st SFRM) Duplexer w/ Combiner", "1 MFRM/2 SFRM (2nd SFRM) Duplexer w/ Combiner"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            hashtable.put(new CarrierCabinetKey(stringArray2[0], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[1], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[2], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[3], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[4], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[5], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[6], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[7], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[8], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[9], string), powerOutValues2);
        }
        return hashtable;
    }

    private Hashtable createCompact800Table() {
        String[] stringArray = new String[]{"Outdoor"};
        String[] stringArray2 = new String[]{"1 MFRM Duplexer w/ Preselector", "2 MFRM (1st MFRM) Duplexer", "2 MFRM (2nd MFRM) Duplexer", "1 MFRM/1 SFRM (MFRM) Duplexer", "1 MFRM/1 SFRM (SFRM) Duplexer", "1 MFRM/2 SFRM (MFRM) Duplexer", "1 MFRM/2 SFRM (1st SFRM) Duplexer w/o Combiner", "1 MFRM/2 SFRM (2nd SFRM) Duplexer w/o Combiner", "1 MFRM/2 SFRM (1st SFRM) Duplexer w/ Combiner", "1 MFRM/2 SFRM (2nd SFRM) Duplexer w/ Combiner"};
        Hashtable<CarrierCabinetKey, PowerOutValues> hashtable = new Hashtable<CarrierCabinetKey, PowerOutValues>(10);
        PowerOutValues powerOutValues = new PowerOutValues("41.125", "45.875", 4.319);
        PowerOutValues powerOutValues2 = new PowerOutValues("41.125", "N/A", 4.319);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            hashtable.put(new CarrierCabinetKey(stringArray2[0], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[1], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[2], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[3], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[4], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[5], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[6], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[7], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[8], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[9], string), powerOutValues2);
        }
        return hashtable;
    }

    private Hashtable createCompact800HPTable() {
        String[] stringArray = new String[]{"Outdoor"};
        String[] stringArray2 = new String[]{"1 MFRM Duplexer w/ Preselector", "2 MFRM (1st MFRM) Duplexer", "2 MFRM (2nd MFRM) Duplexer", "1 MFRM/1 SFRM (MFRM) Duplexer", "1 MFRM/1 SFRM (SFRM) Duplexer", "1 MFRM/2 SFRM (MFRM) Duplexer", "1 MFRM/2 SFRM (1st SFRM) Duplexer w/o Combiner", "1 MFRM/2 SFRM (2nd SFRM) Duplexer w/o Combiner", "1 MFRM/2 SFRM (1st SFRM) Duplexer w/ Combiner", "1 MFRM/2 SFRM (2nd SFRM) Duplexer w/ Combiner"};
        Hashtable<CarrierCabinetKey, PowerOutValues> hashtable = new Hashtable<CarrierCabinetKey, PowerOutValues>(10);
        PowerOutValues powerOutValues = new PowerOutValues("45.625", "45.687", 12.173);
        PowerOutValues powerOutValues2 = new PowerOutValues("45.625", "N/A", 12.173);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            hashtable.put(new CarrierCabinetKey(stringArray2[0], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[1], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[2], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[3], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[4], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[5], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[6], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[7], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[8], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[9], string), powerOutValues2);
        }
        return hashtable;
    }

    private Hashtable createMetro1900Table() {
        String[] stringArray = new String[]{"Indoor", "Outdoor"};
        String[] stringArray2 = new String[]{"1 Carr (1st) Mod1 Dup w/ Preselector", "2 Carr (1st) Mod2 Dup w/o Preselector", "2 Carr (2nd) Mod2 Dup w/o Preselector", "3 Carr (1st) Triplexer", "3 Carr (2nd) Mod2 Dup w/o Preselector", "3 Carr (3rd) No Dup or Triplexer", "4 Carr (1st) Triplexer", "4 Carr (2nd) Triplexer", "4 Carr (3rd) No Dup or Triplexer", "4 Carr (4th) No Dup or Triplexer"};
        Hashtable<CarrierCabinetKey, PowerOutValues> hashtable = new Hashtable<CarrierCabinetKey, PowerOutValues>(10);
        PowerOutValues powerOutValues = new PowerOutValues("38.5", "N/A", 2.36);
        PowerOutValues powerOutValues2 = new PowerOutValues("38.5", "N/A", 2.36);
        for (int i = 0; i < stringArray2.length; ++i) {
            hashtable.put(new CarrierCabinetKey(stringArray2[i], stringArray[0]), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[i], stringArray[1]), powerOutValues2);
        }
        return hashtable;
    }

    private Hashtable createMFRM1900Table() {
        String[] stringArray = new String[]{"Indoor", "Outdoor"};
        String[] stringArray2 = new String[]{"1 MFRM Duplexer w/ Preselector", "2 MFRM (1st MFRM) Duplexer", "2 MFRM (2nd MFRM) Duplexer", "1 MFRM/1 SFRM (MFRM) Duplexer", "1 MFRM/1 SFRM (SFRM) Duplexer", "1 MFRM/2 SFRM (MFRM) Duplexer", "1 MFRM/2 SFRM (1st SFRM) Triplexer/Duplexer", "1 MFRM/2 SFRM (2nd SFRM) Triplexer/Duplexer", "2 MFRM (1st MFRM) Triplexer", "2 MFRM (2nd MFRM) Triplexer", "1 MFRM/1 SFRM (MFRM) Triplexer", "1 MFRM/1 SFRM (SFRM) Triplexer", "1 MFRM/2 SFRM (MFRM) Triplexer", "1 MFRM/2 SFRM (1st SFRM) Triplexer/Triplexer", "1 MFRM/2 SFRM (2nd SFRM) Triplexer/Triplexer"};
        Hashtable<CarrierCabinetKey, PowerOutValues> hashtable = new Hashtable<CarrierCabinetKey, PowerOutValues>(15);
        PowerOutValues powerOutValues = new PowerOutValues("38.5", "43.3125", 2.36);
        PowerOutValues powerOutValues2 = new PowerOutValues("38.5", "N/A", 2.36);
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string = stringArray[i];
            for (n = 0; n < 4; ++n) {
                hashtable.put(new CarrierCabinetKey(stringArray2[n], string), powerOutValues);
            }
            hashtable.put(new CarrierCabinetKey(stringArray2[4], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[5], string), powerOutValues);
            for (n = 6; n < 8; ++n) {
                hashtable.put(new CarrierCabinetKey(stringArray2[n], string), powerOutValues2);
            }
            for (n = 8; n < 11; ++n) {
                hashtable.put(new CarrierCabinetKey(stringArray2[n], string), powerOutValues);
            }
            hashtable.put(new CarrierCabinetKey(stringArray2[11], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[12], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[13], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[14], string), powerOutValues2);
        }
        return hashtable;
    }

    private Hashtable createMFRM1900HPTable() {
        Hashtable<CarrierCabinetKey, PowerOutValues> hashtable = new Hashtable<CarrierCabinetKey, PowerOutValues>(15);
        PowerOutValues powerOutValues = new PowerOutValues("43", "43.06", 6.651);
        PowerOutValues powerOutValues2 = new PowerOutValues("43", "N/A", 6.651);
        String[] stringArray = new String[]{"Indoor", "Outdoor"};
        String[] stringArray2 = new String[]{"1 MFRM Duplexer w/ Preselector", "2 MFRM (1st MFRM) Duplexer", "2 MFRM (2nd MFRM) Duplexer", "1 MFRM/1 SFRM (MFRM) Duplexer", "1 MFRM/1 SFRM (SFRM) Duplexer", "1 MFRM/2 SFRM (MFRM) Duplexer", "1 MFRM/2 SFRM (1st SFRM) Triplexer/Duplexer", "1 MFRM/2 SFRM (2nd SFRM) Triplexer/Duplexer", "2 MFRM (1st MFRM) Triplexer", "2 MFRM (2nd MFRM) Triplexer", "1 MFRM/1 SFRM (MFRM) Triplexer", "1 MFRM/1 SFRM (SFRM) Triplexer", "1 MFRM/2 SFRM (MFRM) Triplexer", "1 MFRM/2 SFRM (1st SFRM) Triplexer/Triplexer", "1 MFRM/2 SFRM (2nd SFRM) Triplexer/Triplexer"};
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string = stringArray[i];
            for (n = 0; n < 4; ++n) {
                hashtable.put(new CarrierCabinetKey(stringArray2[n], string), powerOutValues);
            }
            hashtable.put(new CarrierCabinetKey(stringArray2[4], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[5], string), powerOutValues);
            for (n = 6; n < 8; ++n) {
                hashtable.put(new CarrierCabinetKey(stringArray2[n], string), powerOutValues2);
            }
            for (n = 8; n < 11; ++n) {
                hashtable.put(new CarrierCabinetKey(stringArray2[n], string), powerOutValues);
            }
            hashtable.put(new CarrierCabinetKey(stringArray2[11], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[12], string), powerOutValues);
            hashtable.put(new CarrierCabinetKey(stringArray2[13], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[14], string), powerOutValues2);
        }
        return hashtable;
    }

    private Hashtable createCompact1900Table() {
        String[] stringArray = new String[]{"Outdoor"};
        String[] stringArray2 = new String[]{"1 MFRM Duplexer w/ Preselector", "2 MFRM (1st MFRM) Duplexer", "2 MFRM (2nd MFRM) Duplexer", "1 MFRM/1 SFRM (MFRM) Duplexer", "1 MFRM/1 SFRM (SFRM) Duplexer", "1 MFRM/2 SFRM (MFRM) Duplexer", "1 MFRM/2 SFRM (1st SFRM) Triplexer/Duplexer", "1 MFRM/2 SFRM (2nd SFRM) Triplexer/Duplexer", "2 MFRM (1st MFRM) Triplexer", "2 MFRM (2nd MFRM) Triplexer", "1 MFRM/1 SFRM (MFRM) Triplexer", "1 MFRM/1 SFRM (SFRM) Triplexer", "1 MFRM/2 SFRM (MFRM) Triplexer", "1 MFRM/2 SFRM (1st SFRM) Triplexer/Triplexer", "1 MFRM/2 SFRM (2nd SFRM) Triplexer/Triplexer"};
        Hashtable<CarrierCabinetKey, PowerOutValues> hashtable = new Hashtable<CarrierCabinetKey, PowerOutValues>(10);
        PowerOutValues powerOutValues = new PowerOutValues("44.79", "40.02", 1.795);
        PowerOutValues powerOutValues2 = new PowerOutValues("40.02", "N/A", 1.795);
        PowerOutValues powerOutValues3 = new PowerOutValues("44.67", "39.57", 1.618);
        PowerOutValues powerOutValues4 = new PowerOutValues("39.57", "N/A", 1.618);
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string = stringArray[i];
            for (n = 0; n < 4; ++n) {
                hashtable.put(new CarrierCabinetKey(stringArray2[n], string), powerOutValues);
            }
            hashtable.put(new CarrierCabinetKey(stringArray2[4], string), powerOutValues2);
            hashtable.put(new CarrierCabinetKey(stringArray2[5], string), powerOutValues);
            for (n = 6; n < 8; ++n) {
                hashtable.put(new CarrierCabinetKey(stringArray2[n], string), powerOutValues4);
            }
            for (n = 8; n < 11; ++n) {
                hashtable.put(new CarrierCabinetKey(stringArray2[n], string), powerOutValues3);
            }
            hashtable.put(new CarrierCabinetKey(stringArray2[11], string), powerOutValues4);
            hashtable.put(new CarrierCabinetKey(stringArray2[12], string), powerOutValues3);
            hashtable.put(new CarrierCabinetKey(stringArray2[13], string), powerOutValues4);
            hashtable.put(new CarrierCabinetKey(stringArray2[14], string), powerOutValues4);
        }
        return hashtable;
    }

    private Hashtable createMetro800Table() {
        String[] stringArray = new String[]{"Indoor", "Outdoor"};
        String[] stringArray2 = new String[]{"1 Carr (1st) Dup w/ Preselector", "2 Carr (1st) Dup w/o Preselector", "2 Carr (2nd) Dup w/o Preselector", "3 Carr (1st) Dup w/o Preselector w/ Combiner", "3 Carr (2nd) Dup w/o Preselector", "3 Carr (3rd) No Duplexer", "4 Carr (1st) Dup w/o Preselector w/ Combiner", "4 Carr (2nd) Dup w/o Preselector w/ Combiner", "4 Carr (3rd) No Duplexer", "4 Carr (4th) No Duplexer"};
        Hashtable<CarrierCabinetKey, PowerOutValues> hashtable = new Hashtable<CarrierCabinetKey, PowerOutValues>(10);
        PowerOutValues powerOutValues = new PowerOutValues("42.74", "N/A", 3.975);
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i];
            for (int j = 0; j < stringArray.length; ++j) {
                String string2 = stringArray[j];
                hashtable.put(new CarrierCabinetKey(string, string2), powerOutValues);
            }
        }
        return hashtable;
    }

    private RxLimits[] createCompact1900RxTables() {
        String[] stringArray = new String[]{"No Splitter", "1:2 Splitter", "1:2 Splitter Main / TRM Splitter Div", "No Splitter Main / 1:2 Splitter Div", "No Splitter Main / TRM Splitter Div", "No Splitter Main / 1:2 & TRM Splitter Div"};
        RxLimits[] rxLimitsArray = new RxLimits[]{new RxLimits(), new RxLimits()};
        rxLimitsArray[0].add("Outdoor", stringArray[0], "36500", "31500");
        rxLimitsArray[0].add("Outdoor", stringArray[1], "33000", "27700");
        rxLimitsArray[0].add("Outdoor", stringArray[2], "33000", "27700");
        rxLimitsArray[0].add("Outdoor", stringArray[3], "36500", "31500");
        rxLimitsArray[0].add("Outdoor", stringArray[4], "36500", "31500");
        rxLimitsArray[0].add("Outdoor", stringArray[5], "36500", "31500");
        rxLimitsArray[1].add("Outdoor", stringArray[0], "36500", "31500");
        rxLimitsArray[1].add("Outdoor", stringArray[1], "33000", "27700");
        rxLimitsArray[1].add("Outdoor", stringArray[2], "31200", "26200");
        rxLimitsArray[1].add("Outdoor", stringArray[3], "33000", "27700");
        rxLimitsArray[1].add("Outdoor", stringArray[4], "31200", "26200");
        rxLimitsArray[1].add("Outdoor", stringArray[5], "27700", "27400");
        return rxLimitsArray;
    }

    private RxLimits[] createMFRM1900RxTables() {
        String[] stringArray = new String[]{"No Splitter", "1:2 Splitter", "1:2 Splitter Main / TRM Splitter Div", "No Splitter Main / 1:2 Splitter Div", "No Splitter Main / TRM Splitter Div", "No Splitter Main / 1:2 & TRM Splitter Div"};
        RxLimits[] rxLimitsArray = new RxLimits[]{new RxLimits(), new RxLimits()};
        rxLimitsArray[0].add("Outdoor", stringArray[0], "36500", "31500");
        rxLimitsArray[0].add("Outdoor", stringArray[1], "33000", "27700");
        rxLimitsArray[0].add("Outdoor", stringArray[2], "33000", "27700");
        rxLimitsArray[0].add("Outdoor", stringArray[3], "36500", "31500");
        rxLimitsArray[0].add("Outdoor", stringArray[4], "36500", "31500");
        rxLimitsArray[0].add("Outdoor", stringArray[5], "36500", "31500");
        rxLimitsArray[1].add("Outdoor", stringArray[0], "36500", "31500");
        rxLimitsArray[1].add("Outdoor", stringArray[1], "33000", "27700");
        rxLimitsArray[1].add("Outdoor", stringArray[2], "31200", "26200");
        rxLimitsArray[1].add("Outdoor", stringArray[3], "33000", "27700");
        rxLimitsArray[1].add("Outdoor", stringArray[4], "31200", "26200");
        rxLimitsArray[1].add("Outdoor", stringArray[5], "27700", "27400");
        rxLimitsArray[0].add("Indoor", stringArray[0], "36800", "31800");
        rxLimitsArray[0].add("Indoor", stringArray[1], "33300", "28000");
        rxLimitsArray[0].add("Indoor", stringArray[2], "33300", "28000");
        rxLimitsArray[0].add("Indoor", stringArray[3], "36800", "31800");
        rxLimitsArray[0].add("Indoor", stringArray[4], "36800", "31800");
        rxLimitsArray[0].add("Indoor", stringArray[5], "36800", "31800");
        rxLimitsArray[1].add("Indoor", stringArray[0], "36800", "31800");
        rxLimitsArray[1].add("Indoor", stringArray[1], "33300", "28000");
        rxLimitsArray[1].add("Indoor", stringArray[2], "31500", "26500");
        rxLimitsArray[1].add("Indoor", stringArray[3], "33300", "28000");
        rxLimitsArray[1].add("Indoor", stringArray[4], "31500", "26500");
        rxLimitsArray[1].add("Indoor", stringArray[5], "28000", "27700");
        return rxLimitsArray;
    }

    private RxLimits[] createRuralRxTables() {
        String[] stringArray = new String[]{"No Splitter", "1:4 Splitter", "1:6 Splitter", "No Split Main/1:4 Split Div"};
        RxLimits[] rxLimitsArray = new RxLimits[]{new RxLimits(), new RxLimits()};
        rxLimitsArray[0].add("Outdoor", stringArray[0], "35900", "29900");
        rxLimitsArray[1].add("Outdoor", stringArray[0], "35900", "29900");
        rxLimitsArray[0].add("Outdoor", stringArray[1], "29400", "23100");
        rxLimitsArray[1].add("Outdoor", stringArray[1], "29400", "23100");
        rxLimitsArray[0].add("Outdoor", stringArray[2], "27400", "21100");
        rxLimitsArray[1].add("Outdoor", stringArray[2], "27400", "21100");
        rxLimitsArray[0].add("Outdoor", stringArray[3], "35900", "29900");
        rxLimitsArray[1].add("Outdoor", stringArray[3], "29100", "23100");
        rxLimitsArray[0].add("Indoor", stringArray[0], "36200", "32000");
        rxLimitsArray[1].add("Indoor", stringArray[0], "36200", "32000");
        rxLimitsArray[0].add("Indoor", stringArray[1], "29700", "23400");
        rxLimitsArray[1].add("Indoor", stringArray[1], "29700", "23400");
        rxLimitsArray[0].add("Indoor", stringArray[2], "27700", "21400");
        rxLimitsArray[1].add("Indoor", stringArray[2], "27700", "21400");
        rxLimitsArray[0].add("Indoor", stringArray[3], "36200", "32000");
        rxLimitsArray[1].add("Indoor", stringArray[3], "29400", "23400");
        return rxLimitsArray;
    }

    private RxLimits[] createMFRM800RxTables() {
        String[] stringArray = new String[]{"No Splitter", "1:2 Splitter", "1:4 Splitter", "1:6 Splitter", "No Splitter Main / 1:2 Splitter Div", "No Splitter Main / 1:4 Splitter Div", "No Splitter Main / 1:6 Splitter Div"};
        RxLimits[] rxLimitsArray = new RxLimits[]{new RxLimits(), new RxLimits()};
        rxLimitsArray[0].add("Outdoor", stringArray[0], "35900", "29900");
        rxLimitsArray[1].add("Outdoor", stringArray[0], "35900", "29900");
        rxLimitsArray[0].add("Outdoor", stringArray[1], "32400", "26100");
        rxLimitsArray[1].add("Outdoor", stringArray[1], "32400", "26100");
        rxLimitsArray[0].add("Outdoor", stringArray[2], "29400", "23100");
        rxLimitsArray[1].add("Outdoor", stringArray[2], "29400", "23100");
        rxLimitsArray[0].add("Outdoor", stringArray[3], "27400", "21100");
        rxLimitsArray[1].add("Outdoor", stringArray[3], "27400", "21100");
        rxLimitsArray[0].add("Outdoor", stringArray[4], "35900", "29900");
        rxLimitsArray[1].add("Outdoor", stringArray[4], "32400", "26100");
        rxLimitsArray[0].add("Outdoor", stringArray[5], "35900", "29900");
        rxLimitsArray[1].add("Outdoor", stringArray[5], "29400", "23100");
        rxLimitsArray[0].add("Outdoor", stringArray[6], "35900", "29900");
        rxLimitsArray[1].add("Outdoor", stringArray[6], "27400", "21100");
        rxLimitsArray[0].add("Indoor", stringArray[0], "36200", "30300");
        rxLimitsArray[1].add("Indoor", stringArray[0], "36200", "30300");
        rxLimitsArray[0].add("Indoor", stringArray[1], "32700", "26400");
        rxLimitsArray[1].add("Indoor", stringArray[1], "32700", "26400");
        rxLimitsArray[0].add("Indoor", stringArray[2], "29700", "23400");
        rxLimitsArray[1].add("Indoor", stringArray[2], "29700", "23400");
        rxLimitsArray[0].add("Indoor", stringArray[3], "27700", "21400");
        rxLimitsArray[1].add("Indoor", stringArray[3], "27700", "21400");
        rxLimitsArray[0].add("Indoor", stringArray[4], "36200", "30200");
        rxLimitsArray[1].add("Indoor", stringArray[4], "32700", "26400");
        rxLimitsArray[0].add("Indoor", stringArray[5], "36200", "30200");
        rxLimitsArray[1].add("Indoor", stringArray[5], "29700", "23400");
        rxLimitsArray[0].add("Indoor", stringArray[6], "36200", "30200");
        rxLimitsArray[1].add("Indoor", stringArray[6], "27700", "21400");
        return rxLimitsArray;
    }

    private RxLimits[] createFRM800RxTables() {
        String[] stringArray = new String[]{"No Splitter", "1:4 Splitter", "1:6 Splitter", "No Splitter Main / 1:4 Splitter Div"};
        RxLimits[] rxLimitsArray = new RxLimits[]{new RxLimits(), new RxLimits()};
        rxLimitsArray[0].add("Outdoor", stringArray[0], "35900", "29900");
        rxLimitsArray[1].add("Outdoor", stringArray[0], "35900", "29900");
        rxLimitsArray[0].add("Outdoor", stringArray[1], "29400", "23100");
        rxLimitsArray[1].add("Outdoor", stringArray[1], "29400", "23100");
        rxLimitsArray[0].add("Outdoor", stringArray[2], "27400", "21100");
        rxLimitsArray[1].add("Outdoor", stringArray[2], "27400", "21100");
        rxLimitsArray[0].add("Outdoor", stringArray[3], "35900", "29900");
        rxLimitsArray[1].add("Outdoor", stringArray[3], "29100", "23100");
        rxLimitsArray[0].add("Indoor", stringArray[0], "36200", "30200");
        rxLimitsArray[1].add("Indoor", stringArray[0], "36200", "30200");
        rxLimitsArray[0].add("Indoor", stringArray[1], "29700", "23400");
        rxLimitsArray[1].add("Indoor", stringArray[1], "29700", "23400");
        rxLimitsArray[0].add("Indoor", stringArray[2], "27700", "21400");
        rxLimitsArray[1].add("Indoor", stringArray[2], "27700", "21400");
        rxLimitsArray[0].add("Indoor", stringArray[3], "36200", "30200");
        rxLimitsArray[1].add("Indoor", stringArray[3], "29400", "23400");
        return rxLimitsArray;
    }

    private RxLimits[] createCompact800RxTables() {
        String[] stringArray = new String[]{"No Splitter", "1:2 Splitter", "1:4 Splitter", "1:6 Splitter", "No Splitter Main / 1:2 Splitter Div", "No Splitter Main / 1:4 Splitter Div", "No Splitter Main / 1:6 Splitter Div"};
        RxLimits[] rxLimitsArray = new RxLimits[]{new RxLimits(), new RxLimits()};
        rxLimitsArray[0].add("Outdoor", stringArray[0], "35900", "29900");
        rxLimitsArray[1].add("Outdoor", stringArray[0], "35900", "29900");
        rxLimitsArray[0].add("Outdoor", stringArray[1], "32400", "26100");
        rxLimitsArray[1].add("Outdoor", stringArray[1], "32400", "26100");
        rxLimitsArray[0].add("Outdoor", stringArray[2], "29400", "23100");
        rxLimitsArray[1].add("Outdoor", stringArray[2], "29400", "23100");
        rxLimitsArray[0].add("Outdoor", stringArray[3], "27400", "21100");
        rxLimitsArray[1].add("Outdoor", stringArray[3], "27400", "21100");
        rxLimitsArray[0].add("Outdoor", stringArray[4], "35900", "29900");
        rxLimitsArray[1].add("Outdoor", stringArray[4], "32400", "26100");
        rxLimitsArray[0].add("Outdoor", stringArray[5], "35900", "29900");
        rxLimitsArray[1].add("Outdoor", stringArray[5], "29400", "23100");
        rxLimitsArray[0].add("Outdoor", stringArray[6], "35900", "29900");
        rxLimitsArray[1].add("Outdoor", stringArray[6], "27400", "21100");
        return rxLimitsArray;
    }

    private RxLimits[] createFRM1900RxTables() {
        RxLimits[] rxLimitsArray = new RxLimits[]{new RxLimits(), new RxLimits()};
        rxLimitsArray[0].add("Outdoor", "1 Carr", "31200", "25200");
        rxLimitsArray[1].add("Outdoor", "1 Carr", "31200", "25200");
        rxLimitsArray[0].add("Outdoor", "2,3,4 Carr", "31200", "25200");
        rxLimitsArray[1].add("Outdoor", "2,3,4 Carr", "25700", "19700");
        rxLimitsArray[0].add("Outdoor", "3,4 Carr", "31200", "25200");
        rxLimitsArray[1].add("Outdoor", "3,4 Carr", "20200", "14200");
        rxLimitsArray[0].add("Indoor", "1 Carr", "31500", "25500");
        rxLimitsArray[1].add("Indoor", "1 Carr", "31500", "25500");
        rxLimitsArray[0].add("Indoor", "2,3,4 Carr", "31500", "25500");
        rxLimitsArray[1].add("Indoor", "2,3,4 Carr", "26000", "20000");
        rxLimitsArray[0].add("Indoor", "3,4 Carr", "31500", "25500");
        rxLimitsArray[1].add("Indoor", "3,4 Carr", "20500", "14500");
        return rxLimitsArray;
    }

    private RxLimits[] createMFRM1900PowerTables() {
        RxLimits[] rxLimitsArray = new RxLimits[]{new RxLimits(), new RxLimits(), new RxLimits(), new RxLimits()};
        rxLimitsArray[0].add("Outdoor", "", "-1270", "1270");
        rxLimitsArray[0].add("Indoor", "", "-1270", "1270");
        rxLimitsArray[1].add("Outdoor", "", "-250", "250");
        rxLimitsArray[1].add("Indoor", "", "0", "0");
        rxLimitsArray[2].add("Outdoor", "", "0", "0");
        rxLimitsArray[2].add("Indoor", "", "0", "0");
        rxLimitsArray[3].add("Outdoor", "", "0", "0");
        rxLimitsArray[3].add("Indoor", "", "0", "0");
        return rxLimitsArray;
    }

    private RxLimits[] createMFRM800PowerTables() {
        RxLimits[] rxLimitsArray = new RxLimits[]{new RxLimits(), new RxLimits(), new RxLimits(), new RxLimits()};
        rxLimitsArray[0].add("Outdoor", "", "-1270", "1270");
        rxLimitsArray[0].add("Indoor", "", "-1270", "1270");
        rxLimitsArray[1].add("Outdoor", "", "-250", "250");
        rxLimitsArray[1].add("Indoor", "", "0", "0");
        rxLimitsArray[2].add("Outdoor", "", "-800", "800");
        rxLimitsArray[2].add("Indoor", "", "-800", "800");
        rxLimitsArray[3].add("Outdoor", "", "-505", "505");
        rxLimitsArray[3].add("Indoor", "", "-505", "505");
        return rxLimitsArray;
    }

    private RxLimits[] createCompact800PowerTables() {
        RxLimits[] rxLimitsArray = new RxLimits[]{new RxLimits(), new RxLimits(), new RxLimits(), new RxLimits()};
        rxLimitsArray[0].add("Outdoor", "", "-1270", "1270");
        rxLimitsArray[1].add("Outdoor", "", "-250", "250");
        rxLimitsArray[2].add("Outdoor", "", "-800", "800");
        rxLimitsArray[3].add("Outdoor", "", "0", "0");
        return rxLimitsArray;
    }

    private RxLimits[] createFRM800PowerTables() {
        RxLimits[] rxLimitsArray = new RxLimits[]{new RxLimits(), new RxLimits(), new RxLimits(), new RxLimits()};
        rxLimitsArray[0].add("Outdoor", "", "-1500", "1500");
        rxLimitsArray[0].add("Indoor", "", "-1500", "1500");
        rxLimitsArray[1].add("Outdoor", "", "-250", "250");
        rxLimitsArray[1].add("Indoor", "", "0", "0");
        rxLimitsArray[2].add("Outdoor", "", "-800", "800");
        rxLimitsArray[2].add("Indoor", "", "-800", "800");
        rxLimitsArray[3].add("Outdoor", "", "-505", "505");
        rxLimitsArray[3].add("Indoor", "", "-505", "505");
        return rxLimitsArray;
    }

    private RxLimits[] createMetro1900PowerTables() {
        RxLimits[] rxLimitsArray = new RxLimits[]{new RxLimits(), new RxLimits(), new RxLimits(), new RxLimits()};
        rxLimitsArray[0].add("Outdoor", "", "-1300", "1300");
        rxLimitsArray[0].add("Indoor", "", "-1300", "1300");
        rxLimitsArray[1].add("Outdoor", "", "-250", "250");
        rxLimitsArray[1].add("Indoor", "", "0", "0");
        rxLimitsArray[2].add("Outdoor", "", "0", "0");
        rxLimitsArray[2].add("Indoor", "", "0", "0");
        rxLimitsArray[3].add("Outdoor", "", "0", "0");
        rxLimitsArray[3].add("Indoor", "", "0", "0");
        return rxLimitsArray;
    }

    static class FileInputBuffer {
        private String buffer;

        public FileInputBuffer(String string) {
            this.buffer = string;
        }

        public String nextToken() {
            String string;
            int n = this.buffer.indexOf(10);
            if (n > -1) {
                string = this.buffer.substring(0, n);
                this.buffer = this.buffer.substring(n + 1);
            } else {
                string = this.buffer;
                this.buffer = "";
            }
            return string.trim();
        }
    }
}

