/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.scriptedTests.CertificationSuite;
import elgato.infrastructure.scriptedTests.CertificationSuiteReader;
import elgato.infrastructure.scriptedTests.SiteTestType;
import elgato.infrastructure.scriptedTests.SiteTestTypeFactory;
import elgato.infrastructure.scriptedTests.SoftwareFileSystem;
import elgato.infrastructure.strategies.FixedPointNumberFieldStrategy;
import elgato.infrastructure.units.ChannelFrequencyConversion;
import elgato.infrastructure.util.Arrays;
import elgato.infrastructure.util.FileSystemHelper;
import elgato.infrastructure.util.HashMap;
import elgato.infrastructure.util.KeyValuePair;
import elgato.infrastructure.util.StorageDevice;
import elgato.infrastructure.util.chanstd.BandSelector;
import elgato.measurement.powerMeter.PowerMeterMeasurementSettings;
import elgato.measurement.sigGen.SigGenMeasurementSettings;
import elgato.measurement.spectrum.SpectrumMeasurementSettings;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class SiteConfigurationValues {
    Hashtable values = new Hashtable();
    private String valueDirectory = "config/";
    private static SiteConfigurationValues instance;
    public static final String BASESTATION_NAME = "BaseStationName";
    public static final String CARRIER_CONFIG = "CarrierConfig";
    public static final String CABINET_CONFIG = "CabinetConfig";
    public static final String SITE_TEST_TYPE = "SiteTestType";
    public static final String CHANNEL = "Channel";
    public static final String CHANNEL_STD = "ChannelStd";
    public static final String PN_OFFSET = "PnOffset";
    public static final String SECTOR = "Sector";
    public static final String POWER_OUT = "PowerOut";
    public static final String CARRIER_POWER_OUT = "CarrierPowerOut";
    public static final String RF_IN_LOSS = "RfInLoss";
    public static final String RF_OUT_LOSS = "RfOutLoss";
    public static final String POWER_METRIC_LOSS = "PowerMetricLoss";
    public static final String RX_CONFIG = "RXConfig";
    public static final String TX_CONFIG = "TXConfig";
    public static final String TX_SPLITTER = "TXSplitter";
    public static final String SHOW_DIAGRAMS = "ShowDiagrams";
    public static final String PILOT_GAIN = "PilotGain";
    public static final String SYNC_GAIN = "SyncGain";
    public static final String PAGE_GAIN = "PageGain";
    public static final String OCNS = "OCNS";
    public static final String NUM_CHANNELS = "NumChannels";
    public static final String DEFAULT_FILENAME = "defaultconfig";
    public static final String CONFIG_DIRECTORY = "config/";
    public static final String POWER_METER_AMP = "PowerMeterAmp";
    public static final String FREQ_TIME_REF = "freqTimeRef";
    public static final String RX_RECEIVE_POWER_UPPER_LIMIT = "RXReceivePowerUpper";
    public static final String RX_RECEIVE_POWER_LOWER_LIMIT = "RXReceivePowerLower";
    public static final String RX_RECEIVE_FER_LOWER_LIMIT = "RXReceiveFERLower";
    public static final String RX_RECEIVE_FER_UPPER_LIMIT = "RXReceiveFERUpper";
    public static final String POWER_METER_CAL_FACTOR = "PmCalFactor";
    public static final String POWER_METER_REF_CAL_FACTOR = "PmRefCalFactor";
    static final int NA_CELL = 0;
    static final int NA_PCS = 1;
    static final int KOREAN_PCS = 3;
    static final int NMT_450 = 16;
    private Hashtable settings = new Hashtable();
    private String currentFilename;

    SiteConfigurationValues() {
        this.setRfInLoss("0.0", false);
        this.setRfOutLoss("0.0", false);
        this.setPowerMeterLoss("0.0", false);
        this.setPowerMeterAmplitude("-119");
    }

    public static SiteConfigurationValues instance() {
        if (instance == null) {
            instance = new SiteConfigurationValues();
        }
        return instance;
    }

    public void setValue(String string, String string2, boolean bl) {
        if (RF_IN_LOSS.equals(string)) {
            this.setRfInLoss(string2, bl);
        } else if (RF_OUT_LOSS.equals(string)) {
            this.setRfOutLoss(string2, bl);
        } else if (POWER_METRIC_LOSS.equals(string)) {
            this.setPowerMeterLoss(string2, bl);
        } else {
            if (this.values.containsKey(string)) {
                this.values.remove(string);
            }
            this.values.put(string, string2);
            this.validateAll();
        }
    }

    private String formatNumericValue(String string, String string2) {
        if (this.isDecimal(string)) {
            if (string2.length() == 0) {
                string2 = "0";
            } else if (!string2.equals("N/A")) {
                return SiteConfigurationValues.convertStringToDecimal(new Double(string2));
            }
        }
        return string2;
    }

    static String convertStringToDecimal(double d) {
        FixedPointNumberFieldStrategy fixedPointNumberFieldStrategy = new FixedPointNumberFieldStrategy(2);
        return fixedPointNumberFieldStrategy.format((long)((d + 0.005) * 100.0) * 10L);
    }

    public String getBaseStationName() {
        return (String)this.values.get(BASESTATION_NAME);
    }

    public void setBaseStationName(String string) {
        this.values.put(BASESTATION_NAME, string);
    }

    public SiteTestType getSiteTestType() {
        return SiteTestTypeFactory.getInstance((String)this.values.get(SITE_TEST_TYPE));
    }

    public void setSiteTestType(SiteTestType siteTestType) {
        String[] stringArray = SiteTestTypeFactory.getInstance().getTypeList();
        if (!Arrays.contains(stringArray, siteTestType.getName())) {
            siteTestType = SiteTestTypeFactory.getInstance(stringArray[0]);
        }
        this.values.put(SITE_TEST_TYPE, siteTestType.getName());
        this.validateAll();
        this.setPilotGain(this.getRecommendedPilot());
        this.setPageGain(this.getRecommendedPage());
        this.setSyncGain(this.getRecommendedSync());
        this.setOcns(this.getRecommendedOCNS());
        this.setNumChannels(this.getRecommendedChannels());
        this.setDefaultPowerOutValues();
    }

    public void save(String string) {
        this.currentFilename = string;
        CertificationSuiteReader.instance().saveConfig(CertificationSuite.instance().getId(), string, this.toString());
    }

    String makeSettingsString() {
        String string = "";
        Enumeration enumeration = this.settings.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().toString();
            HashMap hashMap = (HashMap)this.settings.get(string2);
            Enumeration enumeration2 = hashMap.elements();
            while (enumeration2.hasMoreElements()) {
                KeyValuePair keyValuePair = (KeyValuePair)enumeration2.nextElement();
                string = string + string2 + "|" + keyValuePair.getKey() + "=" + keyValuePair.getValue() + ",";
            }
        }
        return string;
    }

    private void setDefaultPowerOutValues() {
        SiteTestType siteTestType = this.getSiteTestType();
        this.setCarrierPowerOut(siteTestType.getCarrierPowerOutInitialValue(this));
        this.setPowerOut(siteTestType.getBaseStationPowerOutInitialValue(this));
    }

    public String getCabinetConfig() {
        return (String)this.values.get(CABINET_CONFIG);
    }

    public void setCabinetConfig(String string) {
        String[] stringArray = this.getSiteTestType().getCabinetConf();
        this.values.put(CABINET_CONFIG, Arrays.contains(stringArray, string) ? string : stringArray[0]);
        this.setDefaultPowerOutValues();
    }

    public String getCarrierConfig() {
        return (String)this.values.get(CARRIER_CONFIG);
    }

    public void setCarrierConfig(String string) {
        String[] stringArray = this.getSiteTestType().getCarrierConf();
        this.values.put(CARRIER_CONFIG, Arrays.contains(stringArray, string) ? string : stringArray[0]);
        this.setDefaultPowerOutValues();
    }

    protected void validate(String string, String[] stringArray) {
        if (!(this.values.get(string) != null && Arrays.contains(stringArray, (String)this.values.get(string)) || stringArray.length <= 0)) {
            this.values.put(string, stringArray[0]);
        }
    }

    protected void validateAll() {
        this.validate(SITE_TEST_TYPE, SiteTestTypeFactory.getInstance().getTypeList());
        this.validate(CARRIER_CONFIG, this.getSiteTestType().getCarrierConf());
        this.validate(CABINET_CONFIG, this.getSiteTestType().getCabinetConf());
        this.validate(RX_CONFIG, this.getSiteTestType().getRx());
        this.validate(TX_CONFIG, this.getSiteTestType().getTx());
        this.validate(CHANNEL_STD, this.getSiteTestType().getChanStd());
        this.validate(SECTOR, this.getSiteTestType().getSectors());
    }

    public double getCValue() {
        return this.getSiteTestType().getCValue(this);
    }

    public String getRecommendedPilot() {
        return this.getSiteTestType().getRecommendedPilot();
    }

    public String getRecommendedPage() {
        return this.getSiteTestType().getRecommendedPage();
    }

    public String getRecommendedSync() {
        return this.getSiteTestType().getRecommendedSync();
    }

    public String getRecommendedOCNS() {
        return this.getSiteTestType().getRecommendedOCNS();
    }

    public String getRecommendedChannels() {
        return this.getSiteTestType().getRecommendedChannels();
    }

    public String getChannel() {
        return (String)this.values.get(CHANNEL);
    }

    public void setChannel(String string) {
        this.values.put(CHANNEL, string);
    }

    public String getChannelStd() {
        return (String)this.values.get(CHANNEL_STD);
    }

    public void setChannelStd(String string) {
        this.values.put(CHANNEL_STD, string);
    }

    public String getPnOffset() {
        return (String)this.values.get(PN_OFFSET);
    }

    public void setPnOffset(String string) {
        this.values.put(PN_OFFSET, string);
    }

    public String getSector() {
        return (String)this.values.get(SECTOR);
    }

    public void setSector(String string) {
        this.values.put(SECTOR, string);
    }

    public String getPowerOut() {
        return (String)this.values.get(POWER_OUT);
    }

    public void setPowerOut(String string) {
        this.values.put(POWER_OUT, string);
    }

    public String getCarrierPowerOut() {
        return (String)this.values.get(CARRIER_POWER_OUT);
    }

    public void setCarrierPowerOut(String string) {
        this.values.put(CARRIER_POWER_OUT, string);
    }

    public String getRfInLoss() {
        return (String)this.values.get(RF_IN_LOSS);
    }

    public void setRfInLoss(String string, boolean bl) {
        this.values.put(RF_IN_LOSS, this.formatNumericValue(RF_IN_LOSS, string));
        String string2 = this.getValue(RF_IN_LOSS);
        long l = (long)(Double.valueOf(string2) * 1000.0);
        if (bl) {
            SpectrumMeasurementSettings.instance().getRfInLoss().send(l);
            DisplayGlobalMeasurementSettings.instance().getStashingInLoss().send(l);
        }
        this.setRfOutLoss(string, bl);
        this.setPowerMeterLoss(string, bl);
    }

    public String getRfOutLoss() {
        return (String)this.values.get(RF_OUT_LOSS);
    }

    public void setRfOutLoss(String string, boolean bl) {
        this.values.put(RF_OUT_LOSS, this.formatNumericValue(RF_OUT_LOSS, string));
        String string2 = this.getValue(RF_OUT_LOSS);
        long l = (long)(Double.valueOf(string2) * 1000.0);
        if (bl) {
            SigGenMeasurementSettings.instance().getRfOutLoss().send(l);
            SigGenMeasurementSettings.instance().getStashedLoss().send(l);
        }
    }

    public String getPowerMeterLoss() {
        return (String)this.values.get(POWER_METRIC_LOSS);
    }

    public void setPowerMeterLoss(String string, boolean bl) {
        this.values.put(POWER_METRIC_LOSS, this.formatNumericValue(POWER_METRIC_LOSS, string));
        String string2 = this.getValue(POWER_METRIC_LOSS);
        long l = (long)(Double.valueOf(string2) * 1000.0);
        if (bl) {
            PowerMeterMeasurementSettings.instance().getPwrOffset().send(l);
            PowerMeterMeasurementSettings.instance().getStashedLoss().send(l);
        }
    }

    public String getRxConfig() {
        return (String)this.values.get(RX_CONFIG);
    }

    public void setRxConfig(String string) {
        this.values.put(RX_CONFIG, string);
    }

    public String getTxConfig() {
        return (String)this.values.get(TX_CONFIG);
    }

    public void setTxConfig(String string) {
        this.values.put(TX_CONFIG, string);
    }

    public boolean getTxSplitter() {
        return this.values.get(TX_SPLITTER).equals("Yes");
    }

    public void setTxSplitter(boolean bl) {
        this.values.put(TX_SPLITTER, bl ? "Yes" : "No");
    }

    public boolean getShowDiagrams() {
        return this.values.get(SHOW_DIAGRAMS).equals("Yes");
    }

    public void setShowDiagrams(boolean bl) {
        this.values.put(SHOW_DIAGRAMS, bl ? "Yes" : "No");
    }

    public String getPilotGain() {
        return (String)this.values.get(PILOT_GAIN);
    }

    public void setPilotGain(String string) {
        this.values.put(PILOT_GAIN, string);
    }

    public String getSyncGain() {
        return (String)this.values.get(SYNC_GAIN);
    }

    public void setSyncGain(String string) {
        this.values.put(SYNC_GAIN, string);
    }

    public String getPageGain() {
        return (String)this.values.get(PAGE_GAIN);
    }

    public void setPageGain(String string) {
        this.values.put(PAGE_GAIN, string);
    }

    public String getOcns() {
        return (String)this.values.get(OCNS);
    }

    public void setOcns(String string) {
        this.values.put(OCNS, string);
    }

    public String getFreqTimeRef() {
        return (String)this.values.get(FREQ_TIME_REF);
    }

    public void setFreqTimeRef(String string) {
        this.values.put(FREQ_TIME_REF, string);
    }

    public String getPowerMeterAmplitude() {
        return (String)this.values.get(POWER_METER_AMP);
    }

    public long getPowerMeterAmplitudeLongValue() {
        return (long)(Double.valueOf(this.getPowerMeterAmplitude()) * 1000.0);
    }

    public void setPowerMeterAmplitude(String string) {
        this.values.put(POWER_METER_AMP, string);
    }

    public String getNumChannels() {
        return (String)this.values.get(NUM_CHANNELS);
    }

    public void setNumChannels(String string) {
        this.values.put(NUM_CHANNELS, string);
    }

    public boolean isLegalConfigFile(String string) {
        return string.equals(this.values.get("SCRIPT_KEY"));
    }

    public static void clearInstance() {
        instance = null;
    }

    public int cabinetIndex() {
        return Arrays.indexof(this.getSiteTestType().getCabinetConf(), (String)this.values.get(CABINET_CONFIG));
    }

    public int carrierIndex() {
        return Arrays.indexof(this.getSiteTestType().getCarrierConf(), (String)this.values.get(CARRIER_CONFIG));
    }

    public boolean isNumeric(String string) {
        String[] stringArray = new String[]{CHANNEL, PN_OFFSET, POWER_OUT, CARRIER_POWER_OUT, RF_IN_LOSS, RF_OUT_LOSS, POWER_METRIC_LOSS, PILOT_GAIN, SYNC_GAIN, PAGE_GAIN, NUM_CHANNELS, POWER_METER_AMP, RX_RECEIVE_POWER_UPPER_LIMIT, RX_RECEIVE_POWER_LOWER_LIMIT, RX_RECEIVE_FER_LOWER_LIMIT, RX_RECEIVE_FER_UPPER_LIMIT, POWER_METER_CAL_FACTOR, POWER_METER_REF_CAL_FACTOR};
        return Arrays.contains(stringArray, string);
    }

    public boolean isDecimal(String string) {
        String[] stringArray = new String[]{POWER_OUT, CARRIER_POWER_OUT, RF_IN_LOSS, RF_OUT_LOSS, POWER_METRIC_LOSS, PILOT_GAIN, SYNC_GAIN, PAGE_GAIN, POWER_METER_AMP, RX_RECEIVE_POWER_UPPER_LIMIT, RX_RECEIVE_POWER_LOWER_LIMIT, RX_RECEIVE_FER_LOWER_LIMIT, RX_RECEIVE_FER_UPPER_LIMIT, POWER_METER_CAL_FACTOR, POWER_METER_REF_CAL_FACTOR};
        return Arrays.contains(stringArray, string);
    }

    public static void setInstance(SiteConfigurationValues siteConfigurationValues) {
        instance = siteConfigurationValues;
    }

    public int getChannelStdIndex() {
        if (this.getChannelStd().equals("North American Cellular")) {
            return 0;
        }
        if (this.getChannelStd().equals("North American PCS")) {
            return 1;
        }
        if (this.getChannelStd().equals("Korean PCS Band")) {
            return 3;
        }
        if (this.getChannelStd().equals("NMT-450")) {
            return 16;
        }
        return -1;
    }

    public long getChannelStdStartFreq() {
        if (this.getChannelStd().equals("North American Cellular")) {
            return 824000L;
        }
        if (this.getChannelStd().equals("North American PCS")) {
            return 1850000L;
        }
        if (this.getChannelStd().equals("Korean PCS Band")) {
            return 1750000L;
        }
        if (this.getChannelStd().equals("NMT-450")) {
            return 450000L;
        }
        return 0L;
    }

    public long getChannelStdStopFreq() {
        if (this.getChannelStd().equals("North American Cellular")) {
            return 895000L;
        }
        if (this.getChannelStd().equals("North American PCS")) {
            return 2000000L;
        }
        if (this.getChannelStd().equals("Korean PCS Band")) {
            return 1900000L;
        }
        if (this.getChannelStd().equals("NMT-450")) {
            return 500000L;
        }
        return 0L;
    }

    public long getReverseFrequency() {
        DisplayGlobalMeasurementSettings.instance().getChanStd().setValue(this.getChannelStdIndex());
        ChannelFrequencyConversion channelFrequencyConversion = ChannelFrequencyConversion.createReverse(BandSelector.getGlobalBandSelector());
        return channelFrequencyConversion.longValue(this.getChannel());
    }

    public long getForwardFrequency() {
        DisplayGlobalMeasurementSettings.instance().getChanStd().setValue(this.getChannelStdIndex());
        ChannelFrequencyConversion channelFrequencyConversion = ChannelFrequencyConversion.createForward(BandSelector.getGlobalBandSelector());
        return channelFrequencyConversion.longValue(this.getChannel());
    }

    HashMap getSettings(String string) {
        HashMap hashMap = (HashMap)this.settings.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.settings.put(string, hashMap);
        }
        return hashMap;
    }

    void setSettings(String string, HashMap hashMap) {
        this.settings.put(string, hashMap);
    }

    public void captureSettingsValue(String string, String string2) {
        int n = string.indexOf("|");
        if (n > -1) {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1);
            this.getSettings(string3).put(string4, string2);
        } else {
            this.values.put(string, string2);
        }
    }

    public int settingsSize() {
        return this.settings.size();
    }

    private String replaceAllCommasWithReturns(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken().trim() + '\n');
        }
        return stringBuffer.toString();
    }

    public boolean read(String string) throws IOException {
        this.currentFilename = string;
        String string2 = CertificationSuiteReader.instance().readConfig(CertificationSuite.instance().getId(), string);
        if (string2.indexOf("SCRIPT_KEY=" + CertificationSuite.instance().getId()) > -1) {
            this.fromString(string2);
            return true;
        }
        return false;
    }

    public void readDefaultConfig(SoftwareFileSystem softwareFileSystem, String string) throws IOException {
        this.currentFilename = DEFAULT_FILENAME;
        this.fromString(softwareFileSystem.getDefaultConfig(string));
    }

    public String getCurrentFilename() {
        return this.currentFilename;
    }

    void setCurrentFilename(String string) {
        this.currentFilename = string;
    }

    public String toString() {
        String string = this.values.toString();
        string = string.substring(1, string.length() - 1);
        string = string + "," + this.makeSettingsString();
        string = this.replaceAllCommasWithReturns(string);
        return string;
    }

    public void fromString(String string) throws IOException {
        this.values = new Hashtable();
        this.settings = new Hashtable();
        this.parseResult(string);
        this.validateAll();
    }

    private void parseResult(String string) throws IOException {
        boolean bl;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=\n");
        boolean bl2 = bl = stringTokenizer.countTokens() % 2 == 0 && stringTokenizer.countTokens() > 0;
        if (bl) {
            while (stringTokenizer.hasMoreTokens()) {
                this.captureSettingsValue(stringTokenizer.nextToken().trim(), stringTokenizer.nextToken().trim());
            }
        } else {
            throw new IOException("Error parsing configuration file");
        }
    }

    public void delete(String string) {
        StorageDevice storageDevice = FileSystemHelper.getInstance().createStorageDevice(SystemMeasurementSettings.instance().getDataDeviceType());
        FileSystemHelper.getInstance().removeFile(storageDevice, this.valueDirectory + string);
    }

    public String getValue(String string) {
        return (String)this.values.get(string);
    }

    public String[] getConfigurationFileList() {
        return CertificationSuiteReader.instance().getConfigList(CertificationSuite.instance().getId());
    }

    public void deleteConfigFile(String string) {
        CertificationSuiteReader.instance().deleteFile(CertificationSuite.instance().getId(), string);
    }

    public long getRefCalFactor() {
        return (long)((new Double((String)this.values.get(POWER_METER_REF_CAL_FACTOR)) + 5.0E-4) * 1000.0);
    }

    public void setRefCalFactor(String string) {
        this.values.put(POWER_METER_REF_CAL_FACTOR, string);
    }

    public long getPmCalFactor() {
        return (long)((new Double((String)this.values.get("PmCalFactor." + this.getChannelStd())) + 5.0E-4) * 1000.0);
    }

    public void setPmCalFactor(String string, String string2) {
        this.values.put("PmCalFactor." + string, string2);
    }

    public String getPackageId() {
        return (String)this.values.get("SCRIPT_KEY");
    }

    public double getPowerDifference() {
        double d;
        SiteTestType siteTestType = this.getSiteTestType();
        String string = siteTestType.getBaseStationPowerOutInitialValue(this);
        String string2 = siteTestType.getCarrierPowerOutInitialValue(this);
        if ("N/A".equals(string2)) {
            d = 0.0;
        } else {
            d = Math.abs(Double.valueOf(string) - Double.valueOf(string2));
            d = (double)Math.round(d * 10000.0) / 10000.0;
        }
        return d;
    }
}

