/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.scriptedTests.CarrierCabinetKey;
import elgato.infrastructure.scriptedTests.PowerOutValues;
import elgato.infrastructure.scriptedTests.RxLimits;
import elgato.infrastructure.scriptedTests.SiteConfigurationValues;
import java.util.Hashtable;

public class SiteTestType {
    static final int BASE_STATION_LIMIT = 0;
    static final int BASE_STATION_LPP = 1;
    static final int BASE_STATION_IMF = 2;
    static final int BASE_STATION_COMBINER = 3;
    private static SiteTestType instance;
    private String name;
    private String[] sectors;
    private String[] rx;
    private String[] tx;
    private String[] chanStd;
    private String[] cabinetConf;
    private String[] carrierConf;
    private String[][] connectionDeviceNames;
    private String[][][] troubleshootConnectionDeviceNames;
    private String recommendedOCNS;
    private Hashtable powerOut;
    private RxLimits[] rxValues;
    private RxLimits[] powerValues;
    static final String FRM_1900 = "Nortel Metro Cell SFRM 1900 MHz";

    public SiteTestType(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, Hashtable hashtable, String[][] stringArray7, String[][][] stringArray8, RxLimits[] rxLimitsArray, RxLimits[] rxLimitsArray2, String string2) {
        this.name = string;
        this.sectors = stringArray;
        this.rx = stringArray2;
        this.tx = stringArray3;
        this.chanStd = stringArray4;
        this.cabinetConf = stringArray5;
        this.carrierConf = stringArray6;
        this.powerOut = hashtable;
        this.connectionDeviceNames = stringArray7;
        this.troubleshootConnectionDeviceNames = stringArray8;
        this.rxValues = rxLimitsArray;
        this.powerValues = rxLimitsArray2;
        this.recommendedOCNS = string2;
    }

    public String getBaseStationPowerOutInitialValue(SiteConfigurationValues siteConfigurationValues) {
        CarrierCabinetKey carrierCabinetKey = new CarrierCabinetKey(siteConfigurationValues.getCarrierConfig(), siteConfigurationValues.getCabinetConfig());
        PowerOutValues powerOutValues = (PowerOutValues)this.powerOut.get(carrierCabinetKey);
        return powerOutValues.getBaseStation();
    }

    public String getCarrierPowerOutInitialValue(SiteConfigurationValues siteConfigurationValues) {
        CarrierCabinetKey carrierCabinetKey = new CarrierCabinetKey(siteConfigurationValues.getCarrierConfig(), siteConfigurationValues.getCabinetConfig());
        PowerOutValues powerOutValues = (PowerOutValues)this.powerOut.get(carrierCabinetKey);
        return powerOutValues.getCarrier();
    }

    public double getCValue(SiteConfigurationValues siteConfigurationValues) {
        CarrierCabinetKey carrierCabinetKey = new CarrierCabinetKey(siteConfigurationValues.getCarrierConfig(), siteConfigurationValues.getCabinetConfig());
        PowerOutValues powerOutValues = (PowerOutValues)this.powerOut.get(carrierCabinetKey);
        return powerOutValues.getcValue();
    }

    public String getConnectionDeviceName(SiteConfigurationValues siteConfigurationValues) {
        int n = siteConfigurationValues.carrierIndex();
        int n2 = siteConfigurationValues.cabinetIndex();
        return this.connectionDeviceNames[n2][n];
    }

    public String getTroubleshootingConnectionDeviceName(SiteConfigurationValues siteConfigurationValues, boolean bl) {
        int n = siteConfigurationValues.carrierIndex();
        int n2 = siteConfigurationValues.cabinetIndex();
        int n3 = bl ? 0 : 2;
        return "DUT Out - " + this.troubleshootConnectionDeviceNames[n3][n2][n] + "   DUT In - " + this.troubleshootConnectionDeviceNames[n3 + 1][n2][n];
    }

    public String getName() {
        return this.name;
    }

    public String[] getSectors() {
        return this.sectors;
    }

    public String[] getRx() {
        return this.rx;
    }

    public String[] getTx() {
        return this.tx;
    }

    public String[] getChanStd() {
        return this.chanStd;
    }

    public String[] getCabinetConf() {
        return this.cabinetConf;
    }

    public String[] getCarrierConf() {
        return this.carrierConf;
    }

    public static void setInstance(SiteTestType siteTestType) {
        instance = siteTestType;
    }

    public static SiteTestType getInstance() {
        return instance;
    }

    public String getRecommendedPilot() {
        return "254";
    }

    public String getRecommendedPage() {
        return "245";
    }

    public String getRecommendedSync() {
        return "123";
    }

    public String getRecommendedOCNS() {
        return this.recommendedOCNS;
    }

    public String getRecommendedChannels() {
        return "6";
    }

    public String getRxConfigFromCarrier() {
        String string = SiteConfigurationValues.instance().getCarrierConfig();
        if (string.startsWith("1 Carr")) {
            return "1 Carr";
        }
        if (string.indexOf("1st") > 0 || string.indexOf("2nd") > 0) {
            return "2,3,4 Carr";
        }
        return "3,4 Carr";
    }

    public String getRxUpperLimit(int n) {
        SiteConfigurationValues siteConfigurationValues = SiteConfigurationValues.instance();
        String string = siteConfigurationValues.getRxConfig();
        if (this.name.equals(FRM_1900)) {
            string = this.getRxConfigFromCarrier();
        }
        return this.rxValues[n].getUpperLimit(siteConfigurationValues.getCabinetConfig(), string);
    }

    public String getrxLowerLimit(int n) {
        SiteConfigurationValues siteConfigurationValues = SiteConfigurationValues.instance();
        String string = siteConfigurationValues.getRxConfig();
        if (this.name.equals(FRM_1900)) {
            string = this.getRxConfigFromCarrier();
        }
        return this.rxValues[n].getLowerLimit(siteConfigurationValues.getCabinetConfig(), string);
    }

    public String getPowerUpperLimitDefault(boolean bl) {
        SiteConfigurationValues siteConfigurationValues = SiteConfigurationValues.instance();
        long l = (long)Double.valueOf(this.powerValues[0].getUpperLimit(siteConfigurationValues.getCabinetConfig(), "")).doubleValue();
        long l2 = (long)Double.valueOf(this.powerValues[1].getUpperLimit(siteConfigurationValues.getCabinetConfig(), "")).doubleValue();
        long l3 = (long)Double.valueOf(this.powerValues[2].getUpperLimit(siteConfigurationValues.getCabinetConfig(), "")).doubleValue();
        long l4 = (long)Double.valueOf(this.powerValues[3].getUpperLimit(siteConfigurationValues.getCabinetConfig(), "")).doubleValue();
        return this.computerPowerOut(l3, l4, l, l2, bl);
    }

    public String getPowerLowerLimitDefault(boolean bl) {
        SiteConfigurationValues siteConfigurationValues = SiteConfigurationValues.instance();
        long l = (long)Double.valueOf(this.powerValues[0].getLowerLimit(siteConfigurationValues.getCabinetConfig(), "")).doubleValue();
        long l2 = (long)Double.valueOf(this.powerValues[1].getLowerLimit(siteConfigurationValues.getCabinetConfig(), "")).doubleValue();
        long l3 = (long)Double.valueOf(this.powerValues[2].getLowerLimit(siteConfigurationValues.getCabinetConfig(), "")).doubleValue();
        long l4 = (long)Double.valueOf(this.powerValues[3].getLowerLimit(siteConfigurationValues.getCabinetConfig(), "")).doubleValue();
        return this.computerPowerOut(l3, l4, l, l2, bl);
    }

    private String computerPowerOut(long l, long l2, long l3, long l4, boolean bl) {
        SiteConfigurationValues siteConfigurationValues = SiteConfigurationValues.instance();
        String string = siteConfigurationValues.getTxConfig();
        if (string.startsWith("No IMF")) {
            l = 0L;
            l2 = 0L;
        } else if (string.equals("IMF")) {
            l2 = 0L;
        } else if (string.equals("Combiner")) {
            l = 0L;
        }
        String string2 = siteConfigurationValues.getCarrierPowerOut();
        if ("N/A".equals(string2) || bl) {
            return String.valueOf((long)(new Double(siteConfigurationValues.getPowerOut()) * 1000.0 + (double)l3 + (double)l4 + (double)l + (double)l2));
        }
        return String.valueOf((long)(new Double(string2) * 1000.0 + (double)l3 + (double)l4 + (double)l + (double)l2));
    }
}

