/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.mainScreens.GenericMessageScreen;
import elgato.infrastructure.mainScreens.MessageScreen;
import elgato.infrastructure.mainScreens.MessageScreenListener;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.menu.SimpleMenuButton;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.scriptedTests.CertificationSuite;
import elgato.infrastructure.scriptedTests.ConfigurationScreen;
import elgato.infrastructure.scriptedTests.SiteConfigurationValues;
import elgato.infrastructure.scriptedTests.SoftwareFileSystem;
import elgato.infrastructure.scriptedTests.SoftwareHomeScreen;
import elgato.infrastructure.util.Arrays;
import elgato.infrastructure.util.FileSystemHelper;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.StorageDevice;
import elgato.infrastructure.util.SystemProcess;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.TextMessage;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Vector;

public class SoftwareButtonFactory {
    static String lastTestAccessed = "";

    public static void resetLastTestAccessed() {
        lastTestAccessed = "";
    }

    public static SimpleMenuButton makeSoftwareButton(ScreenManager screenManager) {
        MenuItem[] menuItemArray = SoftwareButtonFactory.getLicensedSoftwareButtons(screenManager);
        SimpleMenuButton simpleMenuButton = new SimpleMenuButton(Text.Test_Software, "testsoftware", new Menu(Text.Test_Software, menuItemArray));
        return simpleMenuButton;
    }

    private static MenuItem[] getLicensedSoftwareButtons(ScreenManager screenManager) {
        String[] stringArray = SoftwareButtonFactory.getInstalledPackageList();
        MenuItem[] menuItemArray = new MenuItem[stringArray.length + 1];
        menuItemArray[0] = SoftwareButtonFactory.makeSoftwareUtilityButton(screenManager);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            menuItemArray[i + 1] = SoftwareButtonFactory.createSoftwarePackageButton(screenManager, SoftwareButtonFactory.extractButtonTitle(string), string);
        }
        return menuItemArray;
    }

    private static String extractButtonTitle(String string) {
        String string2 = SoftwareButtonFactory.findPackageTitle(string);
        if (string2 == null) {
            string2 = "Software\nOption\n # " + string;
        }
        return string2;
    }

    private static String findPackageTitle(String string) {
        int n = Logger.getGlobalLevel();
        Logger.setGlobalLevel(1);
        String string2 = Text.get("script" + string);
        Logger.setGlobalLevel(n);
        if (string2.equals("***--script" + string + "--***")) {
            string2 = null;
        }
        return string2;
    }

    private static String[] getInstalledPackageList() {
        Vector<String> vector = new Vector<String>();
        for (int i = 330; i <= 380; ++i) {
            String string = String.valueOf(i);
            if (!MeasurementFactory.instance().testScriptsAvailable("script" + string)) continue;
            vector.addElement(string);
        }
        return Arrays.toArray(vector);
    }

    protected static PushButton createSoftwarePackageButton(ScreenManager screenManager, String string, String string2) {
        PushButton pushButton = new PushButton(string, "software" + string2, new SoftwareButtonListener(screenManager, string2));
        pushButton.setEnabled(MeasurementFactory.instance().testScriptsAvailable("script" + string2));
        return pushButton;
    }

    static Screen createConfigScreen(ScreenManager screenManager, String string) {
        return ConfigurationScreen.buildConfigurationMenuListScreen(screenManager, string);
    }

    static MenuItem makeSoftwareUtilityButton(ScreenManager screenManager) {
        return new SubMenuButton(Text.Software_n_Utils, "software.utilities", new Menu(Text.Software_Utils, new MenuItem[]{SoftwareButtonFactory.makeSoftwareInstallMenu(screenManager), null, SoftwareButtonFactory.makeConfigImportMenu(screenManager), SoftwareButtonFactory.makeConfigExportMenu(screenManager), null, null}));
    }

    private static MenuItem makeConfigExportMenu(ScreenManager screenManager) {
        return new SubMenuButton(Text.get("export.software.config.files"), "export.config.files", new Menu(Text.get("export.files"), new MenuItem[]{null, SoftwareButtonFactory.makeSoftwareConfigExportButton(Text.get("to.pcmcia"), 0, screenManager), SoftwareButtonFactory.makeSoftwareConfigExportButton(Text.get("to.cf"), 1, screenManager)}));
    }

    private static MenuItem makeConfigImportMenu(ScreenManager screenManager) {
        return new SubMenuButton(Text.get("import.software.config.files"), "import.config.files", new Menu(Text.get("import.files"), new MenuItem[]{null, SoftwareButtonFactory.makeSoftwareConfigImportButton(Text.get("from.pcmcia"), 0, screenManager), SoftwareButtonFactory.makeSoftwareConfigImportButton(Text.get("from.cf"), 1, screenManager)}));
    }

    private static MenuItem makeSoftwareInstallMenu(ScreenManager screenManager) {
        return new SubMenuButton(Text.get("install.test.software"), "software.install", new Menu(Text.get("install.software"), new MenuItem[]{null, SoftwareButtonFactory.makeInstallSoftwareButton(Text.get("from.pcmcia"), 0, screenManager), SoftwareButtonFactory.makeInstallSoftwareButton(Text.get("from.cf"), 1, screenManager)}));
    }

    private static PushButton makeInstallSoftwareButton(String string, int n, ScreenManager screenManager) {
        return SoftwareButtonFactory.makeFileCopyButton(screenManager, string, TextMessage.get("install.software.message"), new SoftwareInstaller(n, screenManager));
    }

    private static PushButton makeSoftwareConfigImportButton(String string, int n, ScreenManager screenManager) {
        return SoftwareButtonFactory.makeFileCopyButton(screenManager, string, TextMessage.get("import.software.config.message"), new SoftwareConfigImporter(n, screenManager));
    }

    private static PushButton makeSoftwareConfigExportButton(String string, int n, ScreenManager screenManager) {
        return SoftwareButtonFactory.makeFileCopyButton(screenManager, string, TextMessage.get("export.software.config.message"), new SoftwareConfigExporter(n, screenManager));
    }

    private static PushButton makeFileCopyButton(final ScreenManager screenManager, String string, final String string2, final SoftwareFileCopier softwareFileCopier) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageScreen messageScreen = new MessageScreen(string2, true, 1);
                messageScreen.addListener(softwareFileCopier);
                screenManager.pushScreen(messageScreen);
            }
        };
        return new PushButton(string, "", actionListener);
    }

    public static MenuItem makeImportExportStateButton(ScreenManager screenManager) {
        return new SubMenuButton(Text.State, "state.import.export", new Menu(Text.State, new MenuItem[]{null, SoftwareButtonFactory.makeStateImportMenu(screenManager), SoftwareButtonFactory.makeStateExportMenu(screenManager), null, null, null}));
    }

    private static MenuItem makeStateExportButton(String string, int n, ScreenManager screenManager) {
        return SoftwareButtonFactory.makeFileCopyButton(screenManager, string, TextMessage.get("export.state.message"), new StateExporter(n, screenManager));
    }

    private static MenuItem makeStateImportButton(String string, int n, ScreenManager screenManager) {
        return SoftwareButtonFactory.makeFileCopyButton(screenManager, string, TextMessage.get("import.state.message"), new StateImporter(n, screenManager));
    }

    private static MenuItem makeStateImportMenu(ScreenManager screenManager) {
        return new SubMenuButton("Import\nState\nFiles", "state.import", new Menu("State Import", new MenuItem[]{null, SoftwareButtonFactory.makeStateImportButton(Text.get("from.pcmcia"), 0, screenManager), SoftwareButtonFactory.makeStateImportButton(Text.get("from.cf"), 1, screenManager)}));
    }

    private static MenuItem makeStateExportMenu(ScreenManager screenManager) {
        return new SubMenuButton("Export\nState\nFiles", "state.export", new Menu("State Export", new MenuItem[]{null, SoftwareButtonFactory.makeStateExportButton(Text.get("to.pcmcia"), 0, screenManager), SoftwareButtonFactory.makeStateExportButton(Text.get("to.cf"), 1, screenManager)}));
    }

    private static class StateExporter
    extends SoftwareFileCopier {
        public StateExporter(int n, ScreenManager screenManager) {
            super(n, screenManager, "Exporting State Files");
        }

        protected void setValues() {
            this.sourceDirectory = "/flash/egServer/registry";
            this.targetDirectory = "/flash/mnt/" + this.devName();
            this.failureMessageKey = "media.data.state.export.failure";
        }
    }

    private static class StateImporter
    extends SoftwareFileCopier {
        public StateImporter(int n, ScreenManager screenManager) {
            super(n, screenManager, "Importing State Files");
        }

        protected void setValues() {
            this.sourceDirectory = "/flash/mnt/" + this.devName() + "/registry";
            this.targetDirectory = "/flash/egServer";
            this.failureMessageKey = "media.data.state.import.failure";
        }
    }

    private static abstract class SoftwareFileCopier
    implements MessageScreenListener {
        protected int deviceMagicNumber;
        protected String sourceDirectory;
        protected String targetDirectory;
        protected String failureMessageKey;
        private ScreenManager sm;
        private String action;

        public SoftwareFileCopier(int n, ScreenManager screenManager, String string) {
            this.deviceMagicNumber = n;
            this.sm = screenManager;
            this.setValues();
            this.action = string;
        }

        protected abstract void setValues();

        protected String devName() {
            return this.deviceMagicNumber == 0 ? "pcmcia" : "cf";
        }

        public void messageScreenExit(int n) {
            if (n == 0) {
                this.sm.pushScreen(new MessageScreen(this.action + "...\n\nPlease be patient -- this may take several minutes.", false, 4));
                this.sm.repaintImmediately();
                StorageDevice storageDevice = FileSystemHelper.getInstance().createStorageDevice(this.deviceMagicNumber);
                try {
                    if (storageDevice != null && storageDevice.mount()) {
                        String[] stringArray = FileSystemHelper.getInstance().getFileList(this.targetDirectory);
                        if (stringArray == null) {
                            FileSystemHelper.getInstance().mkdir(this.targetDirectory);
                        }
                        SystemProcess systemProcess = FileSystemHelper.getInstance().copyDirectory(this.sourceDirectory, this.targetDirectory);
                        storageDevice.unmount();
                        this.sm.popScreen();
                        if (systemProcess.getExitCode() != 0) {
                            this.sm.pushScreen(new MessageScreen(TextMessage.get(this.failureMessageKey), false, 0));
                        }
                    } else {
                        this.sm.popScreen();
                        this.sm.pushScreen(new MessageScreen(TextMessage.get(this.failureMessageKey), false, 0));
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    private static class SoftwareConfigExporter
    extends SoftwareFileCopier {
        public SoftwareConfigExporter(int n, ScreenManager screenManager) {
            super(n, screenManager, "Exporting Software Configuration Files");
        }

        protected void setValues() {
            this.sourceDirectory = "/flash/software/sw330/config";
            this.targetDirectory = "/flash/mnt/" + this.devName();
            this.failureMessageKey = "media.data.config.export.failure";
        }
    }

    private static class SoftwareConfigImporter
    extends SoftwareFileCopier {
        public SoftwareConfigImporter(int n, ScreenManager screenManager) {
            super(n, screenManager, "Importing Software Configuration Files");
        }

        protected void setValues() {
            this.sourceDirectory = "/flash/mnt/" + this.devName() + "/config";
            this.targetDirectory = "/flash/software/sw330";
            this.failureMessageKey = "media.data.config.import.failure";
        }
    }

    private static class SoftwareInstaller
    extends SoftwareFileCopier {
        public SoftwareInstaller(int n, ScreenManager screenManager) {
            super(n, screenManager, "Installing Software");
        }

        protected void setValues() {
            this.sourceDirectory = "/flash/mnt/" + this.devName() + "/software/sw330";
            this.targetDirectory = "/flash/software/";
            this.failureMessageKey = "media.data.install.failure";
        }

        public void messageScreenExit(int n) {
            super.messageScreenExit(n);
            SoftwareButtonFactory.resetLastTestAccessed();
        }
    }

    protected static final class SoftwareButtonListener
    implements ActionListener {
        private final ScreenManager sm;
        private final String packageId;

        SoftwareButtonListener(ScreenManager screenManager, String string) {
            this.sm = screenManager;
            this.packageId = string;
        }

        public void actionPerformed() {
            block10: {
                this.sm.pushScreen(new MessageScreen("Loading Software...", false, 4));
                this.sm.repaintImmediately();
                SoftwareFileSystem softwareFileSystem = SoftwareFileSystem.getRegisteredFileSystem(this.packageId);
                if (softwareFileSystem != null) {
                    SiteConfigurationValues siteConfigurationValues = SiteConfigurationValues.instance();
                    boolean bl = true;
                    try {
                        if (!lastTestAccessed.equals(softwareFileSystem.getName() + this.packageId)) {
                            CertificationSuite.instance().goStuffYourself(softwareFileSystem, this.packageId);
                            siteConfigurationValues.readDefaultConfig(softwareFileSystem, this.packageId);
                            if (CertificationSuite.instance().getId().equals(this.packageId)) {
                                if (CertificationSuite.instance().hasRequiredOptions()) {
                                    lastTestAccessed = softwareFileSystem.getName() + this.packageId;
                                } else {
                                    bl = false;
                                    this.sm.popScreen();
                                    this.sm.pushScreen(new GenericMessageScreen(TextMessage.MEDIA_DATA_MISSING_OPTION_FAILURE, true, 0));
                                }
                            } else {
                                bl = false;
                                this.sm.popScreen();
                                this.sm.pushScreen(new GenericMessageScreen(TextMessage.MEDIA_DATA_INVALID_SCRIPT_FAILURE, true, 0));
                            }
                        }
                        if (!bl) break block10;
                        if (siteConfigurationValues.isLegalConfigFile(this.packageId)) {
                            SoftwareButtonFactory.createConfigScreen(this.sm, this.getClass().getName() + ".actionPerformed");
                            this.sm.popScreen();
                            this.sm.pushScreen(new SoftwareHomeScreen());
                            break block10;
                        }
                        this.sm.popScreen();
                        this.sm.pushScreen(new GenericMessageScreen(TextMessage.MEDIA_DATA_INVALID_CONFIG_FAILURE, true, 0));
                    }
                    catch (IOException iOException) {
                        this.sm.popScreen();
                        this.sm.pushScreen(new GenericMessageScreen(TextMessage.MEDIA_DATA_READ_FAILURE, true, 0));
                    }
                } else {
                    this.sm.popScreen();
                    this.sm.pushScreen(new GenericMessageScreen(TextMessage.MEDIA_DATA_SOFTWARE_NOT_FOUND_FAILURE, true, 0));
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.actionPerformed();
        }
    }
}

