/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.widgets.ImageIcon;
import java.util.Vector;

public abstract class SoftwareFileSystem {
    protected String baseDirectory;
    private String name;
    private static Vector availableSoftwareFileSystems = new Vector(2);

    public SoftwareFileSystem(String string, String string2) {
        this.baseDirectory = this.adjustBaseDirectory(string2);
        this.name = string;
    }

    public static Vector getSoftwareFileSystemList() {
        return availableSoftwareFileSystems;
    }

    public static void registerFileSystem(SoftwareFileSystem softwareFileSystem) {
        availableSoftwareFileSystems.addElement(softwareFileSystem);
    }

    public static SoftwareFileSystem getRegisteredFileSystem(String string) {
        for (int i = 0; i < availableSoftwareFileSystems.size(); ++i) {
            SoftwareFileSystem softwareFileSystem = (SoftwareFileSystem)availableSoftwareFileSystems.elementAt(i);
            if (!softwareFileSystem.hasPackage(string)) continue;
            return softwareFileSystem;
        }
        return null;
    }

    static void clearFileSystemVector() {
        availableSoftwareFileSystems = new Vector(2);
    }

    String getScriptFileName(String string) {
        return this.computeFilePath(string) + "suitetest";
    }

    String getDefaultConfigFileName(String string) {
        return this.computeFilePath(string) + "defaultconfig";
    }

    String getConfigFileName(String string, String string2) {
        return this.configFileDirectoryName(string) + string2;
    }

    protected final String configFileDirectoryName(String string) {
        return this.computeFilePath(string) + this.makeSubdirectory("config");
    }

    String getImageFileName(String string, String string2) {
        return this.computeFilePath(string) + this.makeSubdirectory("images") + string2;
    }

    String getTextFileName(String string, String string2) {
        return this.computeFilePath(string) + this.makeSubdirectory("text") + string2;
    }

    public String getName() {
        return this.name;
    }

    protected void grabResource() {
    }

    protected void freeResource() {
    }

    public ImageIcon getImageIcon(String string, String string2) {
        return this.readImageIconFile(this.getImageFileName(string, string2));
    }

    public String getScript(String string) {
        return this.decryptScript(this.readTextFile(this.getScriptFileName(string)));
    }

    public String getDefaultConfig(String string) {
        return this.decryptConfigFile(this.readTextFile(this.getDefaultConfigFileName(string)));
    }

    public String getConfig(String string, String string2) {
        return this.decryptConfigFile(this.readTextFile(this.getConfigFileName(string, string2)));
    }

    public void saveConfig(String string, String string2, String string3) {
        this.grabResource();
        this.validateConfigDirectory(string);
        this.saveTextContent(this.getConfigFileName(string, string2), this.encryptConfigFile(string3));
        this.freeResource();
    }

    protected void validateConfigDirectory(String string) {
    }

    public void deleteConfigFile(String string, String string2) {
        this.grabResource();
        this.removeFile(this.getConfigFileName(string, string2));
        this.freeResource();
    }

    protected String encryptConfigFile(String string) {
        return string;
    }

    public String getText(String string, String string2) {
        return this.readTextFile(this.getTextFileName(string, string2));
    }

    String readTextFile(String string) {
        this.grabResource();
        String string2 = this.getTextContent(string);
        this.freeResource();
        return string2;
    }

    ImageIcon readImageIconFile(String string) {
        this.grabResource();
        ImageIcon imageIcon = this.getImageContent(string);
        this.freeResource();
        return imageIcon;
    }

    protected String decryptScript(String string) {
        return string;
    }

    protected String decryptConfigFile(String string) {
        return string;
    }

    public String[] getConfigList(String string) {
        this.grabResource();
        String[] stringArray = this.directoryListing(this.configFileDirectoryName(string));
        this.freeResource();
        return stringArray;
    }

    protected abstract String[] directoryListing(String var1);

    protected abstract String getTextContent(String var1);

    protected abstract void saveTextContent(String var1, String var2);

    protected abstract ImageIcon getImageContent(String var1);

    protected abstract String adjustBaseDirectory(String var1);

    protected abstract String computeFilePath(String var1);

    protected abstract String makeSubdirectory(String var1);

    protected abstract boolean hasPackage(String var1);

    protected abstract void removeFile(String var1);
}

