/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.html.HTMLHelpScreen;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.menu.ItemSelectionEvent;
import elgato.infrastructure.menu.ItemSelectionListener;
import elgato.infrastructure.menu.ListScreen;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.scriptedTests.CertificationSuite;
import elgato.infrastructure.scriptedTests.ConfigurationScreen;
import elgato.infrastructure.scriptedTests.SiteConfigurationValues;
import elgato.infrastructure.scriptedTests.SoftwareFileSystem;
import elgato.infrastructure.scriptedTests.TestMenuScreen;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.DefaultEListCellRenderer;
import elgato.infrastructure.widgets.DefaultEListModel;
import elgato.infrastructure.widgets.ELabel;
import elgato.infrastructure.widgets.EList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class SoftwareHomeScreen
extends ListScreen {
    private JTextArea description;
    private String scriptInfo = "";
    protected static ScreenManager[] screenManagers = new ScreenManager[1];

    public SoftwareHomeScreen() {
        super(new DefaultEListModel(new String[]{"placeholder"}), 0, new ItemSelectionListener(){

            public void itemSelected(ItemSelectionEvent itemSelectionEvent) {
                ListEntry listEntry = (ListEntry)itemSelectionEvent.getValue();
                listEntry.doEvent();
            }
        }, CertificationSuite.instance().getName(), new DefaultEListCellRenderer(), false);
        this.fillInfo();
    }

    private ListEntry[] getList() {
        return new ListEntry[]{new ListEntry("---- CONFIGURATION MENU ----", ConfigurationScreen.getInstance()), new ListEntry("---- CALIBRATION MENU ----", TestMenuScreen.buildCalibrationMenuListScreen(this.getScreenManager())), new ListEntry("------ TEST MENU ------", TestMenuScreen.buildTestMenuListScreen(this.getScreenManager())), new ListEntry("---- UTILITIES MENU ----", TestMenuScreen.buildUtilitiesMenuListScreen(this.getScreenManager()))};
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        this.setModel(new DefaultEListModel(this.getList()));
        screenManager.getRightMenuPanel().installMenu(this.makeRightMenu());
        HTMLHelpScreen.setHelpEnabled(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBackground(Color.black);
        ELabel eLabel = new ELabel(this.title, ListScreen.TITLE_COLOR, ListScreen.TITLE_FONT);
        jPanel.add((Component)eLabel, "North");
        this.description = new JTextArea(this.scriptInfo, 8, 1);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        this.description.setEditable(false);
        this.description.setBackground(Color.black);
        this.description.setForeground(Color.white);
        this.description.setFont(new Font("SansSerif", 0, 12));
        jPanel.add((Component)this.description, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        this.list = new EList(this.listModel);
        this.list.setCellRenderer(this.cellRenderer);
        this.list.select(this.initialSelectedIndex);
        jPanel2.add((Component)this.list, "Center");
        screenManager.installDisplay(new BorderWrapper(jPanel2, ListScreen.BORDER, true));
        SoftwareHomeScreen.screenManagers[0] = this.getScreenManager();
    }

    protected MenuItem makeCancelButton() {
        return new PushButton("Cancel", "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                screenManagers[0].popScreen();
            }
        });
    }

    private void fillInfo() {
        CertificationSuite certificationSuite = CertificationSuite.instance();
        this.scriptInfo = "\nSoftware ID : " + certificationSuite.getId() + "\n\n" + "Version : " + certificationSuite.getVersion() + "\n\n" + "Running From : " + SoftwareFileSystem.getRegisteredFileSystem(certificationSuite.getId()).getName() + "\n\n";
        String string = SiteConfigurationValues.instance().getCurrentFilename();
        if (!"defaultconfig".equals(string)) {
            this.scriptInfo = this.scriptInfo + "Config File : " + string + "\n\n";
        }
        this.scriptInfo = this.scriptInfo + "Select an entry below to go to the corresponding screen.  From there you may adjust configuration settings, or run tests.  Normally, the following selections will be made in order.";
    }

    public void update() {
        this.fillInfo();
        this.description.setText(this.scriptInfo);
    }

    private static class ListEntry {
        private String menuEntry;
        private Screen screen;

        public ListEntry(String string, Screen screen) {
            this.menuEntry = string;
            this.screen = screen;
        }

        public String toString() {
            return this.menuEntry;
        }

        public void doEvent() {
            screenManagers[0].pushScreen(this.makeScreen());
        }

        protected Screen makeScreen() {
            return this.screen;
        }
    }
}

