/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.html.HTMLScreen;
import elgato.infrastructure.mainScreens.MessageScreen;
import elgato.infrastructure.mainScreens.MessageScreenListener;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.AlphaEditScreen;
import elgato.infrastructure.menu.ItemSelectionEvent;
import elgato.infrastructure.menu.ItemSelectionListener;
import elgato.infrastructure.menu.ListScreen;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.scriptedTests.CertificationSuite;
import elgato.infrastructure.scriptedTests.ConfigurationScreen;
import elgato.infrastructure.scriptedTests.ListEntry;
import elgato.infrastructure.scriptedTests.MeasurementResults;
import elgato.infrastructure.scriptedTests.ScriptedTest;
import elgato.infrastructure.scriptedTests.SiteConfigurationValues;
import elgato.infrastructure.scriptedTests.TestMenuScreen;
import elgato.infrastructure.util.FileSystemHelper;
import elgato.infrastructure.util.RuntimeConfiguration;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.DefaultEListCellRenderer;
import elgato.infrastructure.widgets.DefaultEListModel;
import elgato.infrastructure.widgets.ELabel;
import elgato.infrastructure.widgets.EList;
import elgato.infrastructure.widgets.EListModel;
import elgato.measurement.sigGen.SigGenMeasurementSettings;
import elgato.measurement.timeFreqRef.TimeFreqRefMeasurementSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class TestMenuScreen
extends ListScreen {
    private static ScreenManager screenManager;
    public static final String CALIBRATION = "Calibration";
    public static final String UTILITIES = "Utilities";
    private static int LIST_TYPE_TEST;
    private static int LIST_TYPE_CAL;
    private static int LIST_TYPE_UTIL;
    private JTextArea description;

    public TestMenuScreen(EListModel eListModel, String string, DefaultEListCellRenderer defaultEListCellRenderer) {
        super(eListModel, 0, new ItemSelectionListener(){

            public void itemSelected(ItemSelectionEvent itemSelectionEvent) {
                ListEntry listEntry = (ListEntry)itemSelectionEvent.getValue();
                listEntry.doEvent();
            }
        }, string, defaultEListCellRenderer, false);
    }

    public static TestMenuScreen buildTestMenuListScreen(ScreenManager screenManager) {
        TestMenuScreen.screenManager = screenManager;
        TestMenuScreen.turnSigGenOff();
        return new TestMenuScreen(new DefaultEListModel(TestMenuScreen.generateList(LIST_TYPE_TEST)), "Test Menu", new DefaultEListCellRenderer()){

            protected String instructionalText() {
                return "\n * Caution:  Wilt BTS before making connections.\n\n * After selecting a test, before pressing \"proceed (save data)\" or\n    \"save data\" assure frequency time reference light is green (locked).";
            }
        };
    }

    public static TestMenuScreen buildCalibrationMenuListScreen(ScreenManager screenManager) {
        TestMenuScreen.screenManager = screenManager;
        TestMenuScreen.turnSigGenOff();
        return new TestMenuScreen(new DefaultEListModel(TestMenuScreen.generateList(LIST_TYPE_CAL)), "Calibration Menu", new DefaultEListCellRenderer());
    }

    public static TestMenuScreen buildUtilitiesMenuListScreen(ScreenManager screenManager) {
        TestMenuScreen.screenManager = screenManager;
        TestMenuScreen.turnSigGenOff();
        return new TestMenuScreen(new DefaultEListModel(TestMenuScreen.generateList(LIST_TYPE_UTIL)), "Utilities Menu", new DefaultEListCellRenderer());
    }

    public void installScreen(ScreenManager screenManager) {
        DisplayGlobalMeasurementSettings.instance().getChanStd().setValue(SiteConfigurationValues.instance().getChannelStdIndex());
        DisplayGlobalMeasurementSettings.instance().invalidate();
        DisplayGlobalMeasurementSettings.instance().refresh();
        this.sendFreqTimeRef();
        super.installScreen(screenManager);
        Menu menu = screenManager.getRightMenuPanel().getMenu();
        menu.setMenuItem(this.makeViewDataButton(), 3);
        menu.setMenuItem(this.makeStoreDataButton(), 4);
        menu.setMenuItem(this.makeConfigScreenButton(), 5);
        this.setModel(this.listModel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBackground(Color.black);
        ELabel eLabel = new ELabel(this.title, ListScreen.TITLE_COLOR, ListScreen.TITLE_FONT);
        jPanel.add((Component)eLabel, "North");
        this.description = new JTextArea(this.instructionalText(), 8, 1);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        this.description.setEditable(false);
        this.description.setBackground(Color.black);
        this.description.setForeground(Color.white);
        this.description.setFont(new Font("SansSerif", 0, 12));
        jPanel.add((Component)this.description, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        this.list = new EList(this.listModel);
        this.list.setCellRenderer(this.cellRenderer);
        this.list.select(this.initialSelectedIndex);
        jPanel2.add((Component)this.list, "Center");
        screenManager.installDisplay(new BorderWrapper(jPanel2, ListScreen.BORDER, true));
    }

    protected String instructionalText() {
        return "";
    }

    private void sendFreqTimeRef() {
        TimeFreqRefMeasurementSettings timeFreqRefMeasurementSettings = TimeFreqRefMeasurementSettings.instance();
        timeFreqRefMeasurementSettings.setFreqTimeRefByString(SiteConfigurationValues.instance().getFreqTimeRef());
        timeFreqRefMeasurementSettings.getTimeFreqRef().send();
    }

    private MenuItem makeConfigScreenButton() {
        return new PushButton("Config\nMenu", this.getContextString(""), new elgato.infrastructure.menu.ActionListener(){

            public void actionPerformed() {
                DisplayGlobalMeasurementSettings.instance().getChanStd().setValue(SiteConfigurationValues.instance().getChannelStdIndex());
                DisplayGlobalMeasurementSettings.instance().invalidate();
                DisplayGlobalMeasurementSettings.instance().refresh();
                ScreenManager screenManager = TestMenuScreen.this.getScreenManager();
                ConfigurationScreen configurationScreen = ConfigurationScreen.getInstance();
                screenManager.popScreen();
                screenManager.pushScreen(configurationScreen);
            }
        });
    }

    public void advanceSelection() {
        int n = this.list.getSelectedIndex() + 1;
        if (n < this.list.getItemCount()) {
            this.list.select(n);
        }
    }

    protected MenuItem makeCancelButton() {
        return new PushButton("Main\nMenu", this.getContextString(""), new elgato.infrastructure.menu.ActionListener(){

            public void actionPerformed() {
                TestMenuScreen.this.getScreenManager().popScreen();
            }
        });
    }

    private MenuItem makeViewDataButton() {
        PushButton pushButton = new PushButton("View Test\nData", "viewData", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = RuntimeConfiguration.isEmbedded() ? FileSystemHelper.getInstance().readFromFile("/flash/tempResults") : FileSystemHelper.getInstance().readFromFile("c:\\tempResults");
                if (string.startsWith("Exception while reading from the file.")) {
                    string = "";
                }
                HTMLScreen hTMLScreen = new HTMLScreen(screenManager, false, " ");
                screenManager.pushScreen(hTMLScreen);
                hTMLScreen.getHTMLManager().getHTMLRenderer().setText("<HTML><HEAD>test</HEAD><BODY>" + string + "</BODY></HTML>");
                hTMLScreen.getHTMLManager().getHTMLRenderer().render();
            }
        });
        return pushButton;
    }

    private MenuItem makeStoreDataButton() {
        PushButton pushButton = new PushButton("Store Test\nData", "storeData", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!SiteConfigurationValues.instance().getFreqTimeRef().equals(Text.GPS) || MeasurementResults.getInstance().getTimeDateHeader().indexOf("<p>Date/Time: No GPS") > -1) {
                    MessageScreen messageScreen = new MessageScreen("No GPS connection. Enter time?<br>(MM-DD-YY)", false, 2);
                    screenManager.pushScreen(messageScreen);
                    messageScreen.addListener(new MessageScreenListener(this){
                        private final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void messageScreenExit(int n) {
                            if (n == 2) {
                                AlphaEditScreen alphaEditScreen = new AlphaEditScreen(Value.createValue("Date Stamp", "MM-DD-YY"));
                                TestMenuScreen.access$000().pushScreen(alphaEditScreen);
                                alphaEditScreen.addExitListener(new AlphaEditScreen.AlphaEditScreenExitListener(this){
                                    private final /* synthetic */ 7 this$2;
                                    {
                                        this.this$2 = var1_1;
                                    }

                                    public void alphaEditScreenExit(int n, String string) {
                                        if (n == 0) {
                                            MeasurementResults.getInstance().setUserInputedDate(string);
                                            MeasurementResults.getInstance().writeFinalResults(TestMenuScreen.access$000());
                                            MeasurementResults.getInstance().writeInterumResults(TestMenuScreen.access$000());
                                            MeasurementResults.getInstance().setUserInputedDate("");
                                        }
                                    }
                                });
                            } else {
                                MeasurementResults.getInstance().writeFinalResults(TestMenuScreen.access$000());
                            }
                        }
                    });
                } else {
                    MeasurementResults.getInstance().writeFinalResults(screenManager);
                }
            }
        });
        return pushButton;
    }

    private static ListEntry[] generateList(int n) {
        Vector vector = n == LIST_TYPE_CAL ? CertificationSuite.instance().getFilteredCalTestList(SiteConfigurationValues.instance()) : (n == LIST_TYPE_UTIL ? CertificationSuite.instance().getFilteredUtilTestList(SiteConfigurationValues.instance()) : CertificationSuite.instance().getFilteredTestList(SiteConfigurationValues.instance()));
        ListEntry[] listEntryArray = new ListEntry[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            listEntryArray[i] = new TestListEntryObject((ScriptedTest)vector.elementAt(i));
        }
        return listEntryArray;
    }

    public static void turnSigGenOff() {
        SigGenMeasurementSettings sigGenMeasurementSettings = SigGenMeasurementSettings.instance();
        sigGenMeasurementSettings.getBackgroundMode().send(0);
        MeasurementFactory.instance().getCommandProcessor().setInactive();
    }

    static {
        LIST_TYPE_TEST = 0;
        LIST_TYPE_CAL = 1;
        LIST_TYPE_UTIL = 2;
    }

    static class TestListEntryObject
    extends ListEntry {
        private ScriptedTest test;

        public TestListEntryObject(ScriptedTest scriptedTest) {
            super(scriptedTest.getName());
            this.test = scriptedTest;
        }

        public void doEvent() {
            this.test.reset();
            Screen screen = this.test.nextScreen();
            if (screen != null) {
                screenManager.pushScreen(screen);
            } else {
                this.test.showMeasurementScreen(screenManager);
            }
        }
    }
}

