/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.scriptedTests.CalibrationTestScreenDefinition;
import elgato.infrastructure.scriptedTests.GraphicsTestScreenDefinition;
import elgato.infrastructure.scriptedTests.InputTestScreenDefinition;
import elgato.infrastructure.scriptedTests.PassFailTestScreenDefinition;
import elgato.infrastructure.scriptedTests.PowerMeterFunctionTestScreenDefinition;
import elgato.infrastructure.scriptedTests.ScriptedTest;
import elgato.infrastructure.scriptedTests.SoftwareFileSystem;
import elgato.infrastructure.scriptedTests.TextTestScreenDefinition;
import elgato.infrastructure.scriptedTests.ValueStoreTestScreenDefinition;
import elgato.infrastructure.util.Text;

public abstract class TestScreenDefinition {
    protected String id;
    private String upperText;
    private String textOrFilename;
    private String[] fileNames;
    static final String FAIL = Text.FAIL;
    static final String PASS = Text.PASS;
    String actuatorLabel;
    boolean startSigGen;
    long amplitude;
    long rangeValidatorMin;
    long rangeValidatorMax;
    int whichActuator;
    SoftwareFileSystem fileLocation;

    public static TextTestScreenDefinition createTextScreenDefinition(String string, String string2, SoftwareFileSystem softwareFileSystem, String string3, boolean bl, long l) {
        TextTestScreenDefinition textTestScreenDefinition = new TextTestScreenDefinition(string, string2, softwareFileSystem, string3, bl);
        textTestScreenDefinition.amplitude = l;
        return textTestScreenDefinition;
    }

    public static ValueStoreTestScreenDefinition createValueStoreScreenDefinition(String string, SoftwareFileSystem softwareFileSystem, String string2, String string3) {
        return new ValueStoreTestScreenDefinition(string, softwareFileSystem, string2, string3);
    }

    public static GraphicsTestScreenDefinition createGraphicScreenDefinition(String string, String[] stringArray, SoftwareFileSystem softwareFileSystem, String string2, boolean bl) {
        return new GraphicsTestScreenDefinition(string, stringArray, softwareFileSystem, string2, bl);
    }

    public static InputTestScreenDefinition createInputScreenDefinition(String string, String string2, String string3, boolean bl, long l, long l2, long l3, int n, SoftwareFileSystem softwareFileSystem, String string4) {
        InputTestScreenDefinition inputTestScreenDefinition = new InputTestScreenDefinition(string, string2, softwareFileSystem, string4);
        inputTestScreenDefinition.actuatorLabel = string3;
        inputTestScreenDefinition.startSigGen = bl;
        inputTestScreenDefinition.amplitude = l;
        inputTestScreenDefinition.rangeValidatorMin = l2;
        inputTestScreenDefinition.rangeValidatorMax = l3;
        inputTestScreenDefinition.whichActuator = n;
        return inputTestScreenDefinition;
    }

    public static PassFailTestScreenDefinition createPassFailScreenDefinition(String string, String string2, String string3, String string4, SoftwareFileSystem softwareFileSystem, String string5, boolean bl) {
        PassFailTestScreenDefinition passFailTestScreenDefinition = new PassFailTestScreenDefinition(string, string2, string3, string4, softwareFileSystem, string5, bl);
        return passFailTestScreenDefinition;
    }

    public static CalibrationTestScreenDefinition createCallibrateScreenDefinition(SoftwareFileSystem softwareFileSystem, String string, String[] stringArray) {
        return new CalibrationTestScreenDefinition(softwareFileSystem, string, stringArray);
    }

    public static PowerMeterFunctionTestScreenDefinition createZeroScreenDefinition(SoftwareFileSystem softwareFileSystem, String string, boolean bl) {
        return new PowerMeterFunctionTestScreenDefinition(softwareFileSystem, string, 3, bl);
    }

    public static PowerMeterFunctionTestScreenDefinition createCalibratePmScreenDefinition(SoftwareFileSystem softwareFileSystem, String string, boolean bl) {
        return new PowerMeterFunctionTestScreenDefinition(softwareFileSystem, string, 2, bl);
    }

    TestScreenDefinition(String string, String string2, SoftwareFileSystem softwareFileSystem, String string3) {
        this.upperText = string;
        this.textOrFilename = string2;
        this.fileLocation = softwareFileSystem;
        this.id = string3;
    }

    TestScreenDefinition(String string, String[] stringArray, SoftwareFileSystem softwareFileSystem, String string2) {
        this.upperText = string;
        this.fileNames = stringArray;
        this.fileLocation = softwareFileSystem;
        this.id = string2;
    }

    public String getUpperText() {
        return this.upperText;
    }

    public String getTextOrFilename() {
        if (this.isFile()) {
            return this.fileLocation.getText(this.id, this.textOrFilename);
        }
        return this.textOrFilename;
    }

    private boolean isFile() {
        return this.textOrFilename.endsWith(".txt");
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public abstract Screen getScreen(ScriptedTest var1);
}

