/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.scriptedTests.InputScreen;
import elgato.infrastructure.scriptedTests.ScriptedTest;
import elgato.infrastructure.scriptedTests.ScriptedTestScreen;
import elgato.infrastructure.scriptedTests.SiteConfigurationValues;
import elgato.infrastructure.scriptedTests.TextTestScreenDefinition;
import elgato.measurement.sigGen.SigGenMeasurementSettings;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class TextScreen
extends ScriptedTestScreen {
    private JTextArea contentJTextArea;
    protected TextTestScreenDefinition testScreenDefinition;
    static final String CHANNEL = "%CHANNEL%";

    public TextScreen(TextTestScreenDefinition textTestScreenDefinition, ScriptedTest scriptedTest) {
        super(textTestScreenDefinition.getUpperText(), scriptedTest);
        this.testScreenDefinition = textTestScreenDefinition;
        this.startSigGen = textTestScreenDefinition.startSigGen;
    }

    protected void doScreenSpecificInstallConfig(ScreenManager screenManager) {
        JPanel jPanel = new JPanel();
        this.createContentJtextArea();
        if (this.headerText != null && this.headerText != "") {
            jPanel.add(this.createJtextArea(this.headerText));
        }
        jPanel.add(this.contentJTextArea);
        this.getScreenManager().installDisplay(jPanel);
        screenManager.getRightMenuPanel().installMenu(this.makeRightMenu());
    }

    private void createContentJtextArea() {
        String string = this.testScreenDefinition.getTextOrFilename();
        string = this.replaceTokens(string);
        this.contentJTextArea = new JTextArea(string);
        this.contentJTextArea.setSize(this.getDesiredWidth(), 50);
        this.contentJTextArea.setLineWrap(true);
        this.contentJTextArea.setWrapStyleWord(true);
        this.contentJTextArea.setEditable(false);
    }

    protected void setAreaText(String string) {
        this.contentJTextArea.setText(string);
        this.contentJTextArea.repaint();
    }

    protected String replaceTokens(String string) {
        return this.setToken(string, CHANNEL, SiteConfigurationValues.instance().getChannel());
    }

    protected void doScreenSpecificFireOffSigGenCommand(Command command) {
        super.doScreenSpecificFireOffSigGenCommand(command);
        if (!this.scriptedTest.isRerun()) {
            command.addProperty("srcAmp", this.testScreenDefinition.amplitude);
            InputScreen.pmAmplitude = this.testScreenDefinition.amplitude;
        } else {
            InputScreen.pmAmplitude = SigGenMeasurementSettings.instance().getAmplitude().longValue();
        }
    }
}

