/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.MeasurementListener;
import elgato.infrastructure.scriptedTests.ConfigurationScreen;
import elgato.infrastructure.scriptedTests.MeasurementResults;
import elgato.infrastructure.scriptedTests.ScriptedTest;
import elgato.infrastructure.scriptedTests.SiteConfigurationValues;
import elgato.infrastructure.scriptedTests.SoftwareFileSystem;
import elgato.infrastructure.scriptedTests.TextScreen;
import elgato.infrastructure.scriptedTests.TextTestScreenDefinition;
import elgato.measurement.twoPortInsertionLoss.TwoPortInsertionLossMeasurement;

public class ValueStoreTestScreenDefinition
extends TextTestScreenDefinition {
    String actuatorName;
    String upperLimitInfo = "";
    String lowerLimitInfo = "";
    double highLimit = Double.POSITIVE_INFINITY;
    double lowLimit = Double.NEGATIVE_INFINITY;
    private String testId;
    static int value = 456;
    static /* synthetic */ Class class$elgato$measurement$twoPortInsertionLoss$TwoPortInsertionLossMeasurement;

    ValueStoreTestScreenDefinition(String string, SoftwareFileSystem softwareFileSystem, String string2) {
        this(string, softwareFileSystem, string2, null);
    }

    ValueStoreTestScreenDefinition(String string, SoftwareFileSystem softwareFileSystem, String string2, String string3) {
        super(string, "", softwareFileSystem, string2, false);
        this.actuatorName = string3;
    }

    public Screen getScreen(ScriptedTest scriptedTest) {
        this.testId = scriptedTest.getId();
        return new ValueTextScreen(this, scriptedTest);
    }

    private String renderValue() {
        double d = (double)value / 1000.0;
        if (this.testId.equals("rx1-receive-path-gain") || this.testId.equals("rx0-receieve-path-gain")) {
            String string = "P A S S";
            d = (double)(value *= -1) / 1000.0;
            if ((double)value > this.highLimit || (double)value < this.lowLimit) {
                string = "F A I L";
            }
            this.upperLimitInfo = "\n UPPER LIMIT : " + this.highLimit / 1000.0;
            this.lowerLimitInfo = " LOWER LIMIT : " + this.lowLimit / 1000.0 + "\n\n\n ---- " + string + " ----\n";
        }
        return this.upperLimitInfo + "\n\n Current Value : " + new Double(d).toString() + " dB\n\n" + this.lowerLimitInfo;
    }

    static /* synthetic */ String access$100(ValueStoreTestScreenDefinition valueStoreTestScreenDefinition) {
        return valueStoreTestScreenDefinition.renderValue();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ValueTextScreen
    extends TextScreen {
        public ValueTextScreen(ValueStoreTestScreenDefinition valueStoreTestScreenDefinition2, ScriptedTest scriptedTest) {
            block6: {
                block5: {
                    super(valueStoreTestScreenDefinition2, scriptedTest);
                    MeasurementFactory.instance().getCommandProcessor().setActive("antInsLoss");
                    MeasurementFactory.instance().getMeasurementReader().addMeasurementListener(new MeasurementListener(this){
                        private final /* synthetic */ ValueTextScreen this$1;
                        {
                            this.this$1 = valueTextScreen;
                        }

                        public void measurementReceived(Measurement measurement) {
                            value = ((TwoPortInsertionLossMeasurement)measurement).getAverageInsertionLoss();
                            this.this$1.setAreaText(ValueStoreTestScreenDefinition.access$100(ValueTextScreen.access$000(this.this$1)));
                        }
                    }, class$elgato$measurement$twoPortInsertionLoss$TwoPortInsertionLossMeasurement == null ? (class$elgato$measurement$twoPortInsertionLoss$TwoPortInsertionLossMeasurement = ValueStoreTestScreenDefinition.class$("elgato.measurement.twoPortInsertionLoss.TwoPortInsertionLossMeasurement")) : class$elgato$measurement$twoPortInsertionLoss$TwoPortInsertionLossMeasurement);
                    ValueStoreTestScreenDefinition.this.id = "rx1-receive-path-gain";
                    if (scriptedTest.getId().equals("rx1-receive-path-gain")) break block5;
                    ValueStoreTestScreenDefinition.this.id = "rx0-receieve-path-gain";
                    if (!scriptedTest.getId().equals("rx0-receieve-path-gain")) break block6;
                }
                SiteConfigurationValues siteConfigurationValues = SiteConfigurationValues.instance();
                ValueStoreTestScreenDefinition.this.id = "rx1-receive-path-gain";
                if (scriptedTest.getId().equals("rx1-receive-path-gain")) {
                    ValueStoreTestScreenDefinition.this.lowLimit = Double.valueOf(siteConfigurationValues.getSiteTestType().getRxUpperLimit(1));
                    ValueStoreTestScreenDefinition.this.highLimit = Double.valueOf(siteConfigurationValues.getSiteTestType().getrxLowerLimit(1));
                } else {
                    ValueStoreTestScreenDefinition.this.lowLimit = Double.valueOf(siteConfigurationValues.getSiteTestType().getRxUpperLimit(0));
                    ValueStoreTestScreenDefinition.this.highLimit = Double.valueOf(siteConfigurationValues.getSiteTestType().getrxLowerLimit(0));
                }
            }
        }

        protected void doStuff() {
            super.doStuff();
            this.storeValue();
            MeasurementFactory.instance().getCommandProcessor().setInactive();
        }

        private void storeValue() {
            SiteConfigurationValues siteConfigurationValues = SiteConfigurationValues.instance();
            String string = String.valueOf(new Double(value) / 1000.0);
            if ("rfout".equalsIgnoreCase(ValueStoreTestScreenDefinition.this.actuatorName)) {
                siteConfigurationValues.setRfOutLoss(string, true);
                ConfigurationScreen.getInstance().updateLosses();
            } else if ("pm".equalsIgnoreCase(ValueStoreTestScreenDefinition.this.actuatorName)) {
                siteConfigurationValues.setPowerMeterLoss(string, true);
                ConfigurationScreen.getInstance().updateLosses();
            } else if ("rfin".equalsIgnoreCase(ValueStoreTestScreenDefinition.this.actuatorName)) {
                siteConfigurationValues.setRfInLoss(string, true);
                ConfigurationScreen.getInstance().updateLosses();
            } else {
                double d = ValueStoreTestScreenDefinition.this.lowLimit;
                double d2 = ValueStoreTestScreenDefinition.this.highLimit;
                if (ValueStoreTestScreenDefinition.this.lowLimit != Double.NEGATIVE_INFINITY) {
                    d /= 1000.0;
                }
                if (ValueStoreTestScreenDefinition.this.highLimit != Double.POSITIVE_INFINITY) {
                    d2 /= 1000.0;
                }
                String string2 = MeasurementScreen.createResultLine(value, d2, d, this.scriptedTest.getName(), "dB");
                MeasurementResults.getInstance().writeResults(string2, this.getScreenManager(), this.scriptedTest.getIndex());
            }
        }

        static /* synthetic */ ValueStoreTestScreenDefinition access$000(ValueTextScreen valueTextScreen) {
            return valueTextScreen.ValueStoreTestScreenDefinition.this;
        }
    }
}

