/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.scriptedTests;

import elgato.infrastructure.scriptedTests.CertificationSuite;
import elgato.infrastructure.scriptedTests.CertificationSuiteReader;
import elgato.infrastructure.scriptedTests.TestScreenDefinition;
import elgato.infrastructure.util.Arrays;
import java.io.IOException;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlScriptParser
extends DefaultHandler {
    private String screenUpperText = "";
    private String screenBodyText = "";
    private String whichActuator;
    private CertificationSuite certificationSuite;
    private Vector stringVector;
    private Vector screens;
    private StringBuffer buffer = new StringBuffer();
    private CertificationSuiteReader reader;
    private String key;
    private Vector expectedListTags = this.initializeExpectedListTags();
    private Vector connectionLists;
    private Vector connections;
    private Vector connectionGroups;
    private CertificationSuiteReader.PseudoTestListEntry testListEntry;
    private String testType;
    private boolean splitter;
    private String inputLabel = "";
    private boolean startSigGen;
    private long inputAmplitude;
    private long inputRangeValMin;
    private long inputRangeValMax;
    private int inputActuator;
    private String pfUpperKey = "";
    private String pfLowerKey = "";
    private boolean pfUseFer;

    public XmlScriptParser(InputSource inputSource, CertificationSuiteReader certificationSuiteReader) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IOException, SAXException {
        this.reader = certificationSuiteReader;
        this.certificationSuite = CertificationSuite.instance();
        XMLReader xMLReader = (XMLReader)Class.forName("org.apache.xerces.parsers.SAXParser").newInstance();
        xMLReader.setContentHandler(this);
        xMLReader.setErrorHandler(this);
        xMLReader.parse(inputSource);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        this.buffer.setLength(0);
        if ("nemscript".equalsIgnoreCase(string3)) {
            this.certificationSuite.setName(attributes.getValue("name"));
            this.certificationSuite.setId(attributes.getValue("licenseId"));
            this.certificationSuite.setVersion(attributes.getValue("softwareversion"));
        } else if (this.isListTag(string3)) {
            this.key = attributes.getValue("name");
            this.stringVector = new Vector(3);
        } else if ("requiredOptions".equalsIgnoreCase(string3)) {
            this.stringVector = new Vector(3);
        } else if ("basestationtype".equalsIgnoreCase(string3)) {
            this.loadBaseStationDef(attributes);
        } else if ("CONNECTIONDEVICELIST".equalsIgnoreCase(string3)) {
            this.key = attributes.getValue("name");
            this.connectionLists = new Vector(2);
        } else if ("connection_list".equalsIgnoreCase(string3)) {
            this.connections = new Vector();
        } else if ("list_group".equalsIgnoreCase(string3)) {
            this.connectionLists = new Vector();
        } else if ("TROUBLESHOOTINGCONNECTIONDEVICELIST".equalsIgnoreCase(string3)) {
            this.key = attributes.getValue("name");
            this.connectionGroups = new Vector();
        } else if ("TESTDEFINITION".equalsIgnoreCase(string3)) {
            String string5 = attributes.getValue("name");
            String string6 = attributes.getValue("id");
            String string7 = attributes.getValue("measurement");
            boolean bl = "true".equalsIgnoreCase(attributes.getValue("savedata"));
            boolean bl2 = "true".equalsIgnoreCase(attributes.getValue("multicarrier"));
            this.testType = attributes.getValue("testType");
            this.stringVector = null;
            this.testListEntry = new CertificationSuiteReader.PseudoTestListEntry(string5, string6, string7, bl, bl2);
            this.screens = new Vector();
        } else if ("imagelist".equalsIgnoreCase(string3)) {
            this.stringVector = new Vector(4);
        } else if ("graphicscreen".equalsIgnoreCase(string3)) {
            this.splitter = "true".equalsIgnoreCase(attributes.getValue("splitter"));
        } else if ("valuestorescreen".equalsIgnoreCase(string3)) {
            this.whichActuator = attributes.getValue("actuator");
        } else if ("zeroScreen".equalsIgnoreCase(string3)) {
            boolean bl = "true".equals(attributes.getValue("skipButton"));
            this.screens.addElement(TestScreenDefinition.createZeroScreenDefinition(this.reader.swDirectory, this.certificationSuite.getId(), bl));
            this.clearScreenVariables();
        } else if ("calibratePmScreen".equalsIgnoreCase(string3)) {
            boolean bl = "true".equals(attributes.getValue("skipButton"));
            this.screens.addElement(TestScreenDefinition.createCalibratePmScreenDefinition(this.reader.swDirectory, this.certificationSuite.getId(), bl));
            this.clearScreenVariables();
        } else if ("inputscreen".equalsIgnoreCase(string3)) {
            this.startSigGen = "true".equalsIgnoreCase(attributes.getValue("sigGen"));
        } else if ("textscreen".equalsIgnoreCase(string3)) {
            this.startSigGen = "true".equalsIgnoreCase(attributes.getValue("sigGen"));
        } else if ("passfailscreen".equalsIgnoreCase(string3)) {
            this.pfLowerKey = attributes.getValue("lowerKey");
            this.pfUpperKey = attributes.getValue("upperKey");
            this.pfUseFer = "true".equalsIgnoreCase(attributes.getValue("useFer"));
        } else if ("imagefile".equalsIgnoreCase(string3)) {
            this.stringVector.addElement(attributes.getValue("name"));
        } else if ("BaseStations".equalsIgnoreCase(string3)) {
            this.stringVector = new Vector();
        } else if ("BaseStation".equalsIgnoreCase(string3)) {
            this.stringVector.addElement(attributes.getValue("name"));
        } else if ("BodyText".equalsIgnoreCase(string3) && (string4 = attributes.getValue("sourceFile")) != null) {
            this.buffer.append(string4);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if ("item".equalsIgnoreCase(string3)) {
            this.stringVector.addElement(this.buffer.toString());
        } else if ("cabinet".equalsIgnoreCase(string3)) {
            this.reader.cabinetConfLists.put(this.key, Arrays.toArray(this.stringVector));
        } else if ("carrierConfig".equalsIgnoreCase(string3)) {
            this.reader.carrierConfLists.put(this.key, Arrays.toArray(this.stringVector));
        } else if ("sector".equalsIgnoreCase(string3)) {
            this.reader.sectorLists.put(this.key, Arrays.toArray(this.stringVector));
        } else if ("channelStandard".equalsIgnoreCase(string3)) {
            this.reader.chanStandardLists.put(this.key, Arrays.toArray(this.stringVector));
        } else if ("rxList".equalsIgnoreCase(string3)) {
            this.reader.rxLists.put(this.key, Arrays.toArray(this.stringVector));
        } else if ("txList".equalsIgnoreCase(string3)) {
            this.reader.txLists.put(this.key, Arrays.toArray(this.stringVector));
        } else if ("requiredOptions".equalsIgnoreCase(string3)) {
            this.certificationSuite.setRequiredOptions(Arrays.toArray(this.stringVector));
        } else if ("CONNECTIONDEVICELIST".equalsIgnoreCase(string3)) {
            this.reader.connectionDeviceLists.put(this.key, this.vector2arrays());
        } else if ("connection_list".equalsIgnoreCase(string3)) {
            this.connectionLists.addElement(Arrays.toArray(this.connections));
        } else if ("connection".equalsIgnoreCase(string3)) {
            this.connections.addElement(this.buffer.toString());
        } else if ("TROUBLESHOOTINGCONNECTIONDEVICELIST".equalsIgnoreCase(string3)) {
            this.reader.troubleshootConnectionDeviceLists.put(this.key, this.vector3arrays());
        } else if ("list_group".equalsIgnoreCase(string3)) {
            this.connectionGroups.addElement(this.vector2arrays());
        } else if ("TESTDEFINITION".equalsIgnoreCase(string3)) {
            TestScreenDefinition[] testScreenDefinitionArray = new TestScreenDefinition[this.screens.size()];
            for (int i = 0; i < this.screens.size(); ++i) {
                TestScreenDefinition testScreenDefinition;
                testScreenDefinitionArray[i] = testScreenDefinition = (TestScreenDefinition)this.screens.elementAt(i);
            }
            this.testListEntry.screenDefinitions = testScreenDefinitionArray;
            if ("cal".equals(this.testType)) {
                this.reader.calTestList.addElement(this.testListEntry);
            } else if ("util".equals(this.testType)) {
                this.reader.utilTestList.addElement(this.testListEntry);
            } else {
                this.reader.testList.addElement(this.testListEntry);
            }
        } else if ("graphicscreen".equalsIgnoreCase(string3)) {
            this.screens.addElement(TestScreenDefinition.createGraphicScreenDefinition(this.screenUpperText, Arrays.toArray(this.stringVector), this.reader.swDirectory, this.certificationSuite.getId(), this.splitter));
            this.clearScreenVariables();
        } else if ("normalizeScreen".equalsIgnoreCase(string3)) {
            this.screens.addElement(TestScreenDefinition.createCallibrateScreenDefinition(this.reader.swDirectory, this.certificationSuite.getId(), Arrays.toArray(this.stringVector)));
            this.clearScreenVariables();
        } else if ("textscreen".equalsIgnoreCase(string3)) {
            this.screens.addElement(TestScreenDefinition.createTextScreenDefinition(this.screenUpperText, this.screenBodyText, this.reader.swDirectory, this.certificationSuite.getId(), this.startSigGen, this.inputAmplitude));
            this.clearScreenVariables();
        } else if ("valuestorescreen".equalsIgnoreCase(string3)) {
            this.screens.addElement(TestScreenDefinition.createValueStoreScreenDefinition(this.screenUpperText, this.reader.swDirectory, this.certificationSuite.getId(), this.whichActuator));
            this.clearScreenVariables();
        } else if ("passfailscreen".equalsIgnoreCase(string3)) {
            this.screens.addElement(TestScreenDefinition.createPassFailScreenDefinition(this.screenUpperText, this.screenBodyText, this.pfUpperKey, this.pfLowerKey, this.reader.swDirectory, this.certificationSuite.getId(), this.pfUseFer));
            this.clearScreenVariables();
        } else if ("inputscreen".equalsIgnoreCase(string3)) {
            this.screens.addElement(TestScreenDefinition.createInputScreenDefinition(this.screenUpperText, this.screenBodyText, this.inputLabel, this.startSigGen, this.inputAmplitude, this.inputRangeValMin, this.inputRangeValMax, this.inputActuator, this.reader.swDirectory, this.certificationSuite.getId()));
            this.clearScreenVariables();
        } else if ("UpperText".equalsIgnoreCase(string3)) {
            this.screenUpperText = this.buffer.toString();
        } else if ("BodyText".equalsIgnoreCase(string3)) {
            this.screenBodyText = this.buffer.toString();
        } else if ("BaseStations".equalsIgnoreCase(string3)) {
            this.testListEntry.baseStations = Arrays.toArray(this.stringVector);
        } else if ("Label".equalsIgnoreCase(string3)) {
            this.inputLabel = this.buffer.toString();
        } else if ("amp".equalsIgnoreCase(string3)) {
            this.inputAmplitude = Long.valueOf(this.buffer.toString());
        } else if ("actuator".equalsIgnoreCase(string3)) {
            this.inputActuator = Integer.valueOf(this.buffer.toString());
        } else if ("min".equalsIgnoreCase(string3)) {
            this.inputRangeValMin = "minint".equalsIgnoreCase(this.buffer.toString()) ? Long.MIN_VALUE : Long.valueOf(this.buffer.toString());
        } else if ("max".equalsIgnoreCase(string3)) {
            this.inputRangeValMax = "maxint".equalsIgnoreCase(this.buffer.toString()) ? Long.MAX_VALUE : Long.valueOf(this.buffer.toString());
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.buffer.append(new String(cArray, n, n2));
    }

    private void clearScreenVariables() {
        this.screenBodyText = "";
        this.screenUpperText = "";
        this.whichActuator = null;
    }

    private String[][][] vector3arrays() {
        String[][][] stringArray = new String[this.connectionGroups.size()][][];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String[][])this.connectionGroups.elementAt(i);
        }
        return stringArray;
    }

    private String[][] vector2arrays() {
        String[][] stringArray = new String[this.connectionLists.size()][];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String[])this.connectionLists.elementAt(i);
        }
        return stringArray;
    }

    private boolean isListTag(String string) {
        return this.expectedListTags.contains(string.toLowerCase());
    }

    private Vector initializeExpectedListTags() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("cabinet".toLowerCase());
        vector.addElement("carrierConfig".toLowerCase());
        vector.addElement("sector".toLowerCase());
        vector.addElement("channelStandard".toLowerCase());
        vector.addElement("rxlist".toLowerCase());
        vector.addElement("txlist".toLowerCase());
        return vector;
    }

    private void loadBaseStationDef(Attributes attributes) {
        CertificationSuiteReader.BaseStationDef baseStationDef = new CertificationSuiteReader.BaseStationDef();
        baseStationDef.name = attributes.getValue("name");
        baseStationDef.cabConfigList = attributes.getValue("cabinet");
        baseStationDef.carrierConfigList = attributes.getValue("carrier");
        baseStationDef.chanStdList = attributes.getValue("chanStd");
        baseStationDef.connectionDevices = attributes.getValue("connection");
        baseStationDef.powerOutTable = attributes.getValue("power");
        baseStationDef.powerValues = attributes.getValue("powerValues");
        baseStationDef.recommendedOCNS = attributes.getValue("ocns");
        baseStationDef.rxList = attributes.getValue("rx");
        baseStationDef.txList = attributes.getValue("tx");
        baseStationDef.rxValues = attributes.getValue("rxValues");
        baseStationDef.sectorList = attributes.getValue("sector");
        baseStationDef.troubleshootConnectionDevices = attributes.getValue("troubleshooting");
        this.reader.stationTypes.addElement(baseStationDef);
    }
}

