/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.strategies;

import elgato.infrastructure.strategies.AdjustmentStrategy;
import elgato.infrastructure.util.chanstd.Band;
import elgato.infrastructure.util.chanstd.BandSelector;
import elgato.infrastructure.util.chanstd.IChannel;
import elgato.infrastructure.util.chanstd.InvalidChannelException;
import elgato.infrastructure.util.chanstd.InvalidFrequencyException;
import elgato.infrastructure.valueobject.ValueInterface;

public class ChannelAdjustmentStrategy
implements AdjustmentStrategy {
    private final ValueInterface channelStep;
    private final BandSelector bandSelector;

    public ChannelAdjustmentStrategy(ValueInterface valueInterface, BandSelector bandSelector) {
        this.channelStep = valueInterface;
        this.bandSelector = bandSelector;
    }

    public long stepUp(long l) {
        return this.doStep(l, this.getStep());
    }

    public long stepDown(long l) {
        return this.doStep(l, -this.getStep());
    }

    private long doStep(long l, int n) {
        double d;
        Band band = Band.getCurrentBand(this.bandSelector);
        boolean bl = band.isFrequencyFwdChannel(l);
        try {
            d = band.convertFrequencyToChannelNumber(l);
        }
        catch (InvalidFrequencyException invalidFrequencyException) {
            return band.getDefaultChannel().getCenterFrequency();
        }
        try {
            double d2 = d;
            int n2 = Math.abs(n);
            boolean bl2 = n >= 0;
            for (int i = 0; i < n2; ++i) {
                d2 = bl2 ? (double)band.getNextChannel(d2) : (double)band.getPrevChannel(d2);
            }
            IChannel iChannel = bl ? band.getChannelFwdByChannelNumber(d2) : band.getChannelRevByChannelNumber(d2);
            return iChannel.getCenterFrequency();
        }
        catch (InvalidChannelException invalidChannelException) {
            return l;
        }
    }

    private int getStep() {
        return this.channelStep.intValue();
    }

    public long scroll(long l, int n) {
        return this.doStep(l, n);
    }
}

