/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.strategies;

import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.util.Frequency;

public class FrequencyStrategy
extends NumberFieldStrategy {
    private boolean useMilliHzScaling;
    private int decimalPlaces = -1;

    public FrequencyStrategy() {
    }

    private FrequencyStrategy(boolean bl, int n) {
        this.useMilliHzScaling = bl;
        this.decimalPlaces = n;
    }

    public static FrequencyStrategy createMillihertzFrequencyStrategy() {
        return new FrequencyStrategy(true, 3);
    }

    public static FrequencyStrategy createWithMaxDecimalPlaces(int n) {
        return new FrequencyStrategy(false, n);
    }

    public String format(long l) {
        String string = Frequency.normalize(this.convertFrequencyToMilliHertz(l));
        if (this.decimalPlaces != -1 && string.indexOf(".") != -1) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, string.indexOf(".")));
            int n = string.indexOf(".");
            for (int i = 0; string.charAt(n) != ' ' && i < this.decimalPlaces + 1; ++i) {
                stringBuffer.append(string.charAt(n++));
            }
            stringBuffer.append(string.substring(string.indexOf(" ")));
            return stringBuffer.toString();
        }
        return string;
    }

    public boolean decimalEntryAllowed() {
        return true;
    }

    public boolean isMilliHzMode() {
        return this.useMilliHzScaling;
    }

    private long convertFrequencyToMilliHertz(long l) {
        if (this.useMilliHzScaling) {
            return l;
        }
        return l * 1000L;
    }
}

