/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.strategies;

import elgato.infrastructure.strategies.ChannelAdjustmentStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.units.ChannelFrequencyConversion;
import elgato.infrastructure.util.chanstd.Band;
import elgato.infrastructure.util.chanstd.BandSelector;
import elgato.infrastructure.valueobject.ValueInterface;

public class FrequencyToChannelStrategy
extends NumberFieldStrategy {
    private final BandSelector bandSelector;

    public FrequencyToChannelStrategy(ValueInterface valueInterface, BandSelector bandSelector) {
        this.bandSelector = bandSelector;
        this.setAdjustmentStrategy(new ChannelAdjustmentStrategy(valueInterface, bandSelector));
    }

    public String format(long l) {
        return this.convert(l);
    }

    private BandSelector getBandSelector() {
        return this.bandSelector;
    }

    private String convert(long l) {
        Band band = Band.getCurrentBand(this.getBandSelector());
        if (band.isFrequencyFwdChannel(l)) {
            return ChannelFrequencyConversion.createForward(this.getBandSelector()).toString(l);
        }
        return ChannelFrequencyConversion.createReverse(this.getBandSelector()).toString(l);
    }
}

