/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.strategies;

import elgato.infrastructure.strategies.AdjustmentStrategy;
import elgato.infrastructure.strategies.PercentageAdjustmentStrategy;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;

public class NumberFieldStrategy {
    private final String units;
    private AdjustmentStrategy adjustmentStrategy = new PercentageAdjustmentStrategy();

    public NumberFieldStrategy() {
        this.units = null;
    }

    public NumberFieldStrategy(String string) {
        this.units = string;
    }

    protected final String addUnitsToValue(String string) {
        if (this.units != null) {
            return string + " " + this.units;
        }
        return string;
    }

    protected final String getUnits() {
        return this.units;
    }

    protected String getUnitsOrEnter() {
        return this.units != null ? this.units : Text.Enter;
    }

    public String format(long l) {
        return this.addUnitsToValue(String.valueOf(l));
    }

    public String[] formatWithUnits(long l, String[] stringArray) {
        String string = this.format(l);
        UIHelper.split(string, ' ', stringArray);
        return stringArray;
    }

    public boolean decimalEntryAllowed() {
        return false;
    }

    public AdjustmentStrategy getAdjustmentStrategy() {
        return this.adjustmentStrategy;
    }

    public void setAdjustmentStrategy(AdjustmentStrategy adjustmentStrategy) {
        this.adjustmentStrategy = adjustmentStrategy;
    }
}

